/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.-Base64;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio._JvmPlatformKt;
import okio.internal.-ByteString;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    public static final Companion Companion = new Companion(null);
    private final byte[] data;
    private transient int hashCode;
    private transient String utf8;
    public static final ByteString EMPTY = new ByteString(new byte[0]);

    public ByteString(byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.data = data;
    }

    public final byte[] getData$okio() {
        return this.data;
    }

    public final int getHashCode$okio() {
        return this.hashCode;
    }

    public final void setHashCode$okio(int n) {
        this.hashCode = n;
    }

    public final String getUtf8$okio() {
        return this.utf8;
    }

    public final void setUtf8$okio(String string) {
        this.utf8 = string;
    }

    /*
     * WARNING - void declaration
     */
    public String utf8() {
        void var3_3;
        ByteString $this$commonUtf8$iv = this;
        boolean $i$f$commonUtf8 = false;
        String result$iv = $this$commonUtf8$iv.getUtf8$okio();
        if (result$iv == null) {
            result$iv = _JvmPlatformKt.toUtf8String($this$commonUtf8$iv.internalArray$okio());
            $this$commonUtf8$iv.setUtf8$okio(result$iv);
        }
        return var3_3;
    }

    public String base64() {
        ByteString $this$commonBase64$iv = this;
        boolean $i$f$commonBase64 = false;
        return -Base64.encodeBase64$default($this$commonBase64$iv.getData$okio(), null, 1, null);
    }

    public final ByteString md5() {
        return this.digest$okio("MD5");
    }

    public final ByteString sha1() {
        return this.digest$okio("SHA-1");
    }

    public final ByteString sha256() {
        return this.digest$okio("SHA-256");
    }

    public ByteString digest$okio(String algorithm) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        MessageDigest $this$digest_u24lambda_u240 = MessageDigest.getInstance(algorithm);
        boolean bl = false;
        $this$digest_u24lambda_u240.update(this.data, 0, this.size());
        byte[] digestBytes = $this$digest_u24lambda_u240.digest();
        Intrinsics.checkNotNull(digestBytes);
        return new ByteString(digestBytes);
    }

    /*
     * WARNING - void declaration
     */
    public String hex() {
        ByteString $this$commonHex$iv = this;
        boolean $i$f$commonHex = false;
        char[] result$iv = new char[$this$commonHex$iv.getData$okio().length * 2];
        int c$iv = 0;
        for (byte b$iv : $this$commonHex$iv.getData$okio()) {
            void $this$and$iv$iv;
            byte $this$shr$iv$iv;
            int n = c$iv++;
            byte by = b$iv;
            int other$iv$iv = 4;
            boolean $i$f$shr = false;
            result$iv[n] = -ByteString.getHEX_DIGIT_CHARS()[$this$shr$iv$iv >> other$iv$iv & 0xF];
            int n2 = c$iv++;
            $this$shr$iv$iv = b$iv;
            other$iv$iv = 15;
            boolean $i$f$and = false;
            result$iv[n2] = -ByteString.getHEX_DIGIT_CHARS()[$this$and$iv$iv & other$iv$iv];
        }
        return StringsKt.concatToString(result$iv);
    }

    /*
     * WARNING - void declaration
     */
    public ByteString toAsciiLowercase() {
        ByteString byteString;
        block4: {
            void var1_1;
            ByteString $this$commonToAsciiLowercase$iv = this;
            boolean $i$f$commonToAsciiLowercase = false;
            for (int i$iv = 0; i$iv < $this$commonToAsciiLowercase$iv.getData$okio().length; ++i$iv) {
                byte c$iv = $this$commonToAsciiLowercase$iv.getData$okio()[i$iv];
                if (c$iv < 65 || c$iv > 90) {
                    continue;
                }
                byte[] byArray = $this$commonToAsciiLowercase$iv.getData$okio();
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
                byte[] lowercase$iv = byArray2;
                lowercase$iv[i$iv++] = (byte)(c$iv - -32);
                while (i$iv < lowercase$iv.length) {
                    c$iv = lowercase$iv[i$iv];
                    if (c$iv < 65 || c$iv > 90) {
                        ++i$iv;
                        continue;
                    }
                    lowercase$iv[i$iv] = (byte)(c$iv - -32);
                    ++i$iv;
                }
                byteString = new ByteString(lowercase$iv);
                break block4;
            }
            byteString = var1_1;
        }
        return byteString;
    }

    public byte internalGet$okio(int pos) {
        ByteString $this$commonGetByte$iv = this;
        boolean $i$f$commonGetByte = false;
        return $this$commonGetByte$iv.getData$okio()[pos];
    }

    public final byte getByte(int index) {
        return this.internalGet$okio(index);
    }

    public final int size() {
        return this.getSize$okio();
    }

    public int getSize$okio() {
        ByteString $this$commonGetSize$iv = this;
        boolean $i$f$commonGetSize = false;
        return $this$commonGetSize$iv.getData$okio().length;
    }

    public byte[] toByteArray() {
        ByteString $this$commonToByteArray$iv = this;
        boolean $i$f$commonToByteArray = false;
        byte[] byArray = $this$commonToByteArray$iv.getData$okio();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
        return byArray2;
    }

    public byte[] internalArray$okio() {
        ByteString $this$commonInternalArray$iv = this;
        boolean $i$f$commonInternalArray = false;
        return $this$commonInternalArray$iv.getData$okio();
    }

    public void write$okio(Buffer buffer, int offset, int byteCount) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        -ByteString.commonWrite(this, buffer, offset, byteCount);
    }

    public boolean rangeEquals(int offset, ByteString other, int otherOffset, int byteCount) {
        Intrinsics.checkNotNullParameter(other, "other");
        ByteString $this$commonRangeEquals$iv = this;
        boolean $i$f$commonRangeEquals = false;
        return other.rangeEquals(otherOffset, $this$commonRangeEquals$iv.getData$okio(), offset, byteCount);
    }

    public boolean rangeEquals(int offset, byte[] other, int otherOffset, int byteCount) {
        Intrinsics.checkNotNullParameter(other, "other");
        ByteString $this$commonRangeEquals$iv = this;
        boolean $i$f$commonRangeEquals = false;
        return offset >= 0 && offset <= $this$commonRangeEquals$iv.getData$okio().length - byteCount && otherOffset >= 0 && otherOffset <= other.length - byteCount && -SegmentedByteString.arrayRangeEquals($this$commonRangeEquals$iv.getData$okio(), offset, other, otherOffset, byteCount);
    }

    public final boolean startsWith(ByteString prefix) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        ByteString $this$commonStartsWith$iv = this;
        boolean $i$f$commonStartsWith = false;
        return $this$commonStartsWith$iv.rangeEquals(0, prefix, 0, prefix.size());
    }

    public boolean equals(Object other) {
        ByteString $this$commonEquals$iv = this;
        boolean $i$f$commonEquals = false;
        return other == $this$commonEquals$iv ? true : (other instanceof ByteString ? ((ByteString)other).size() == $this$commonEquals$iv.getData$okio().length && ((ByteString)other).rangeEquals(0, $this$commonEquals$iv.getData$okio(), 0, $this$commonEquals$iv.getData$okio().length) : false);
    }

    public int hashCode() {
        int n;
        ByteString $this$commonHashCode$iv = this;
        boolean $i$f$commonHashCode = false;
        int result$iv = $this$commonHashCode$iv.getHashCode$okio();
        if (result$iv != 0) {
            n = result$iv;
        } else {
            int n2;
            int it$iv = n2 = Arrays.hashCode($this$commonHashCode$iv.getData$okio());
            boolean bl = false;
            $this$commonHashCode$iv.setHashCode$okio(it$iv);
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(ByteString other) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(other, "other");
            ByteString $this$commonCompareTo$iv = this;
            boolean $i$f$commonCompareTo = false;
            int sizeA$iv = $this$commonCompareTo$iv.size();
            int sizeB$iv = other.size();
            int size$iv = Math.min(sizeA$iv, sizeB$iv);
            for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                void $this$and$iv$iv;
                void $this$and$iv$iv2;
                byte by = $this$commonCompareTo$iv.getByte(i$iv);
                int other$iv$iv = 255;
                boolean $i$f$and = false;
                int byteA$iv = $this$and$iv$iv2 & other$iv$iv;
                other$iv$iv = other.getByte(i$iv);
                int other$iv$iv2 = 255;
                boolean $i$f$and2 = false;
                int byteB$iv = $this$and$iv$iv & other$iv$iv2;
                if (byteA$iv == byteB$iv) {
                    continue;
                }
                n = byteA$iv < byteB$iv ? -1 : 1;
                break block2;
            }
            n = sizeA$iv == sizeB$iv ? 0 : (sizeA$iv < sizeB$iv ? -1 : 1);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        String string;
        ByteString $this$commonToString$iv = this;
        boolean $i$f$commonToString = false;
        if ($this$commonToString$iv.getData$okio().length == 0) {
            string = "[size=0]";
        } else {
            int i$iv = -ByteString.access$codePointIndexToCharIndex($this$commonToString$iv.getData$okio(), 64);
            if (i$iv == -1) {
                if ($this$commonToString$iv.getData$okio().length <= 64) {
                    string = "[hex=" + $this$commonToString$iv.hex() + ']';
                } else {
                    ByteString byteString;
                    void beginIndex$iv$iv;
                    void $this$commonSubstring$iv$iv;
                    StringBuilder stringBuilder = new StringBuilder().append("[size=").append($this$commonToString$iv.getData$okio().length).append(" hex=");
                    ByteString byteString2 = $this$commonToString$iv;
                    boolean bl = false;
                    int endIndex$iv$iv = 64;
                    boolean $i$f$commonSubstring = false;
                    int endIndex$iv$iv2 = -SegmentedByteString.resolveDefaultParameter((ByteString)$this$commonSubstring$iv$iv, endIndex$iv$iv);
                    if (!(endIndex$iv$iv2 <= $this$commonSubstring$iv$iv.getData$okio().length)) {
                        boolean bl2 = false;
                        String string2 = "endIndex > length(" + $this$commonSubstring$iv$iv.getData$okio().length + ')';
                        throw new IllegalArgumentException(string2.toString());
                    }
                    int subLen$iv$iv = endIndex$iv$iv2 - beginIndex$iv$iv;
                    if (!(subLen$iv$iv >= 0)) {
                        boolean bl3 = false;
                        String string3 = "endIndex < beginIndex";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    if (endIndex$iv$iv2 == $this$commonSubstring$iv$iv.getData$okio().length) {
                        byteString = $this$commonSubstring$iv$iv;
                    } else {
                        byte[] byArray = $this$commonSubstring$iv$iv.getData$okio();
                        ByteString byteString3 = new ByteString(ArraysKt.copyOfRange(byArray, (int)beginIndex$iv$iv, endIndex$iv$iv2));
                        byteString = byteString3;
                    }
                    string = stringBuilder.append(byteString.hex()).append("\u2026]").toString();
                }
            } else {
                String text$iv = $this$commonToString$iv.utf8();
                String string4 = text$iv.substring(0, i$iv);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                String safeText$iv = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(string4, "\\", "\\\\", false, 4, null), "\n", "\\n", false, 4, null), "\r", "\\r", false, 4, null);
                string = i$iv < text$iv.length() ? "[size=" + $this$commonToString$iv.getData$okio().length + " text=" + safeText$iv + "\u2026]" : "[text=" + safeText$iv + ']';
            }
        }
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public final ByteString of(byte[] $this$toByteString, int offset, int byteCount) {
            Intrinsics.checkNotNullParameter($this$toByteString, "<this>");
            byte[] $this$commonToByteString$iv = $this$toByteString;
            boolean $i$f$commonToByteString = false;
            int byteCount$iv = -SegmentedByteString.resolveDefaultParameter($this$commonToByteString$iv, byteCount);
            -SegmentedByteString.checkOffsetAndCount($this$commonToByteString$iv.length, offset, byteCount$iv);
            byte[] byArray = $this$commonToByteString$iv;
            int n = offset + byteCount$iv;
            return new ByteString(ArraysKt.copyOfRange(byArray, offset, n));
        }

        public static /* synthetic */ ByteString of$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = -SegmentedByteString.getDEFAULT__ByteString_size();
            }
            return companion.of(byArray, n, n2);
        }

        public final ByteString encodeUtf8(String $this$encodeUtf8) {
            Intrinsics.checkNotNullParameter($this$encodeUtf8, "<this>");
            String $this$commonEncodeUtf8$iv = $this$encodeUtf8;
            boolean $i$f$commonEncodeUtf8 = false;
            ByteString byteString$iv = new ByteString(_JvmPlatformKt.asUtf8ToByteArray($this$commonEncodeUtf8$iv));
            byteString$iv.setUtf8$okio($this$commonEncodeUtf8$iv);
            return byteString$iv;
        }

        public final ByteString encodeString(String $this$encode, Charset charset) {
            Intrinsics.checkNotNullParameter($this$encode, "<this>");
            Intrinsics.checkNotNullParameter(charset, "charset");
            byte[] byArray = $this$encode.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            return new ByteString(byArray);
        }

        public final ByteString decodeBase64(String $this$decodeBase64) {
            Intrinsics.checkNotNullParameter($this$decodeBase64, "<this>");
            String $this$commonDecodeBase64$iv = $this$decodeBase64;
            boolean $i$f$commonDecodeBase64 = false;
            byte[] decoded$iv = -Base64.decodeBase64ToArray($this$commonDecodeBase64$iv);
            return decoded$iv != null ? new ByteString(decoded$iv) : null;
        }

        public final ByteString decodeHex(String $this$decodeHex) {
            Intrinsics.checkNotNullParameter($this$decodeHex, "<this>");
            String $this$commonDecodeHex$iv = $this$decodeHex;
            boolean $i$f$commonDecodeHex = false;
            if (!($this$commonDecodeHex$iv.length() % 2 == 0)) {
                boolean $i$a$-require--ByteString$commonDecodeHex$1$iv22 = false;
                String $i$a$-require--ByteString$commonDecodeHex$1$iv22 = "Unexpected hex string: " + $this$commonDecodeHex$iv;
                throw new IllegalArgumentException($i$a$-require--ByteString$commonDecodeHex$1$iv22.toString());
            }
            byte[] result$iv = new byte[$this$commonDecodeHex$iv.length() / 2];
            int n = result$iv.length;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                int d1$iv = -ByteString.access$decodeHexDigit($this$commonDecodeHex$iv.charAt(i$iv * 2)) << 4;
                int d2$iv = -ByteString.access$decodeHexDigit($this$commonDecodeHex$iv.charAt(i$iv * 2 + 1));
                result$iv[i$iv] = (byte)(d1$iv + d2$iv);
            }
            return new ByteString(result$iv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

