/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.BouncyCastlePlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.platform.OpenJSSEPlatform;
import okhttp3.internal.platform.android.AndroidLog;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import okio.Buffer;

public class Platform {
    public static final Companion Companion = new Companion(null);
    private static volatile Platform platform = okhttp3.internal.platform.Platform$Companion.access$findPlatform(Companion);
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public final String getPrefix() {
        return "OkHttp";
    }

    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\")");
        return sSLContext;
    }

    public X509TrustManager platformTrustManager() {
        TrustManagerFactory factory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory2.init((KeyStore)null);
        Object[] objectArray = factory2.getTrustManagers();
        Intrinsics.checkNotNull(objectArray);
        Object[] trustManagers = objectArray;
        if (!(trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
            boolean bl = false;
            String string = Arrays.toString(trustManagers);
            Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
            String string2 = Intrinsics.stringPlus("Unexpected default trust managers: ", string);
            throw new IllegalStateException(string2.toString());
        }
        TrustManager trustManager = trustManagers[0];
        if (trustManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        return (X509TrustManager)trustManager;
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(protocols, "protocols");
    }

    public void afterHandshake(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
    }

    public String getSelectedProtocol(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(address, "address");
        socket.connect(address, connectTimeout);
    }

    public void log(String message, int level, Throwable t) {
        Intrinsics.checkNotNullParameter(message, "message");
        Level logLevel = level == 5 ? Level.WARNING : Level.INFO;
        logger.log(logLevel, message, t);
    }

    public static /* synthetic */ void log$default(Platform platform, String string, int n, Throwable throwable, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        platform.log(string, n, throwable);
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        return true;
    }

    public Object getStackTraceForCloseable(String closer) {
        Intrinsics.checkNotNullParameter(closer, "closer");
        return logger.isLoggable(Level.FINE) ? new Throwable(closer) : null;
    }

    public void logCloseableLeak(String message, Object stackTrace) {
        Intrinsics.checkNotNullParameter(message, "message");
        String logMessage = message;
        if (stackTrace == null) {
            logMessage = Intrinsics.stringPlus(logMessage, " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);");
        }
        this.log(logMessage, 5, (Throwable)stackTrace);
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter(trustManager, "trustManager");
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(trustManager));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter(trustManager, "trustManager");
        X509Certificate[] x509CertificateArray = trustManager.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue(x509CertificateArray, "trustManager.acceptedIssuers");
        X509Certificate[] x509CertificateArray2 = x509CertificateArray;
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray2, x509CertificateArray2.length));
    }

    public SSLSocketFactory newSslSocketFactory(X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter(trustManager, "trustManager");
        try {
            SSLContext sSLContext;
            SSLContext $this$newSslSocketFactory_u24lambda_u2d1 = sSLContext = this.newSSLContext();
            boolean bl = false;
            TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
            $this$newSslSocketFactory_u24lambda_u2d1.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "newSSLContext().apply {\n\u2026ll)\n      }.socketFactory");
            return sSLSocketFactory;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError(Intrinsics.stringPlus("No System TLS: ", e), e);
        }
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "javaClass.simpleName");
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public final Platform get() {
            return platform;
        }

        /*
         * WARNING - void declaration
         */
        public final List<String> alpnProtocolNames(List<? extends Protocol> protocols) {
            void $this$mapTo$iv$iv;
            Protocol it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(protocols, "protocols");
            Iterable $this$filter$iv = protocols;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Protocol)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != Protocol.HTTP_1_0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Protocol)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            return (List)destination$iv$iv;
        }

        public final boolean isAndroid() {
            return Intrinsics.areEqual("Dalvik", System.getProperty("java.vm.name"));
        }

        private final boolean isConscryptPreferred() {
            String preferredProvider = Security.getProviders()[0].getName();
            return Intrinsics.areEqual("Conscrypt", preferredProvider);
        }

        private final boolean isOpenJSSEPreferred() {
            String preferredProvider = Security.getProviders()[0].getName();
            return Intrinsics.areEqual("OpenJSSE", preferredProvider);
        }

        private final boolean isBouncyCastlePreferred() {
            String preferredProvider = Security.getProviders()[0].getName();
            return Intrinsics.areEqual("BC", preferredProvider);
        }

        private final Platform findPlatform() {
            return this.isAndroid() ? this.findAndroidPlatform() : this.findJvmPlatform();
        }

        private final Platform findAndroidPlatform() {
            AndroidLog.INSTANCE.enable();
            Platform platform = Android10Platform.Companion.buildIfSupported();
            if (platform == null) {
                Platform platform2 = AndroidPlatform.Companion.buildIfSupported();
                platform = platform2;
                Intrinsics.checkNotNull(platform2);
            }
            return platform;
        }

        private final Platform findJvmPlatform() {
            OpenJSSEPlatform openJSSE;
            BouncyCastlePlatform bc;
            ConscryptPlatform conscrypt;
            if (this.isConscryptPreferred() && (conscrypt = ConscryptPlatform.Companion.buildIfSupported()) != null) {
                return conscrypt;
            }
            if (this.isBouncyCastlePreferred() && (bc = BouncyCastlePlatform.Companion.buildIfSupported()) != null) {
                return bc;
            }
            if (this.isOpenJSSEPreferred() && (openJSSE = OpenJSSEPlatform.Companion.buildIfSupported()) != null) {
                return openJSSE;
            }
            Jdk9Platform jdk9 = Jdk9Platform.Companion.buildIfSupported();
            if (jdk9 != null) {
                return jdk9;
            }
            Platform jdkWithJettyBoot = Jdk8WithJettyBootPlatform.Companion.buildIfSupported();
            if (jdkWithJettyBoot != null) {
                return jdkWithJettyBoot;
            }
            return new Platform();
        }

        public final byte[] concatLengthPrefixed(List<? extends Protocol> protocols) {
            Intrinsics.checkNotNullParameter(protocols, "protocols");
            Buffer result2 = new Buffer();
            for (String protocol : this.alpnProtocolNames(protocols)) {
                result2.writeByte(protocol.length());
                result2.writeUtf8(protocol);
            }
            return result2.readByteArray();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Platform access$findPlatform(Companion $this) {
            return $this.findPlatform();
        }
    }
}

