/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

public final class Hpack {
    public static final Hpack INSTANCE = new Hpack();
    private static final Header[] STATIC_HEADER_TABLE;
    private static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;

    private Hpack() {
    }

    public final Header[] getSTATIC_HEADER_TABLE() {
        return STATIC_HEADER_TABLE;
    }

    public final Map<ByteString, Integer> getNAME_TO_FIRST_INDEX() {
        return NAME_TO_FIRST_INDEX;
    }

    private final Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap result2 = new LinkedHashMap(STATIC_HEADER_TABLE.length);
        int n = 0;
        int n2 = STATIC_HEADER_TABLE.length;
        while (n < n2) {
            int i = n++;
            if (result2.containsKey(Hpack.STATIC_HEADER_TABLE[i].name)) continue;
            Map map2 = result2;
            ByteString byteString = Hpack.STATIC_HEADER_TABLE[i].name;
            Integer n3 = i;
            map2.put(byteString, n3);
        }
        Map<ByteString, Integer> map3 = Collections.unmodifiableMap(result2);
        Intrinsics.checkNotNullExpressionValue(map3, "unmodifiableMap(result)");
        return map3;
    }

    public final ByteString checkLowercase(ByteString name) throws IOException {
        Intrinsics.checkNotNullParameter(name, "name");
        int n = 0;
        int n2 = name.size();
        while (n < n2) {
            int i;
            byte by;
            boolean bl = 65 <= (by = name.getByte(i = n++)) ? by <= 90 : false;
            if (!bl) continue;
            throw new IOException(Intrinsics.stringPlus("PROTOCOL_ERROR response malformed: mixed case name: ", name.utf8()));
        }
        return name;
    }

    static {
        Header[] headerArray = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
        STATIC_HEADER_TABLE = headerArray;
        NAME_TO_FIRST_INDEX = INSTANCE.nameToFirstIndex();
    }

    public static final class Reader {
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        private final List<Header> headerList;
        private final BufferedSource source;
        public Header[] dynamicTable;
        private int nextHeaderIndex;
        public int headerCount;
        public int dynamicTableByteCount;

        public Reader(Source source2, int headerTableSizeSetting, int maxDynamicTableByteCount) {
            Intrinsics.checkNotNullParameter(source2, "source");
            this.headerTableSizeSetting = headerTableSizeSetting;
            this.maxDynamicTableByteCount = maxDynamicTableByteCount;
            this.headerList = new ArrayList();
            this.source = Okio.buffer(source2);
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Reader(Source source2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = n;
            }
            this(source2, n, n2);
        }

        public final List<Header> getAndResetHeaderList() {
            List<Header> result2 = CollectionsKt.toList((Iterable)this.headerList);
            this.headerList.clear();
            return result2;
        }

        private final void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }

        private final void clearDynamicTable() {
            ArraysKt.fill$default(this.dynamicTable, null, 0, 0, 6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private final int evictToRecoverBytes(int bytesToRecover) {
            int bytesToRecover2 = bytesToRecover;
            int entriesToEvict = 0;
            if (bytesToRecover2 > 0) {
                int j = this.dynamicTable.length - 1;
                while (j >= this.nextHeaderIndex && bytesToRecover2 > 0) {
                    Header toEvict;
                    Intrinsics.checkNotNull(this.dynamicTable[j]);
                    bytesToRecover2 -= toEvict.hpackSize;
                    this.dynamicTableByteCount -= toEvict.hpackSize;
                    int n = this.headerCount;
                    this.headerCount = n + -1;
                    n = entriesToEvict;
                    entriesToEvict = n + 1;
                    n = j;
                    j = n + -1;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + entriesToEvict, this.headerCount);
                this.nextHeaderIndex += entriesToEvict;
            }
            return entriesToEvict;
        }

        public final void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int index;
                int b = Util.and(this.source.readByte(), 255);
                if (b == 128) {
                    throw new IOException("index == 0");
                }
                if ((b & 0x80) == 128) {
                    index = this.readInt(b, 127);
                    this.readIndexedHeader(index - 1);
                    continue;
                }
                if (b == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((b & 0x40) == 64) {
                    index = this.readInt(b, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(index - 1);
                    continue;
                }
                if ((b & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(b, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException(Intrinsics.stringPlus("Invalid dynamic table size update ", this.maxDynamicTableByteCount));
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (b == 16 || b == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                index = this.readInt(b, 15);
                this.readLiteralHeaderWithoutIndexingIndexedName(index - 1);
            }
        }

        private final void readIndexedHeader(int index) throws IOException {
            if (this.isStaticHeader(index)) {
                Header staticEntry = INSTANCE.getSTATIC_HEADER_TABLE()[index];
                this.headerList.add(staticEntry);
            } else {
                int dynamicTableIndex = this.dynamicTableIndex(index - INSTANCE.getSTATIC_HEADER_TABLE().length);
                if (dynamicTableIndex < 0 || dynamicTableIndex >= this.dynamicTable.length) {
                    throw new IOException(Intrinsics.stringPlus("Header index too large ", index + 1));
                }
                Collection collection = this.headerList;
                Header header = this.dynamicTable[dynamicTableIndex];
                Intrinsics.checkNotNull(header);
                collection.add(header);
            }
        }

        private final int dynamicTableIndex(int index) {
            return this.nextHeaderIndex + 1 + index;
        }

        private final void readLiteralHeaderWithoutIndexingIndexedName(int index) throws IOException {
            ByteString name = this.getName(index);
            ByteString value = this.readByteString();
            this.headerList.add(new Header(name, value));
        }

        private final void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString name = INSTANCE.checkLowercase(this.readByteString());
            ByteString value = this.readByteString();
            this.headerList.add(new Header(name, value));
        }

        private final void readLiteralHeaderWithIncrementalIndexingIndexedName(int nameIndex) throws IOException {
            ByteString name = this.getName(nameIndex);
            ByteString value = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(name, value));
        }

        private final void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            ByteString name = INSTANCE.checkLowercase(this.readByteString());
            ByteString value = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(name, value));
        }

        private final ByteString getName(int index) throws IOException {
            ByteString byteString;
            if (this.isStaticHeader(index)) {
                byteString = Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[index].name;
            } else {
                int dynamicTableIndex = this.dynamicTableIndex(index - INSTANCE.getSTATIC_HEADER_TABLE().length);
                if (dynamicTableIndex < 0 || dynamicTableIndex >= this.dynamicTable.length) {
                    throw new IOException(Intrinsics.stringPlus("Header index too large ", index + 1));
                }
                Header header = this.dynamicTable[dynamicTableIndex];
                Intrinsics.checkNotNull(header);
                byteString = header.name;
            }
            return byteString;
        }

        private final boolean isStaticHeader(int index) {
            return index >= 0 && index <= INSTANCE.getSTATIC_HEADER_TABLE().length - 1;
        }

        private final void insertIntoDynamicTable(int index, Header entry) {
            int index2 = index;
            this.headerList.add(entry);
            int delta = entry.hpackSize;
            if (index2 != -1) {
                Header header = this.dynamicTable[this.dynamicTableIndex(index2)];
                Intrinsics.checkNotNull(header);
                delta -= header.hpackSize;
            }
            if (delta > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int bytesToRecover = this.dynamicTableByteCount + delta - this.maxDynamicTableByteCount;
            int entriesEvicted = this.evictToRecoverBytes(bytesToRecover);
            if (index2 == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] doubled = new Header[this.dynamicTable.length * 2];
                    System.arraycopy(this.dynamicTable, 0, doubled, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = doubled;
                }
                int n = this.nextHeaderIndex;
                this.nextHeaderIndex = n + -1;
                index2 = n;
                this.dynamicTable[index2] = entry;
                n = this.headerCount;
                this.headerCount = n + 1;
            } else {
                index2 += this.dynamicTableIndex(index2) + entriesEvicted;
                this.dynamicTable[index2] = entry;
            }
            this.dynamicTableByteCount += delta;
        }

        private final int readByte() throws IOException {
            return Util.and(this.source.readByte(), 255);
        }

        public final int readInt(int firstByte, int prefixMask) throws IOException {
            int b;
            int prefix = firstByte & prefixMask;
            if (prefix < prefixMask) {
                return prefix;
            }
            int result2 = prefixMask;
            int shift = 0;
            while (((b = this.readByte()) & 0x80) != 0) {
                result2 += (b & 0x7F) << shift;
                shift += 7;
            }
            return result2 += b << shift;
        }

        public final ByteString readByteString() throws IOException {
            ByteString byteString;
            int firstByte = this.readByte();
            boolean huffmanDecode = (firstByte & 0x80) == 128;
            long length = this.readInt(firstByte, 127);
            if (huffmanDecode) {
                Buffer decodeBuffer = new Buffer();
                Huffman.INSTANCE.decode(this.source, length, decodeBuffer);
                byteString = decodeBuffer.readByteString();
            } else {
                byteString = this.source.readByteString(length);
            }
            return byteString;
        }
    }

    public static final class Writer {
        public int headerTableSizeSetting;
        private final boolean useCompression;
        private final Buffer out;
        private int smallestHeaderTableSizeSetting;
        private boolean emitDynamicTableSizeUpdate;
        public int maxDynamicTableByteCount;
        public Header[] dynamicTable;
        private int nextHeaderIndex;
        public int headerCount;
        public int dynamicTableByteCount;

        public Writer(int headerTableSizeSetting, boolean useCompression, Buffer out) {
            Intrinsics.checkNotNullParameter(out, "out");
            this.headerTableSizeSetting = headerTableSizeSetting;
            this.useCompression = useCompression;
            this.out = out;
            this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            this.maxDynamicTableByteCount = this.headerTableSizeSetting;
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Writer(int n, boolean bl, Buffer buffer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 4096;
            }
            if ((n2 & 2) != 0) {
                bl = true;
            }
            this(n, bl, buffer);
        }

        private final void clearDynamicTable() {
            ArraysKt.fill$default(this.dynamicTable, null, 0, 0, 6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private final int evictToRecoverBytes(int bytesToRecover) {
            int bytesToRecover2 = bytesToRecover;
            int entriesToEvict = 0;
            if (bytesToRecover2 > 0) {
                int j = this.dynamicTable.length - 1;
                while (j >= this.nextHeaderIndex && bytesToRecover2 > 0) {
                    Header header = this.dynamicTable[j];
                    Intrinsics.checkNotNull(header);
                    bytesToRecover2 -= header.hpackSize;
                    Header header2 = this.dynamicTable[j];
                    Intrinsics.checkNotNull(header2);
                    this.dynamicTableByteCount -= header2.hpackSize;
                    int n = this.headerCount;
                    this.headerCount = n + -1;
                    n = entriesToEvict;
                    entriesToEvict = n + 1;
                    n = j;
                    j = n + -1;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + entriesToEvict, this.headerCount);
                Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + entriesToEvict, null);
                this.nextHeaderIndex += entriesToEvict;
            }
            return entriesToEvict;
        }

        private final void insertIntoDynamicTable(Header entry) {
            int delta = entry.hpackSize;
            if (delta > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int bytesToRecover = this.dynamicTableByteCount + delta - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(bytesToRecover);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] doubled = new Header[this.dynamicTable.length * 2];
                System.arraycopy(this.dynamicTable, 0, doubled, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = doubled;
            }
            int n = this.nextHeaderIndex;
            this.nextHeaderIndex = n + -1;
            int index = n;
            this.dynamicTable[index] = entry;
            n = this.headerCount;
            this.headerCount = n + 1;
            this.dynamicTableByteCount += delta;
        }

        public final void writeHeaders(List<Header> headerBlock) throws IOException {
            Intrinsics.checkNotNullParameter(headerBlock, "headerBlock");
            if (this.emitDynamicTableSizeUpdate) {
                if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                    this.writeInt(this.smallestHeaderTableSizeSetting, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            int n = 0;
            int n2 = headerBlock.size();
            while (n < n2) {
                int i = n++;
                Header header = headerBlock.get(i);
                ByteString name = header.name.toAsciiLowercase();
                ByteString value = header.value;
                int headerIndex = -1;
                int headerNameIndex = -1;
                Integer staticIndex = INSTANCE.getNAME_TO_FIRST_INDEX().get(name);
                if (staticIndex != null) {
                    headerNameIndex = staticIndex + 1;
                    boolean bl = 2 <= headerNameIndex ? headerNameIndex < 8 : false;
                    if (bl) {
                        if (Intrinsics.areEqual(Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[headerNameIndex - 1].value, value)) {
                            headerIndex = headerNameIndex;
                        } else if (Intrinsics.areEqual(Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[headerNameIndex].value, value)) {
                            headerIndex = headerNameIndex + 1;
                        }
                    }
                }
                if (headerIndex == -1) {
                    int n3 = this.nextHeaderIndex + 1;
                    int n4 = this.dynamicTable.length;
                    while (n3 < n4) {
                        int j = n3++;
                        Header header2 = this.dynamicTable[j];
                        Intrinsics.checkNotNull(header2);
                        if (!Intrinsics.areEqual(header2.name, name)) continue;
                        Header header3 = this.dynamicTable[j];
                        Intrinsics.checkNotNull(header3);
                        if (Intrinsics.areEqual(header3.value, value)) {
                            headerIndex = j - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                            break;
                        }
                        if (headerNameIndex != -1) continue;
                        headerNameIndex = j - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                    }
                }
                if (headerIndex != -1) {
                    this.writeInt(headerIndex, 127, 128);
                    continue;
                }
                if (headerNameIndex == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(name);
                    this.writeByteString(value);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (name.startsWith(Header.PSEUDO_PREFIX) && !Intrinsics.areEqual(Header.TARGET_AUTHORITY, name)) {
                    this.writeInt(headerNameIndex, 15, 0);
                    this.writeByteString(value);
                    continue;
                }
                this.writeInt(headerNameIndex, 63, 64);
                this.writeByteString(value);
                this.insertIntoDynamicTable(header);
            }
        }

        public final void writeInt(int value, int prefixMask, int bits) {
            int value2 = value;
            if (value2 < prefixMask) {
                this.out.writeByte(bits | value2);
                return;
            }
            this.out.writeByte(bits | prefixMask);
            value2 -= prefixMask;
            while (value2 >= 128) {
                int b = value2 & 0x7F;
                this.out.writeByte(b | 0x80);
                value2 >>>= 7;
            }
            this.out.writeByte(value2);
        }

        public final void writeByteString(ByteString data) throws IOException {
            Intrinsics.checkNotNullParameter(data, "data");
            if (this.useCompression && Huffman.INSTANCE.encodedLength(data) < data.size()) {
                Buffer huffmanBuffer = new Buffer();
                Huffman.INSTANCE.encode(data, huffmanBuffer);
                ByteString huffmanBytes = huffmanBuffer.readByteString();
                this.writeInt(huffmanBytes.size(), 127, 128);
                this.out.write(huffmanBytes);
            } else {
                this.writeInt(data.size(), 127, 0);
                this.out.write(data);
            }
        }

        public final void resizeHeaderTable(int headerTableSizeSetting) {
            this.headerTableSizeSetting = headerTableSizeSetting;
            int n = 16384;
            int effectiveHeaderTableSize = Math.min(headerTableSizeSetting, n);
            if (this.maxDynamicTableByteCount == effectiveHeaderTableSize) {
                return;
            }
            if (effectiveHeaderTableSize < this.maxDynamicTableByteCount) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, effectiveHeaderTableSize);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = effectiveHeaderTableSize;
            this.adjustDynamicTableByteCount();
        }

        private final void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }
    }
}

