/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okio.Buffer;

public final class HttpUrl {
    public static final Companion Companion = new Companion(null);
    private final String scheme;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    private final String fragment;
    private final String url;
    private final boolean isHttps;
    private static final char[] HEX_DIGITS;

    public HttpUrl(String scheme, String username, String password, String host, int port, List<String> pathSegments, List<String> queryNamesAndValues, String fragment, String url) {
        Intrinsics.checkNotNullParameter(scheme, "scheme");
        Intrinsics.checkNotNullParameter(username, "username");
        Intrinsics.checkNotNullParameter(password, "password");
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(pathSegments, "pathSegments");
        Intrinsics.checkNotNullParameter(url, "url");
        this.scheme = scheme;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.pathSegments = pathSegments;
        this.queryNamesAndValues = queryNamesAndValues;
        this.fragment = fragment;
        this.url = url;
        this.isHttps = Intrinsics.areEqual(this.scheme, "https");
    }

    public final String scheme() {
        return this.scheme;
    }

    public final String host() {
        return this.host;
    }

    public final int port() {
        return this.port;
    }

    public final boolean isHttps() {
        return this.isHttps;
    }

    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public final URI uri() {
        URI uRI;
        String uri = this.newBuilder().reencodeForUri$okhttp().toString();
        try {
            uRI = new URI(uri);
        }
        catch (URISyntaxException e) {
            URI uRI2;
            try {
                CharSequence charSequence = uri;
                Regex regex = new Regex("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]");
                String string = "";
                String stripped = regex.replace(charSequence, string);
                uRI2 = URI.create(stripped);
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
            URI uRI3 = uRI2;
            Intrinsics.checkNotNullExpressionValue(uRI3, "{\n      // Unlikely edge\u2026Unexpected!\n      }\n    }");
            uRI = uRI3;
        }
        return uRI;
    }

    public final String encodedUsername() {
        if (((CharSequence)this.username).length() == 0) {
            return "";
        }
        int usernameStart = this.scheme.length() + 3;
        int usernameEnd = Util.delimiterOffset(this.url, ":@", usernameStart, this.url.length());
        String string = this.url.substring(usernameStart, usernameEnd);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final String encodedPassword() {
        if (((CharSequence)this.password).length() == 0) {
            return "";
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)this.url, ':', this.scheme.length() + 3, false, 4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)this.url, '@', 0, false, 6, null);
        String string = this.url.substring(passwordStart, passwordEnd);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final String encodedPath() {
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, '/', this.scheme.length() + 3, false, 4, null);
        int pathEnd = Util.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        String string = this.url.substring(pathStart, pathEnd);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final List<String> encodedPathSegments() {
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, '/', this.scheme.length() + 3, false, 4, null);
        int pathEnd = Util.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        List result2 = new ArrayList();
        int i = pathStart;
        while (i < pathEnd) {
            int n = i;
            i = n + 1;
            int segmentEnd = Util.delimiterOffset(this.url, '/', i, pathEnd);
            String string = this.url.substring(i, segmentEnd);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            result2.add(string);
            i = segmentEnd;
        }
        return result2;
    }

    public final String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int queryStart = StringsKt.indexOf$default((CharSequence)this.url, '?', 0, false, 6, null) + 1;
        int queryEnd = Util.delimiterOffset(this.url, '#', queryStart, this.url.length());
        String string = this.url.substring(queryStart, queryEnd);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder result2 = new StringBuilder();
        Companion.toQueryString$okhttp(this.queryNamesAndValues, result2);
        return result2.toString();
    }

    public final String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int fragmentStart = StringsKt.indexOf$default((CharSequence)this.url, '#', 0, false, 6, null) + 1;
        String string = this.url.substring(fragmentStart);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        return string;
    }

    public final String redact() {
        Builder builder = this.newBuilder("/...");
        Intrinsics.checkNotNull(builder);
        return builder.username("").password("").build().toString();
    }

    public final HttpUrl resolve(String link) {
        Intrinsics.checkNotNullParameter(link, "link");
        Builder builder = this.newBuilder(link);
        return builder == null ? null : builder.build();
    }

    public final Builder newBuilder() {
        Builder result2 = new Builder();
        result2.setScheme$okhttp(this.scheme);
        result2.setEncodedUsername$okhttp(this.encodedUsername());
        result2.setEncodedPassword$okhttp(this.encodedPassword());
        result2.setHost$okhttp(this.host);
        result2.setPort$okhttp(this.port != Companion.defaultPort(this.scheme) ? this.port : -1);
        result2.getEncodedPathSegments$okhttp().clear();
        result2.getEncodedPathSegments$okhttp().addAll((Collection<String>)this.encodedPathSegments());
        result2.encodedQuery(this.encodedQuery());
        result2.setEncodedFragment$okhttp(this.encodedFragment());
        return result2;
    }

    public final Builder newBuilder(String link) {
        Builder builder;
        Intrinsics.checkNotNullParameter(link, "link");
        try {
            builder = new Builder().parse$okhttp(this, link);
        }
        catch (IllegalArgumentException _) {
            builder = null;
        }
        return builder;
    }

    public boolean equals(Object other) {
        return other instanceof HttpUrl && Intrinsics.areEqual(((HttpUrl)other).url, this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HEX_DIGITS = cArray;
    }

    public static final class Builder {
        public static final Companion Companion = new Companion(null);
        private String scheme;
        private String encodedUsername = "";
        private String encodedPassword = "";
        private String host;
        private int port = -1;
        private final List<String> encodedPathSegments = new ArrayList();
        private List<String> encodedQueryNamesAndValues;
        private String encodedFragment;

        public Builder() {
            this.encodedPathSegments.add("");
        }

        public final String getScheme$okhttp() {
            return this.scheme;
        }

        public final void setScheme$okhttp(String string) {
            this.scheme = string;
        }

        public final String getEncodedUsername$okhttp() {
            return this.encodedUsername;
        }

        public final void setEncodedUsername$okhttp(String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.encodedUsername = string;
        }

        public final String getEncodedPassword$okhttp() {
            return this.encodedPassword;
        }

        public final void setEncodedPassword$okhttp(String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.encodedPassword = string;
        }

        public final String getHost$okhttp() {
            return this.host;
        }

        public final void setHost$okhttp(String string) {
            this.host = string;
        }

        public final int getPort$okhttp() {
            return this.port;
        }

        public final void setPort$okhttp(int n) {
            this.port = n;
        }

        public final List<String> getEncodedPathSegments$okhttp() {
            return this.encodedPathSegments;
        }

        public final List<String> getEncodedQueryNamesAndValues$okhttp() {
            return this.encodedQueryNamesAndValues;
        }

        public final void setEncodedQueryNamesAndValues$okhttp(List<String> list) {
            this.encodedQueryNamesAndValues = list;
        }

        public final String getEncodedFragment$okhttp() {
            return this.encodedFragment;
        }

        public final void setEncodedFragment$okhttp(String string) {
            this.encodedFragment = string;
        }

        public final Builder scheme(String scheme) {
            Builder builder;
            Intrinsics.checkNotNullParameter(scheme, "scheme");
            Builder $this$scheme_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            if (StringsKt.equals(scheme, "http", true)) {
                $this$scheme_u24lambda_u2d0.setScheme$okhttp("http");
            } else if (StringsKt.equals(scheme, "https", true)) {
                $this$scheme_u24lambda_u2d0.setScheme$okhttp("https");
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus("unexpected scheme: ", scheme));
            }
            return builder;
        }

        public final Builder username(String username) {
            Builder builder;
            Intrinsics.checkNotNullParameter(username, "username");
            Builder $this$username_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$username_u24lambda_u2d1.setEncodedUsername$okhttp(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, username, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251, null));
            return builder;
        }

        public final Builder password(String password) {
            Builder builder;
            Intrinsics.checkNotNullParameter(password, "password");
            Builder $this$password_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$password_u24lambda_u2d3.setEncodedPassword$okhttp(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, password, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251, null));
            return builder;
        }

        public final Builder host(String host) {
            Builder builder;
            Intrinsics.checkNotNullParameter(host, "host");
            Builder $this$host_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            String string = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, host, 0, 0, false, 7, null));
            if (string == null) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("unexpected host: ", host));
            }
            String encoded = string;
            $this$host_u24lambda_u2d5.setHost$okhttp(encoded);
            return builder;
        }

        public final Builder port(int port) {
            Builder builder;
            Builder $this$port_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            if (!(1 <= port ? port < 65536 : false)) {
                boolean bl2 = false;
                String string = Intrinsics.stringPlus("unexpected port: ", port);
                throw new IllegalArgumentException(string.toString());
            }
            $this$port_u24lambda_u2d7.setPort$okhttp(port);
            return builder;
        }

        private final int effectivePort() {
            int n;
            if (this.port != -1) {
                n = this.port;
            } else {
                String string = this.scheme;
                Intrinsics.checkNotNull(string);
                n = Companion.defaultPort(string);
            }
            return n;
        }

        public final Builder encodedQuery(String encodedQuery) {
            String string;
            Builder builder;
            Builder $this$encodedQuery_u24lambda_u2d19 = builder = this;
            boolean bl = false;
            String string2 = encodedQuery;
            $this$encodedQuery_u24lambda_u2d19.setEncodedQueryNamesAndValues$okhttp(string2 == null ? null : ((string = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, string2, 0, 0, " \"'<>#", true, false, true, false, null, 211, null)) == null ? null : Companion.toQueryNamesAndValues$okhttp(string)));
            return builder;
        }

        public final Builder reencodeForUri$okhttp() {
            String string;
            Builder builder;
            Builder $this$reencodeForUri_u24lambda_u2d28 = builder = this;
            boolean bl = false;
            String string2 = $this$reencodeForUri_u24lambda_u2d28.getHost$okhttp();
            if (string2 == null) {
                string = null;
            } else {
                CharSequence charSequence = string2;
                Regex regex = new Regex("[\"<>^`{|}]");
                String string3 = "";
                string = regex.replace(charSequence, string3);
            }
            $this$reencodeForUri_u24lambda_u2d28.setHost$okhttp(string);
            int n = 0;
            int n2 = $this$reencodeForUri_u24lambda_u2d28.getEncodedPathSegments$okhttp().size();
            while (n < n2) {
                int i = n++;
                $this$reencodeForUri_u24lambda_u2d28.getEncodedPathSegments$okhttp().set(i, okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, $this$reencodeForUri_u24lambda_u2d28.getEncodedPathSegments$okhttp().get(i), 0, 0, "[]", true, true, false, false, null, 227, null));
            }
            List<String> encodedQueryNamesAndValues = $this$reencodeForUri_u24lambda_u2d28.getEncodedQueryNamesAndValues$okhttp();
            if (encodedQueryNamesAndValues != null) {
                n2 = 0;
                int n3 = encodedQueryNamesAndValues.size();
                while (n2 < n3) {
                    int i = n2++;
                    String string4 = encodedQueryNamesAndValues.get(i);
                    encodedQueryNamesAndValues.set(i, string4 == null ? null : okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, string4, 0, 0, "\\^`{|}", true, true, true, false, null, 195, null));
                }
            }
            String string5 = $this$reencodeForUri_u24lambda_u2d28.getEncodedFragment$okhttp();
            $this$reencodeForUri_u24lambda_u2d28.setEncodedFragment$okhttp(string5 == null ? null : okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, string5, 0, 0, " \"#<>\\^`{|}", true, true, false, true, null, 163, null));
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final HttpUrl build() {
            Collection<String> collection;
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string = this.scheme;
            if (string == null) {
                throw new IllegalStateException("scheme == null");
            }
            String string2 = this.host;
            if (string2 == null) {
                throw new IllegalStateException("host == null");
            }
            Iterable iterable = this.encodedPathSegments;
            int n = this.effectivePort();
            String string3 = string2;
            String string4 = okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, this.encodedPassword, 0, 0, false, 7, null);
            String string5 = okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, this.encodedUsername, 0, 0, false, 7, null);
            String string6 = string;
            boolean $i$f$map2 = false;
            void var3_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string7 = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, (String)it, 0, 0, false, 7, null));
            }
            collection2 = (List)destination$iv$iv;
            String string8 = string6;
            String string9 = string5;
            String string10 = string4;
            String string11 = string3;
            int n2 = n;
            Collection<String> collection3 = collection2;
            List<String> list = this.encodedQueryNamesAndValues;
            if (list == null) {
                collection = null;
            } else {
                Collection<String> collection4;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable $i$f$map2 = list;
                collection2 = collection3;
                n = n2;
                string3 = string11;
                string4 = string10;
                string5 = string9;
                string6 = string8;
                boolean $i$f$map3 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String bl = (String)item$iv$iv;
                    collection4 = destination$iv$iv2;
                    boolean bl2 = false;
                    void v10 = it;
                    collection4.add(v10 == null ? null : okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, (String)v10, 0, 0, true, 3, null));
                }
                collection4 = (List)destination$iv$iv2;
                string8 = string6;
                string9 = string5;
                string10 = string4;
                string11 = string3;
                n2 = n;
                collection3 = collection2;
                collection = collection4;
            }
            String string12 = this.encodedFragment;
            String string13 = this.toString();
            String string14 = string12 == null ? null : okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, string12, 0, 0, false, 7, null);
            Collection<String> collection5 = collection;
            Collection<String> collection6 = collection3;
            int n3 = n2;
            String string15 = string11;
            String string16 = string10;
            String string17 = string9;
            String string18 = string8;
            return new HttpUrl(string18, string17, string16, string15, n3, (List<String>)collection6, (List<String>)collection5, string14, string13);
        }

        public String toString() {
            StringBuilder $this$toString_u24lambda_u2d31;
            StringBuilder stringBuilder;
            block12: {
                int effectivePort;
                block13: {
                    $this$toString_u24lambda_u2d31 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    if (this.getScheme$okhttp() != null) {
                        $this$toString_u24lambda_u2d31.append(this.getScheme$okhttp());
                        $this$toString_u24lambda_u2d31.append("://");
                    } else {
                        $this$toString_u24lambda_u2d31.append("//");
                    }
                    if (((CharSequence)this.getEncodedUsername$okhttp()).length() > 0 || ((CharSequence)this.getEncodedPassword$okhttp()).length() > 0) {
                        $this$toString_u24lambda_u2d31.append(this.getEncodedUsername$okhttp());
                        if (((CharSequence)this.getEncodedPassword$okhttp()).length() > 0) {
                            $this$toString_u24lambda_u2d31.append(':');
                            $this$toString_u24lambda_u2d31.append(this.getEncodedPassword$okhttp());
                        }
                        $this$toString_u24lambda_u2d31.append('@');
                    }
                    if (this.getHost$okhttp() != null) {
                        String string = this.getHost$okhttp();
                        Intrinsics.checkNotNull(string);
                        if (StringsKt.contains$default((CharSequence)string, ':', false, 2, null)) {
                            $this$toString_u24lambda_u2d31.append('[');
                            $this$toString_u24lambda_u2d31.append(this.getHost$okhttp());
                            $this$toString_u24lambda_u2d31.append(']');
                        } else {
                            $this$toString_u24lambda_u2d31.append(this.getHost$okhttp());
                        }
                    }
                    if (this.getPort$okhttp() == -1 && this.getScheme$okhttp() == null) break block12;
                    effectivePort = this.effectivePort();
                    if (this.getScheme$okhttp() == null) break block13;
                    String string = this.getScheme$okhttp();
                    Intrinsics.checkNotNull(string);
                    if (effectivePort == Companion.defaultPort(string)) break block12;
                }
                $this$toString_u24lambda_u2d31.append(':');
                $this$toString_u24lambda_u2d31.append(effectivePort);
            }
            Companion.toPathString$okhttp(this.getEncodedPathSegments$okhttp(), $this$toString_u24lambda_u2d31);
            if (this.getEncodedQueryNamesAndValues$okhttp() != null) {
                $this$toString_u24lambda_u2d31.append('?');
                List<String> list = this.getEncodedQueryNamesAndValues$okhttp();
                Intrinsics.checkNotNull(list);
                Companion.toQueryString$okhttp(list, $this$toString_u24lambda_u2d31);
            }
            if (this.getEncodedFragment$okhttp() != null) {
                $this$toString_u24lambda_u2d31.append('#');
                $this$toString_u24lambda_u2d31.append(this.getEncodedFragment$okhttp());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final Builder parse$okhttp(HttpUrl base, String input) {
            Intrinsics.checkNotNullParameter(input, "input");
            int pos = 0;
            pos = Util.indexOfFirstNonAsciiWhitespace$default(input, 0, 0, 3, null);
            int limit = Util.indexOfLastNonAsciiWhitespace$default(input, pos, 0, 2, null);
            int schemeDelimiterOffset = Builder.Companion.schemeDelimiterOffset(input, pos, limit);
            if (schemeDelimiterOffset != -1) {
                if (StringsKt.startsWith(input, "https:", pos, true)) {
                    this.scheme = "https";
                    pos += "https:".length();
                } else {
                    if (!StringsKt.startsWith(input, "http:", pos, true)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Expected URL scheme 'http' or 'https' but was '");
                        String string = input;
                        int n = 0;
                        String string2 = string.substring(n, schemeDelimiterOffset);
                        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                        throw new IllegalArgumentException(stringBuilder.append(string2).append('\'').toString());
                    }
                    this.scheme = "http";
                    pos += "http:".length();
                }
            } else if (base != null) {
                this.scheme = base.scheme();
            } else {
                String truncated = input.length() > 6 ? Intrinsics.stringPlus(StringsKt.take(input, 6), "...") : input;
                throw new IllegalArgumentException(Intrinsics.stringPlus("Expected URL scheme 'http' or 'https' but no scheme was found for ", truncated));
            }
            boolean hasUsername = false;
            boolean hasPassword = false;
            int slashCount = Builder.Companion.slashCount(input, pos, limit);
            if (slashCount < 2 && base != null && Intrinsics.areEqual(base.scheme(), this.scheme)) {
                this.encodedUsername = base.encodedUsername();
                this.encodedPassword = base.encodedPassword();
                this.host = base.host();
                this.port = base.port();
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll((Collection<String>)base.encodedPathSegments());
                if (pos == limit || input.charAt(pos) == '#') {
                    this.encodedQuery(base.encodedQuery());
                }
            } else {
                pos += slashCount;
                block4: while (true) {
                    int componentDelimiterOffset;
                    int c = (componentDelimiterOffset = Util.delimiterOffset(input, "@/\\?#", pos, limit)) != limit ? (int)input.charAt(componentDelimiterOffset) : -1;
                    switch (c) {
                        case 64: {
                            if (!hasPassword) {
                                int passwordColonOffset = Util.delimiterOffset(input, ':', pos, componentDelimiterOffset);
                                String canonicalUsername = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240, null);
                                String string = this.encodedUsername = hasUsername ? this.encodedUsername + "%40" + canonicalUsername : canonicalUsername;
                                if (passwordColonOffset != componentDelimiterOffset) {
                                    hasPassword = true;
                                    this.encodedPassword = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, input, passwordColonOffset + 1, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240, null);
                                }
                                hasUsername = true;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, input, pos, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240, null);
                            }
                            pos = componentDelimiterOffset + 1;
                            continue block4;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: {
                            int portColonOffset = Builder.Companion.portColonOffset(input, pos, componentDelimiterOffset);
                            if (portColonOffset + 1 < componentDelimiterOffset) {
                                this.host = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, input, pos, portColonOffset, false, 4, null));
                                this.port = Builder.Companion.parsePort(input, portColonOffset + 1, componentDelimiterOffset);
                                if (!(this.port != -1)) {
                                    boolean $i$a$-require-HttpUrl$Builder$parse$32 = false;
                                    StringBuilder stringBuilder = new StringBuilder().append("Invalid URL port: \"");
                                    String string = input;
                                    int n = portColonOffset + 1;
                                    String string3 = string.substring(n, componentDelimiterOffset);
                                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    String $i$a$-require-HttpUrl$Builder$parse$32 = stringBuilder.append(string3).append('\"').toString();
                                    throw new IllegalArgumentException($i$a$-require-HttpUrl$Builder$parse$32.toString());
                                }
                            } else {
                                this.host = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default(Companion, input, pos, portColonOffset, false, 4, null));
                                String string = this.scheme;
                                Intrinsics.checkNotNull(string);
                                this.port = Companion.defaultPort(string);
                            }
                            if (!(this.host != null)) {
                                boolean bl = false;
                                StringBuilder stringBuilder = new StringBuilder().append("Invalid URL host: \"");
                                String string = input;
                                int n = pos;
                                String string4 = string.substring(n, portColonOffset);
                                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                                String string5 = stringBuilder.append(string4).append('\"').toString();
                                throw new IllegalArgumentException(string5.toString());
                            }
                            pos = componentDelimiterOffset;
                            break block4;
                        }
                        default: {
                            continue block4;
                        }
                    }
                    break;
                }
            }
            int pathDelimiterOffset = Util.delimiterOffset(input, "?#", pos, limit);
            this.resolvePath(input, pos, pathDelimiterOffset);
            pos = pathDelimiterOffset;
            if (pos < limit && input.charAt(pos) == '?') {
                int queryDelimiterOffset = Util.delimiterOffset(input, '#', pos, limit);
                this.encodedQueryNamesAndValues = Companion.toQueryNamesAndValues$okhttp(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, input, pos + 1, queryDelimiterOffset, " \"'<>#", true, false, true, false, null, 208, null));
                pos = queryDelimiterOffset;
            }
            if (pos < limit && input.charAt(pos) == '#') {
                this.encodedFragment = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, input, pos + 1, limit, "", true, false, false, true, null, 176, null);
            }
            return this;
        }

        private final void resolvePath(String input, int startPos, int limit) {
            int pos = startPos;
            if (pos == limit) {
                return;
            }
            char c = input.charAt(pos);
            if (c == '/' || c == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add("");
                int n = pos;
                pos = n + 1;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, "");
            }
            int i = pos;
            while (i < limit) {
                int pathSegmentDelimiterOffset = Util.delimiterOffset(input, "/\\", i, limit);
                boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
                this.push(input, i, pathSegmentDelimiterOffset, segmentHasTrailingSlash, true);
                i = pathSegmentDelimiterOffset;
                if (!segmentHasTrailingSlash) continue;
                int n = i;
                i = n + 1;
            }
        }

        private final void push(String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
            String segment = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(Companion, input, pos, limit, " \"<>^`{}|/\\?#", alreadyEncoded, false, false, false, null, 240, null);
            if (this.isDot(segment)) {
                return;
            }
            if (this.isDotDot(segment)) {
                this.pop();
                return;
            }
            if (((CharSequence)this.encodedPathSegments.get(this.encodedPathSegments.size() - 1)).length() == 0) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, segment);
            } else {
                this.encodedPathSegments.add(segment);
            }
            if (addTrailingSlash) {
                this.encodedPathSegments.add("");
            }
        }

        private final boolean isDot(String input) {
            return Intrinsics.areEqual(input, ".") || StringsKt.equals(input, "%2e", true);
        }

        private final boolean isDotDot(String input) {
            return Intrinsics.areEqual(input, "..") || StringsKt.equals(input, "%2e.", true) || StringsKt.equals(input, ".%2e", true) || StringsKt.equals(input, "%2e%2e", true);
        }

        private final void pop() {
            String removed = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            if (((CharSequence)removed).length() == 0 && !((Collection)this.encodedPathSegments).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, "");
            } else {
                this.encodedPathSegments.add("");
            }
        }

        public static final class Companion {
            private Companion() {
            }

            private final int schemeDelimiterOffset(String input, int pos, int limit) {
                if (limit - pos < 2) {
                    return -1;
                }
                char c0 = input.charAt(pos);
                if (!(Intrinsics.compare(c0, 97) >= 0 && Intrinsics.compare(c0, 122) <= 0 || Intrinsics.compare(c0, 65) >= 0 && Intrinsics.compare(c0, 90) <= 0)) {
                    return -1;
                }
                int n = pos + 1;
                while (n < limit) {
                    int i;
                    char c;
                    if (((((('a' <= (c = input.charAt(i = n++)) ? c < '{' : false) ? true : ('A' <= c ? c < '[' : false)) ? true : ('0' <= c ? c < ':' : false)) ? true : c == '+') ? true : c == '-') ? true : c == '.') continue;
                    return c == ':' ? i : -1;
                }
                return -1;
            }

            private final int slashCount(String $this$slashCount, int pos, int limit) {
                int i;
                char c;
                int slashCount = 0;
                int n = pos;
                while (n < limit && ((c = $this$slashCount.charAt(i = n++)) == '\\' || c == '/')) {
                    int n2 = slashCount;
                    slashCount = n2 + 1;
                }
                return slashCount;
            }

            private final int portColonOffset(String input, int pos, int limit) {
                int i = pos;
                while (i < limit) {
                    int n = input.charAt(i);
                    if (n == 91) {
                        while (++i < limit && input.charAt(i) != ']') {
                        }
                    } else if (n == 58) {
                        return i;
                    }
                    n = i;
                    i = n + 1;
                }
                return limit;
            }

            private final int parsePort(String input, int pos, int limit) {
                int n;
                try {
                    String portString = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, input, pos, limit, "", false, false, false, false, null, 248, null);
                    int i = Integer.parseInt(portString);
                    n = (1 <= i ? i < 65536 : false) ? i : -1;
                }
                catch (NumberFormatException _) {
                    n = -1;
                }
                return n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final int defaultPort(String scheme) {
            Intrinsics.checkNotNullParameter(scheme, "scheme");
            String string = scheme;
            return Intrinsics.areEqual(string, "http") ? 80 : (Intrinsics.areEqual(string, "https") ? 443 : -1);
        }

        public final void toPathString$okhttp(List<String> $this$toPathString, StringBuilder out) {
            Intrinsics.checkNotNullParameter($this$toPathString, "<this>");
            Intrinsics.checkNotNullParameter(out, "out");
            int n = 0;
            int n2 = $this$toPathString.size();
            while (n < n2) {
                int i = n++;
                out.append('/');
                out.append($this$toPathString.get(i));
            }
        }

        public final void toQueryString$okhttp(List<String> $this$toQueryString, StringBuilder out) {
            Intrinsics.checkNotNullParameter($this$toQueryString, "<this>");
            Intrinsics.checkNotNullParameter(out, "out");
            IntProgression intProgression = RangesKt.step(RangesKt.until(0, $this$toQueryString.size()), 2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int i;
                do {
                    i = n;
                    n += n3;
                    String name = $this$toQueryString.get(i);
                    String value = $this$toQueryString.get(i + 1);
                    if (i > 0) {
                        out.append('&');
                    }
                    out.append(name);
                    if (value == null) continue;
                    out.append('=');
                    out.append(value);
                } while (i != n2);
            }
        }

        public final List<String> toQueryNamesAndValues$okhttp(String $this$toQueryNamesAndValues) {
            Intrinsics.checkNotNullParameter($this$toQueryNamesAndValues, "<this>");
            List result2 = new ArrayList();
            int pos = 0;
            while (pos <= $this$toQueryNamesAndValues.length()) {
                int equalsOffset;
                int ampersandOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, '&', pos, false, 4, null);
                if (ampersandOffset == -1) {
                    ampersandOffset = $this$toQueryNamesAndValues.length();
                }
                if ((equalsOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, '=', pos, false, 4, null)) == -1 || equalsOffset > ampersandOffset) {
                    String string = $this$toQueryNamesAndValues.substring(pos, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result2.add(string);
                    result2.add(null);
                } else {
                    String string = $this$toQueryNamesAndValues.substring(pos, equalsOffset);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result2.add(string);
                    String string2 = $this$toQueryNamesAndValues;
                    int n = equalsOffset + 1;
                    String string3 = string2.substring(n, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result2.add(string3);
                }
                pos = ampersandOffset + 1;
            }
            return result2;
        }

        public final HttpUrl get(String $this$toHttpUrl) {
            Intrinsics.checkNotNullParameter($this$toHttpUrl, "<this>");
            return new Builder().parse$okhttp(null, $this$toHttpUrl).build();
        }

        public final HttpUrl parse(String $this$toHttpUrlOrNull) {
            HttpUrl httpUrl;
            Intrinsics.checkNotNullParameter($this$toHttpUrlOrNull, "<this>");
            try {
                httpUrl = this.get($this$toHttpUrlOrNull);
            }
            catch (IllegalArgumentException _) {
                httpUrl = null;
            }
            return httpUrl;
        }

        public final String percentDecode$okhttp(String $this$percentDecode, int pos, int limit, boolean plusIsSpace) {
            Intrinsics.checkNotNullParameter($this$percentDecode, "<this>");
            int n = pos;
            while (n < limit) {
                int i;
                char c;
                if ((c = $this$percentDecode.charAt(i = n++)) != '%' && (c != '+' || !plusIsSpace)) continue;
                Buffer out = new Buffer();
                out.writeUtf8($this$percentDecode, pos, i);
                this.writePercentDecoded(out, $this$percentDecode, i, limit, plusIsSpace);
                return out.readUtf8();
            }
            String string = $this$percentDecode.substring(pos, limit);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        public static /* synthetic */ String percentDecode$okhttp$default(Companion companion, String string, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = string.length();
            }
            if ((n3 & 4) != 0) {
                bl = false;
            }
            return companion.percentDecode$okhttp(string, n, n2, bl);
        }

        private final void writePercentDecoded(Buffer $this$writePercentDecoded, String encoded, int pos, int limit, boolean plusIsSpace) {
            int codePoint = 0;
            int i = pos;
            while (i < limit) {
                codePoint = encoded.codePointAt(i);
                if (codePoint == 37 && i + 2 < limit) {
                    int d1 = Util.parseHexDigit(encoded.charAt(i + 1));
                    int d2 = Util.parseHexDigit(encoded.charAt(i + 2));
                    if (d1 != -1 && d2 != -1) {
                        $this$writePercentDecoded.writeByte((d1 << 4) + d2);
                        i += 2;
                        i += Character.charCount(codePoint);
                        continue;
                    }
                } else if (codePoint == 43 && plusIsSpace) {
                    $this$writePercentDecoded.writeByte(32);
                    int n = i;
                    i = n + 1;
                    continue;
                }
                $this$writePercentDecoded.writeUtf8CodePoint(codePoint);
                i += Character.charCount(codePoint);
            }
        }

        private final boolean isPercentEncoded(String $this$isPercentEncoded, int pos, int limit) {
            return pos + 2 < limit && $this$isPercentEncoded.charAt(pos) == '%' && Util.parseHexDigit($this$isPercentEncoded.charAt(pos + 1)) != -1 && Util.parseHexDigit($this$isPercentEncoded.charAt(pos + 2)) != -1;
        }

        public final String canonicalize$okhttp(String $this$canonicalize, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean unicodeAllowed, Charset charset) {
            Intrinsics.checkNotNullParameter($this$canonicalize, "<this>");
            Intrinsics.checkNotNullParameter(encodeSet, "encodeSet");
            int codePoint = 0;
            for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
                codePoint = $this$canonicalize.codePointAt(i);
                if (!(codePoint < 32 || codePoint == 127 || codePoint >= 128 && !unicodeAllowed || StringsKt.contains$default((CharSequence)encodeSet, (char)codePoint, false, 2, null) || codePoint == 37 && (!alreadyEncoded || strict && !this.isPercentEncoded($this$canonicalize, i, limit))) && (codePoint != 43 || !plusIsSpace)) continue;
                Buffer out = new Buffer();
                out.writeUtf8($this$canonicalize, pos, i);
                this.writeCanonicalized(out, $this$canonicalize, i, limit, encodeSet, alreadyEncoded, strict, plusIsSpace, unicodeAllowed, charset);
                return out.readUtf8();
            }
            String string = $this$canonicalize.substring(pos, limit);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        public static /* synthetic */ String canonicalize$okhttp$default(Companion companion, String string, int n, int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = string.length();
            }
            if ((n3 & 8) != 0) {
                bl = false;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x20) != 0) {
                bl3 = false;
            }
            if ((n3 & 0x40) != 0) {
                bl4 = false;
            }
            if ((n3 & 0x80) != 0) {
                charset = null;
            }
            return companion.canonicalize$okhttp(string, n, n2, string2, bl, bl2, bl3, bl4, charset);
        }

        private final void writeCanonicalized(Buffer $this$writeCanonicalized, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean unicodeAllowed, Charset charset) {
            Buffer encodedCharBuffer = null;
            int codePoint = 0;
            for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
                codePoint = input.codePointAt(i);
                if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
                if (codePoint == 43 && plusIsSpace) {
                    $this$writeCanonicalized.writeUtf8(alreadyEncoded ? "+" : "%2B");
                    continue;
                }
                if (codePoint < 32 || codePoint == 127 || codePoint >= 128 && !unicodeAllowed || StringsKt.contains$default((CharSequence)encodeSet, (char)codePoint, false, 2, null) || codePoint == 37 && (!alreadyEncoded || strict && !this.isPercentEncoded(input, i, limit))) {
                    if (encodedCharBuffer == null) {
                        encodedCharBuffer = new Buffer();
                    }
                    if (charset == null || Intrinsics.areEqual(charset, StandardCharsets.UTF_8)) {
                        encodedCharBuffer.writeUtf8CodePoint(codePoint);
                    } else {
                        encodedCharBuffer.writeString(input, i, i + Character.charCount(codePoint), charset);
                    }
                    while (!encodedCharBuffer.exhausted()) {
                        int b = encodedCharBuffer.readByte() & 0xFF;
                        $this$writeCanonicalized.writeByte(37);
                        $this$writeCanonicalized.writeByte(HEX_DIGITS[b >> 4 & 0xF]);
                        $this$writeCanonicalized.writeByte(HEX_DIGITS[b & 0xF]);
                    }
                    continue;
                }
                $this$writeCanonicalized.writeUtf8CodePoint(codePoint);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

