/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

public final class CipherSuite {
    public static final Companion Companion = new Companion(null);
    private final String javaName;
    private static final Comparator<String> ORDER_BY_NAME = new Comparator<String>(){

        public int compare(String a, String b) {
            int lengthB;
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            int i = 4;
            int limit = Math.min(a.length(), b.length());
            while (i < limit) {
                char charB;
                char charA = a.charAt(i);
                if (charA != (charB = b.charAt(i))) {
                    return Intrinsics.compare(charA, charB) < 0 ? -1 : 1;
                }
                int n = i;
                i = n + 1;
            }
            int lengthA = a.length();
            if (lengthA != (lengthB = b.length())) {
                return lengthA < lengthB ? -1 : 1;
            }
            return 0;
        }
    };
    private static final Map<String, CipherSuite> INSTANCES = new LinkedHashMap();
    public static final CipherSuite TLS_RSA_WITH_NULL_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_WITH_NULL_MD5", 1);
    public static final CipherSuite TLS_RSA_WITH_NULL_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_WITH_NULL_SHA", 2);
    public static final CipherSuite TLS_RSA_EXPORT_WITH_RC4_40_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_EXPORT_WITH_RC4_40_MD5", 3);
    public static final CipherSuite TLS_RSA_WITH_RC4_128_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_WITH_RC4_128_MD5", 4);
    public static final CipherSuite TLS_RSA_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_WITH_RC4_128_SHA", 5);
    public static final CipherSuite TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 8);
    public static final CipherSuite TLS_RSA_WITH_DES_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_WITH_DES_CBC_SHA", 9);
    public static final CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_RSA_WITH_3DES_EDE_CBC_SHA", 10);
    public static final CipherSuite TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17);
    public static final CipherSuite TLS_DHE_DSS_WITH_DES_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DHE_DSS_WITH_DES_CBC_SHA", 18);
    public static final CipherSuite TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19);
    public static final CipherSuite TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20);
    public static final CipherSuite TLS_DHE_RSA_WITH_DES_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DHE_RSA_WITH_DES_CBC_SHA", 21);
    public static final CipherSuite TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22);
    public static final CipherSuite TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 23);
    public static final CipherSuite TLS_DH_anon_WITH_RC4_128_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DH_anon_WITH_RC4_128_MD5", 24);
    public static final CipherSuite TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25);
    public static final CipherSuite TLS_DH_anon_WITH_DES_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DH_anon_WITH_DES_CBC_SHA", 26);
    public static final CipherSuite TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 27);
    public static final CipherSuite TLS_KRB5_WITH_DES_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_WITH_DES_CBC_SHA", 30);
    public static final CipherSuite TLS_KRB5_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31);
    public static final CipherSuite TLS_KRB5_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_WITH_RC4_128_SHA", 32);
    public static final CipherSuite TLS_KRB5_WITH_DES_CBC_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_WITH_DES_CBC_MD5", 34);
    public static final CipherSuite TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35);
    public static final CipherSuite TLS_KRB5_WITH_RC4_128_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_WITH_RC4_128_MD5", 36);
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38);
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC4_40_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", 40);
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41);
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", 43);
    public static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_AES_128_CBC_SHA", 47);
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50);
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51);
    public static final CipherSuite TLS_DH_anon_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DH_anon_WITH_AES_128_CBC_SHA", 52);
    public static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_AES_256_CBC_SHA", 53);
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56);
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57);
    public static final CipherSuite TLS_DH_anon_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DH_anon_WITH_AES_256_CBC_SHA", 58);
    public static final CipherSuite TLS_RSA_WITH_NULL_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_NULL_SHA256", 59);
    public static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
    public static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_AES_256_CBC_SHA256", 61);
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64);
    public static final CipherSuite TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", 65);
    public static final CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", 68);
    public static final CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", 69);
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103);
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106);
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107);
    public static final CipherSuite TLS_DH_anon_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DH_anon_WITH_AES_128_CBC_SHA256", 108);
    public static final CipherSuite TLS_DH_anon_WITH_AES_256_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DH_anon_WITH_AES_256_CBC_SHA256", 109);
    public static final CipherSuite TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", 132);
    public static final CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", 135);
    public static final CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", 136);
    public static final CipherSuite TLS_PSK_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_PSK_WITH_RC4_128_SHA", 138);
    public static final CipherSuite TLS_PSK_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_PSK_WITH_3DES_EDE_CBC_SHA", 139);
    public static final CipherSuite TLS_PSK_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_PSK_WITH_AES_128_CBC_SHA", 140);
    public static final CipherSuite TLS_PSK_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_PSK_WITH_AES_256_CBC_SHA", 141);
    public static final CipherSuite TLS_RSA_WITH_SEED_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_SEED_CBC_SHA", 150);
    public static final CipherSuite TLS_RSA_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
    public static final CipherSuite TLS_RSA_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
    public static final CipherSuite TLS_DH_anon_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DH_anon_WITH_AES_128_GCM_SHA256", 166);
    public static final CipherSuite TLS_DH_anon_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DH_anon_WITH_AES_256_GCM_SHA384", 167);
    public static final CipherSuite TLS_EMPTY_RENEGOTIATION_INFO_SCSV = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_EMPTY_RENEGOTIATION_INFO_SCSV", 255);
    public static final CipherSuite TLS_FALLBACK_SCSV = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_FALLBACK_SCSV", 22016);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_NULL_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_NULL_SHA", 49153);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", 49154);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", 49155);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", 49156);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", 49157);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_NULL_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", 49159);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162);
    public static final CipherSuite TLS_ECDH_RSA_WITH_NULL_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_NULL_SHA", 49163);
    public static final CipherSuite TLS_ECDH_RSA_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_RC4_128_SHA", 49164);
    public static final CipherSuite TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", 49165);
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", 49166);
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", 49167);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_NULL_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_NULL_SHA", 49168);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_RC4_128_SHA", 49169);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172);
    public static final CipherSuite TLS_ECDH_anon_WITH_NULL_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_anon_WITH_NULL_SHA", 49173);
    public static final CipherSuite TLS_ECDH_anon_WITH_RC4_128_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_anon_WITH_RC4_128_SHA", 49174);
    public static final CipherSuite TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", 49175);
    public static final CipherSuite TLS_ECDH_anon_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", 49176);
    public static final CipherSuite TLS_ECDH_anon_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", 49177);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", 49189);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", 49190);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", 49193);
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", 49194);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", 49197);
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", 49198);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", 49201);
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", 49202);
    public static final CipherSuite TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", 49205);
    public static final CipherSuite TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", 49206);
    public static final CipherSuite TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
    public static final CipherSuite TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52394);
    public static final CipherSuite TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256", 52396);
    public static final CipherSuite TLS_AES_128_GCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_AES_128_GCM_SHA256", 4865);
    public static final CipherSuite TLS_AES_256_GCM_SHA384 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_AES_256_GCM_SHA384", 4866);
    public static final CipherSuite TLS_CHACHA20_POLY1305_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_CHACHA20_POLY1305_SHA256", 4867);
    public static final CipherSuite TLS_AES_128_CCM_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_AES_128_CCM_SHA256", 4868);
    public static final CipherSuite TLS_AES_128_CCM_8_SHA256 = okhttp3.CipherSuite$Companion.access$init(Companion, "TLS_AES_128_CCM_8_SHA256", 4869);

    private CipherSuite(String javaName) {
        this.javaName = javaName;
    }

    public final String javaName() {
        return this.javaName;
    }

    public String toString() {
        return this.javaName;
    }

    public /* synthetic */ CipherSuite(String javaName, DefaultConstructorMarker $constructor_marker) {
        this(javaName);
    }

    public static final class Companion {
        private Companion() {
        }

        public final Comparator<String> getORDER_BY_NAME$okhttp() {
            return ORDER_BY_NAME;
        }

        public final synchronized CipherSuite forJavaName(String javaName) {
            Intrinsics.checkNotNullParameter(javaName, "javaName");
            CipherSuite result2 = (CipherSuite)INSTANCES.get(javaName);
            if (result2 == null) {
                result2 = (CipherSuite)INSTANCES.get(this.secondaryName(javaName));
                if (result2 == null) {
                    result2 = new CipherSuite(javaName, null);
                }
                INSTANCES.put(javaName, result2);
            }
            return result2;
        }

        private final String secondaryName(String javaName) {
            String string;
            if (StringsKt.startsWith$default(javaName, "TLS_", false, 2, null)) {
                String string2 = javaName.substring(4);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                string = Intrinsics.stringPlus("SSL_", string2);
            } else if (StringsKt.startsWith$default(javaName, "SSL_", false, 2, null)) {
                String string3 = javaName.substring(4);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                string = Intrinsics.stringPlus("TLS_", string3);
            } else {
                string = javaName;
            }
            return string;
        }

        private final CipherSuite init(String javaName, int value) {
            CipherSuite suite = new CipherSuite(javaName, null);
            INSTANCES.put(javaName, suite);
            return suite;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ CipherSuite access$init(Companion $this, String javaName, int value) {
            return $this.init(javaName, value);
        }
    }
}

