/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Cache
implements Closeable,
Flushable {
    public static final Companion Companion = new Companion(null);
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public final int getWriteSuccessCount$okhttp() {
        return this.writeSuccessCount;
    }

    public final void setWriteSuccessCount$okhttp(int n) {
        this.writeSuccessCount = n;
    }

    public final int getWriteAbortCount$okhttp() {
        return this.writeAbortCount;
    }

    public final void setWriteAbortCount$okhttp(int n) {
        this.writeAbortCount = n;
    }

    public final Response get$okhttp(Request request) {
        Entry _2;
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter(request, "request");
        String key = Companion.key(request.url());
        try {
            DiskLruCache.Snapshot snapshot2 = this.cache.get(key);
            if (snapshot2 == null) {
                return null;
            }
            snapshot = snapshot2;
        }
        catch (IOException _2) {
            return null;
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        try {
            _2 = new Entry(snapshot3.getSource(0));
        }
        catch (IOException _3) {
            Util.closeQuietly(snapshot3);
            return null;
        }
        Entry entry = _2;
        Response response = entry.response(snapshot3);
        if (!entry.matches(request, response)) {
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
            return null;
        }
        return response;
    }

    public final CacheRequest put$okhttp(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String requestMethod = response.request().method();
        if (HttpMethod.INSTANCE.invalidatesCache(response.request().method())) {
            try {
                this.remove$okhttp(response.request());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (!Intrinsics.areEqual(requestMethod, "GET")) {
            return null;
        }
        if (Companion.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = DiskLruCache.edit$default(this.cache, Companion.key(response.request().url()), 0L, 2, null);
            if (editor2 == null) {
                return null;
            }
            editor = editor2;
            entry.writeTo(editor);
            return new RealCacheRequest(editor);
        }
        catch (IOException _) {
            this.abortQuietly(editor);
            return null;
        }
    }

    public final void remove$okhttp(Request request) throws IOException {
        Intrinsics.checkNotNullParameter(request, "request");
        this.cache.remove(Companion.key(request.url()));
    }

    public final void update$okhttp(Response cached, Response network) {
        Intrinsics.checkNotNullParameter(cached, "cached");
        Intrinsics.checkNotNullParameter(network, "network");
        Entry entry = new Entry(network);
        ResponseBody responseBody = cached.body();
        if (responseBody == null) {
            throw new NullPointerException("null cannot be cast to non-null type okhttp3.Cache.CacheResponseBody");
        }
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)responseBody).getSnapshot();
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = snapshot.edit();
            if (editor2 == null) {
                return;
            }
            editor = editor2;
            entry.writeTo(editor);
            editor.commit();
        }
        catch (IOException _) {
            this.abortQuietly(editor);
        }
    }

    private final void abortQuietly(DiskLruCache.Editor editor) {
        try {
            DiskLruCache.Editor editor2;
            DiskLruCache.Editor editor3 = editor2 = editor;
            if (editor3 != null) {
                editor3.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public final synchronized void trackResponse$okhttp(CacheStrategy cacheStrategy) {
        Intrinsics.checkNotNullParameter(cacheStrategy, "cacheStrategy");
        int n = this.requestCount;
        this.requestCount = n + 1;
        if (cacheStrategy.getNetworkRequest() != null) {
            n = this.networkCount;
            this.networkCount = n + 1;
        } else if (cacheStrategy.getCacheResponse() != null) {
            n = this.hitCount;
            this.hitCount = n + 1;
        }
    }

    public final synchronized void trackConditionalCacheHit$okhttp() {
        int n = this.hitCount;
        this.hitCount = n + 1;
    }

    private final class RealCacheRequest
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private final Sink cacheOut;
        private final Sink body;
        private boolean done;

        public RealCacheRequest(DiskLruCache.Editor editor) {
            Intrinsics.checkNotNullParameter(Cache.this, "this$0");
            Intrinsics.checkNotNullParameter(editor, "editor");
            this.editor = editor;
            this.cacheOut = this.editor.newSink(1);
            Sink sink2 = this.cacheOut;
            this.body = new ForwardingSink(sink2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache2 = Cache.this;
                    RealCacheRequest realCacheRequest = this;
                    Cache cache3 = Cache.this;
                    Cache cache4 = cache2;
                    synchronized (cache4) {
                        boolean bl = false;
                        if (realCacheRequest.getDone()) {
                            return;
                        }
                        realCacheRequest.setDone(true);
                        int n = cache3.getWriteSuccessCount$okhttp();
                        cache3.setWriteSuccessCount$okhttp(n + 1);
                        int n2 = n;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache2 = Cache.this;
            Cache cache3 = Cache.this;
            Cache cache4 = cache2;
            synchronized (cache4) {
                boolean bl = false;
                if (this.getDone()) {
                    return;
                }
                this.setDone(true);
                int n = cache3.getWriteAbortCount$okhttp();
                cache3.setWriteAbortCount$okhttp(n + 1);
                int n2 = n;
            }
            Util.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Sink body() {
            return this.body;
        }
    }

    private static final class Entry {
        public static final Companion Companion = new Companion(null);
        private final HttpUrl url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        private static final String SENT_MILLIS = Intrinsics.stringPlus(Platform.Companion.get().getPrefix(), "-Sent-Millis");
        private static final String RECEIVED_MILLIS = Intrinsics.stringPlus(Platform.Companion.get().getPrefix(), "-Received-Millis");

        private final boolean isHttps() {
            return Intrinsics.areEqual(this.url.scheme(), "https");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public Entry(Source rawSource) throws IOException {
            Intrinsics.checkNotNullParameter(rawSource, "rawSource");
            Closeable closeable = rawSource;
            Throwable throwable = null;
            try {
                long l;
                Source it = (Source)closeable;
                boolean bl = false;
                BufferedSource source2 = Okio.buffer(rawSource);
                String urlLine = source2.readUtf8LineStrict();
                HttpUrl httpUrl = HttpUrl.Companion.parse(urlLine);
                if (httpUrl == null) {
                    void it2;
                    IOException iOException;
                    IOException iOException2 = iOException = new IOException(Intrinsics.stringPlus("Cache corruption for ", urlLine));
                    Entry entry = this;
                    boolean bl2 = false;
                    Platform.Companion.get().log("cache corruption", 5, (Throwable)it2);
                    Entry entry2 = entry;
                    throw (Throwable)iOException;
                }
                this.url = httpUrl;
                this.requestMethod = source2.readUtf8LineStrict();
                Headers.Builder varyHeadersBuilder = new Headers.Builder();
                int varyRequestHeaderLineCount = Companion.readInt$okhttp(source2);
                int it2 = 0;
                while (it2 < varyRequestHeaderLineCount) {
                    int i = it2++;
                    varyHeadersBuilder.addLenient$okhttp(source2.readUtf8LineStrict());
                }
                this.varyHeaders = varyHeadersBuilder.build();
                StatusLine statusLine = StatusLine.Companion.parse(source2.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder responseHeadersBuilder = new Headers.Builder();
                int responseHeaderLineCount = Companion.readInt$okhttp(source2);
                int n = 0;
                while (n < responseHeaderLineCount) {
                    int i = n++;
                    responseHeadersBuilder.addLenient$okhttp(source2.readUtf8LineStrict());
                }
                String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                responseHeadersBuilder.removeAll(SENT_MILLIS);
                responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                String string = sendRequestMillisString;
                this.sentRequestMillis = string == null ? 0L : (l = Long.parseLong(string));
                string = receivedResponseMillisString;
                this.receivedResponseMillis = string == null ? 0L : (l = Long.parseLong(string));
                this.responseHeaders = responseHeadersBuilder.build();
                if (this.isHttps()) {
                    String blank = source2.readUtf8LineStrict();
                    if (((CharSequence)blank).length() > 0) {
                        throw new IOException("expected \"\" but was \"" + blank + '\"');
                    }
                    String cipherSuiteString = source2.readUtf8LineStrict();
                    CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
                    List<Certificate> peerCertificates2 = this.readCertificateList(source2);
                    List<Certificate> localCertificates = this.readCertificateList(source2);
                    TlsVersion tlsVersion = !source2.exhausted() ? TlsVersion.Companion.forJavaName(source2.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.Companion.get(tlsVersion, cipherSuite, peerCertificates2, localCertificates);
                } else {
                    this.handshake = null;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }

        public Entry(Response response) {
            Intrinsics.checkNotNullParameter(response, "response");
            this.url = response.request().url();
            this.varyHeaders = Companion.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeTo(DiskLruCache.Editor editor) throws IOException {
            Intrinsics.checkNotNullParameter(editor, "editor");
            Closeable closeable = Okio.buffer(editor.newSink(0));
            Throwable throwable = null;
            try {
                int i;
                BufferedSink sink2 = (BufferedSink)closeable;
                boolean bl = false;
                sink2.writeUtf8(this.url.toString()).writeByte(10);
                sink2.writeUtf8(this.requestMethod).writeByte(10);
                sink2.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
                int n = 0;
                int n2 = this.varyHeaders.size();
                while (n < n2) {
                    i = n++;
                    sink2.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
                }
                sink2.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
                sink2.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
                n = 0;
                n2 = this.responseHeaders.size();
                while (n < n2) {
                    i = n++;
                    sink2.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
                }
                sink2.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
                sink2.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
                if (this.isHttps()) {
                    sink2.writeByte(10);
                    Handshake handshake2 = this.handshake;
                    Intrinsics.checkNotNull(handshake2);
                    sink2.writeUtf8(handshake2.cipherSuite().javaName()).writeByte(10);
                    this.writeCertList(sink2, this.handshake.peerCertificates());
                    this.writeCertList(sink2, this.handshake.localCertificates());
                    sink2.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }

        private final List<Certificate> readCertificateList(BufferedSource source2) throws IOException {
            int length = Companion.readInt$okhttp(source2);
            if (length == -1) {
                return CollectionsKt.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result2 = new ArrayList<Certificate>(length);
                int n = 0;
                while (n < length) {
                    int i = n++;
                    String line = source2.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    ByteString byteString = ByteString.Companion.decodeBase64(line);
                    Intrinsics.checkNotNull(byteString);
                    bytes.write(byteString);
                    result2.add(certificateFactory.generateCertificate(bytes.inputStream()));
                }
                return result2;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private final void writeCertList(BufferedSink sink2, List<? extends Certificate> certificates) throws IOException {
            try {
                sink2.writeDecimalLong(certificates.size()).writeByte(10);
                for (Certificate certificate : certificates) {
                    byte[] bytes = certificate.getEncoded();
                    Intrinsics.checkNotNullExpressionValue(bytes, "bytes");
                    String line = ByteString.Companion.of$default(ByteString.Companion, bytes, 0, 0, 3, null).base64();
                    sink2.writeUtf8(line).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean matches(Request request, Response response) {
            Intrinsics.checkNotNullParameter(request, "request");
            Intrinsics.checkNotNullParameter(response, "response");
            return Intrinsics.areEqual(this.url, request.url()) && Intrinsics.areEqual(this.requestMethod, request.method()) && Companion.varyMatches(response, this.varyHeaders, request);
        }

        public final Response response(DiskLruCache.Snapshot snapshot) {
            Intrinsics.checkNotNullParameter(snapshot, "snapshot");
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength = this.responseHeaders.get("Content-Length");
            Request cacheRequest = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, contentType, contentLength)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    private static final class CacheResponseBody
    extends ResponseBody {
        private final DiskLruCache.Snapshot snapshot;
        private final String contentType;
        private final String contentLength;
        private final BufferedSource bodySource;

        public CacheResponseBody(DiskLruCache.Snapshot snapshot, String contentType, String contentLength) {
            Intrinsics.checkNotNullParameter(snapshot, "snapshot");
            this.snapshot = snapshot;
            this.contentType = contentType;
            this.contentLength = contentLength;
            final Source source2 = this.snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource(){

                @Override
                public void close() throws IOException {
                    this.getSnapshot().close();
                    super.close();
                }
            });
        }

        public final DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        public long contentLength() {
            long l;
            String string = this.contentLength;
            return string == null ? -1L : (l = Util.toLongOrDefault(string, -1L));
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final String key(HttpUrl url) {
            Intrinsics.checkNotNullParameter(url, "url");
            return ByteString.Companion.encodeUtf8(url.toString()).md5().hex();
        }

        public final int readInt$okhttp(BufferedSource source2) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            try {
                long result2 = source2.readDecimalLong();
                String line = source2.readUtf8LineStrict();
                if (result2 < 0L || result2 > Integer.MAX_VALUE || ((CharSequence)line).length() > 0) {
                    throw new IOException("expected an int but was \"" + result2 + line + '\"');
                }
                return (int)result2;
            }
            catch (NumberFormatException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean varyMatches(Response cachedResponse, Headers cachedRequest, Request newRequest) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(cachedResponse, "cachedResponse");
                Intrinsics.checkNotNullParameter(cachedRequest, "cachedRequest");
                Intrinsics.checkNotNullParameter(newRequest, "newRequest");
                Iterable $this$none$iv = this.varyFields(cachedResponse.headers());
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual(cachedRequest.values(it), newRequest.headers(it)))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean hasVaryAll(Response $this$hasVaryAll) {
            Intrinsics.checkNotNullParameter($this$hasVaryAll, "<this>");
            return this.varyFields($this$hasVaryAll.headers()).contains("*");
        }

        private final Set<String> varyFields(Headers $this$varyFields) {
            Set result2 = null;
            int n = 0;
            int n2 = $this$varyFields.size();
            while (n < n2) {
                int i;
                if (!StringsKt.equals("Vary", $this$varyFields.name(i = n++), true)) continue;
                String value = $this$varyFields.value(i);
                if (result2 == null) {
                    result2 = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
                }
                char[] cArray = new char[]{','};
                for (String varyField : StringsKt.split$default(value, cArray, false, 0, 6, null)) {
                    result2.add(((Object)StringsKt.trim(varyField)).toString());
                }
            }
            Set set = result2;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        public final Headers varyHeaders(Response $this$varyHeaders) {
            Intrinsics.checkNotNullParameter($this$varyHeaders, "<this>");
            Response response = $this$varyHeaders.networkResponse();
            Intrinsics.checkNotNull(response);
            Headers requestHeaders = response.request().headers();
            Headers responseHeaders = $this$varyHeaders.headers();
            return this.varyHeaders(requestHeaders, responseHeaders);
        }

        private final Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
            Set<String> varyFields = this.varyFields(responseHeaders);
            if (varyFields.isEmpty()) {
                return Util.EMPTY_HEADERS;
            }
            Headers.Builder result2 = new Headers.Builder();
            int n = 0;
            int n2 = requestHeaders.size();
            while (n < n2) {
                int i;
                String fieldName;
                if (!varyFields.contains(fieldName = requestHeaders.name(i = n++))) continue;
                result2.add(fieldName, requestHeaders.value(i));
            }
            return result2.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

