/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.NamedValueDecoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonPrimitiveDecoder;
import kotlinx.serialization.json.internal.JsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonTreeListDecoder;
import kotlinx.serialization.json.internal.JsonTreeMapDecoder;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.StringJsonLexer;
import kotlinx.serialization.json.internal.StringJsonLexerKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

abstract class AbstractJsonTreeDecoder
extends NamedValueDecoder
implements JsonDecoder {
    private final Json json;
    private final JsonElement value;
    private final String polymorphicDiscriminator;
    protected final JsonConfiguration configuration;

    private AbstractJsonTreeDecoder(Json json, JsonElement value, String polymorphicDiscriminator) {
        this.json = json;
        this.value = value;
        this.polymorphicDiscriminator = polymorphicDiscriminator;
        this.configuration = this.getJson().getConfiguration();
    }

    public /* synthetic */ AbstractJsonTreeDecoder(Json json, JsonElement jsonElement, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(json, jsonElement, string, null);
    }

    @Override
    public Json getJson() {
        return this.json;
    }

    public JsonElement getValue() {
        return this.value;
    }

    protected final String getPolymorphicDiscriminator() {
        return this.polymorphicDiscriminator;
    }

    @Override
    public SerializersModule getSerializersModule() {
        return this.getJson().getSerializersModule();
    }

    protected final JsonElement currentObject() {
        Object object;
        block3: {
            block2: {
                object = (String)this.getCurrentTagOrNull();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                JsonElement jsonElement = this.currentElement(it);
                object = jsonElement;
                if (jsonElement != null) break block3;
            }
            object = this.getValue();
        }
        return object;
    }

    public final String renderTagStack(String currentTag) {
        Intrinsics.checkNotNullParameter(currentTag, "currentTag");
        return this.renderTagStack() + '.' + currentTag;
    }

    @Override
    public JsonElement decodeJsonElement() {
        return this.currentObject();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer) {
        T t;
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        JsonDecoder $this$decodeSerializableValuePolymorphic$iv = this;
        boolean $i$f$decodeSerializableValuePolymorphic = false;
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
            t = deserializer.deserialize($this$decodeSerializableValuePolymorphic$iv);
        } else {
            DeserializationStrategy deserializationStrategy;
            void value$iv$iv;
            String discriminator$iv = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializer).getDescriptor(), $this$decodeSerializableValuePolymorphic$iv.getJson());
            JsonElement jsonElement = $this$decodeSerializableValuePolymorphic$iv.decodeJsonElement();
            String serialName$iv$iv = ((AbstractPolymorphicSerializer)deserializer).getDescriptor().getSerialName();
            boolean $i$f$cast = false;
            if (!(value$iv$iv instanceof JsonObject)) {
                StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                int n = -1;
                boolean $i$f$decodeSerializableValue$stub_for_inlining = false;
                boolean bl = false;
                String string = this.renderTagStack();
                throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
            }
            JsonObject jsonTree$iv = (JsonObject)value$iv$iv;
            JsonElement jsonElement2 = (JsonElement)jsonTree$iv.get((Object)discriminator$iv);
            String type$iv = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
            try {
                deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer, $this$decodeSerializableValuePolymorphic$iv, type$iv);
            }
            catch (SerializationException it$iv) {
                String string = it$iv.getMessage();
                Intrinsics.checkNotNull(string);
                throw JsonExceptionsKt.JsonDecodingException(-1, string, jsonTree$iv.toString());
            }
            DeserializationStrategy deserializationStrategy2 = deserializationStrategy;
            Intrinsics.checkNotNull(deserializationStrategy2, "null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.decodeSerializableValuePolymorphic>");
            DeserializationStrategy actualSerializer$iv = deserializationStrategy2;
            t = TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic$iv.getJson(), discriminator$iv, jsonTree$iv, actualSerializer$iv);
        }
        return t;
    }

    @Override
    protected String composeName(String parentName, String childName) {
        Intrinsics.checkNotNullParameter(parentName, "parentName");
        Intrinsics.checkNotNullParameter(childName, "childName");
        return childName;
    }

    @Override
    public CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        JsonElement currentObject = this.currentObject();
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind) {
            AbstractJsonTreeDecoder this_$iv = this;
            boolean $i$f$cast = false;
            String serialName$iv$iv = descriptor.getSerialName();
            boolean $i$f$cast2 = false;
            if (!(currentObject instanceof JsonArray)) {
                StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonArray.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(currentObject.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                int n = -1;
                boolean bl = false;
                String string = this_$iv.renderTagStack();
                throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), currentObject.toString());
            }
            compositeDecoder = new JsonTreeListDecoder(this.getJson(), (JsonArray)currentObject);
        } else if (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            AbstractJsonTreeDecoder abstractJsonTreeDecoder;
            Json $this$selectMapMode$iv = this.getJson();
            boolean $i$f$selectMapMode = false;
            SerialDescriptor keyDescriptor$iv = WriteModeKt.carrierDescriptor(descriptor.getElementDescriptor(0), $this$selectMapMode$iv.getSerializersModule());
            SerialKind keyKind$iv = keyDescriptor$iv.getKind();
            if (keyKind$iv instanceof PrimitiveKind || Intrinsics.areEqual(keyKind$iv, SerialKind.ENUM.INSTANCE)) {
                boolean bl = false;
                AbstractJsonTreeDecoder this_$iv = this;
                boolean $i$f$cast = false;
                String serialName$iv$iv = descriptor.getSerialName();
                boolean $i$f$cast3 = false;
                if (!(currentObject instanceof JsonObject)) {
                    StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(currentObject.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                    int n = -1;
                    boolean bl2 = false;
                    String string = this_$iv.renderTagStack();
                    throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), currentObject.toString());
                }
                abstractJsonTreeDecoder = new JsonTreeMapDecoder(this.getJson(), (JsonObject)currentObject);
            } else if ($this$selectMapMode$iv.getConfiguration().getAllowStructuredMapKeys()) {
                boolean bl = false;
                AbstractJsonTreeDecoder this_$iv = this;
                boolean $i$f$cast = false;
                String serialName$iv$iv = descriptor.getSerialName();
                boolean $i$f$cast4 = false;
                if (!(currentObject instanceof JsonArray)) {
                    StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonArray.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(currentObject.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                    int n = -1;
                    boolean bl3 = false;
                    String string = this_$iv.renderTagStack();
                    throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), currentObject.toString());
                }
                abstractJsonTreeDecoder = new JsonTreeListDecoder(this.getJson(), (JsonArray)currentObject);
            } else {
                throw JsonExceptionsKt.InvalidKeyKindException(keyDescriptor$iv);
            }
            compositeDecoder = abstractJsonTreeDecoder;
        } else {
            AbstractJsonTreeDecoder this_$iv = this;
            boolean $i$f$cast = false;
            String serialName$iv$iv = descriptor.getSerialName();
            boolean $i$f$cast5 = false;
            if (!(currentObject instanceof JsonObject)) {
                StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(currentObject.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                int n = -1;
                boolean bl = false;
                String string = this_$iv.renderTagStack();
                throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), currentObject.toString());
            }
            compositeDecoder = new JsonTreeDecoder(this.getJson(), (JsonObject)currentObject, this.polymorphicDiscriminator, null, 8, null);
        }
        return compositeDecoder;
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
    }

    @Override
    public boolean decodeNotNullMark() {
        return !(this.currentObject() instanceof JsonNull);
    }

    private final Void unparsedPrimitive(JsonPrimitive literal, String primitive, String tag) {
        String type = StringsKt.startsWith$default(primitive, "i", false, 2, null) ? "an " + primitive : "a " + primitive;
        throw JsonExceptionsKt.JsonDecodingException(-1, "Failed to parse literal '" + literal + "' as " + type + " value at element: " + this.renderTagStack(tag), this.currentObject().toString());
    }

    protected abstract JsonElement currentElement(String var1);

    @Override
    protected boolean decodeTaggedNotNullMark(String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        return this.currentElement(tag) != JsonNull.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean decodeTaggedBoolean(String tag) {
        Boolean bl;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "boolean";
        boolean $i$f$getPrimitiveValue = false;
        void var5_5 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n = -1;
            boolean bl2 = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive p0 = literal$iv;
            boolean $i$f$decodeTaggedBoolean$stub_for_inlining$5 = false;
            boolean bl3 = false;
            if (JsonElementKt.getBooleanOrNull(p0) == null) {
                super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
                throw new KotlinNothingValueException();
            }
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte decodeTaggedByte(String tag) {
        Byte by;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "byte";
        boolean $i$f$getPrimitiveValue = false;
        void var5_5 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n = -1;
            boolean bl = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive $this$decodeTaggedByte_u24lambda_u246 = literal$iv;
            boolean bl = false;
            int result2 = JsonElementKt.getInt($this$decodeTaggedByte_u24lambda_u246);
            if (((-128 <= result2 ? result2 <= 127 : false) ? Byte.valueOf((byte)result2) : null) == null) {
                super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
                throw new KotlinNothingValueException();
            }
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        return ((Number)by).byteValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short decodeTaggedShort(String tag) {
        Short s;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "short";
        boolean $i$f$getPrimitiveValue = false;
        void var5_5 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n = -1;
            boolean bl = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive $this$decodeTaggedShort_u24lambda_u247 = literal$iv;
            boolean bl = false;
            int result2 = JsonElementKt.getInt($this$decodeTaggedShort_u24lambda_u247);
            if (((Short.MIN_VALUE <= result2 ? result2 <= Short.MAX_VALUE : false) ? Short.valueOf((short)result2) : null) == null) {
                super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
                throw new KotlinNothingValueException();
            }
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        return ((Number)s).shortValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int decodeTaggedInt(String tag) {
        int n;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "int";
        boolean $i$f$getPrimitiveValue = false;
        void var5_5 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n2 = -1;
            boolean bl = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n2, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive $this$decodeTaggedInt_u24lambda_u248 = literal$iv;
            boolean bl = false;
            n = JsonElementKt.getInt($this$decodeTaggedInt_u24lambda_u248);
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long decodeTaggedLong(String tag) {
        long l;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "long";
        boolean $i$f$getPrimitiveValue = false;
        void var5_5 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n = -1;
            boolean bl = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive $this$decodeTaggedLong_u24lambda_u249 = literal$iv;
            boolean bl = false;
            l = JsonElementKt.getLong($this$decodeTaggedLong_u24lambda_u249);
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected float decodeTaggedFloat(String tag) {
        float f;
        float f2;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "float";
        boolean $i$f$getPrimitiveValue = false;
        void var6_7 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n = -1;
            boolean bl = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive $this$decodeTaggedFloat_u24lambda_u2410 = literal$iv;
            boolean bl = false;
            f2 = JsonElementKt.getFloat($this$decodeTaggedFloat_u24lambda_u2410);
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        float result2 = f2;
        boolean specialFp = this.getJson().getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Float.isInfinite(f = result2) && !Float.isNaN(f)) {
            return result2;
        }
        throw JsonExceptionsKt.InvalidFloatingPointDecoded(Float.valueOf(result2), tag, this.currentObject().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected double decodeTaggedDouble(String tag) {
        double d;
        double d2;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "double";
        boolean $i$f$getPrimitiveValue = false;
        void var7_7 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n = -1;
            boolean bl = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive $this$decodeTaggedDouble_u24lambda_u2411 = literal$iv;
            boolean bl = false;
            d2 = JsonElementKt.getDouble($this$decodeTaggedDouble_u24lambda_u2411);
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        double result2 = d2;
        boolean specialFp = this.getJson().getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Double.isInfinite(d = result2) && !Double.isNaN(d)) {
            return result2;
        }
        throw JsonExceptionsKt.InvalidFloatingPointDecoded(result2, tag, this.currentObject().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected char decodeTaggedChar(String tag) {
        char c;
        void this_$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        String primitiveName$iv = "char";
        boolean $i$f$getPrimitiveValue = false;
        void var5_5 = this_$iv;
        JsonElement value$iv$iv = this_$iv.currentElement(tag);
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv$iv instanceof JsonPrimitive)) {
            void this_$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(primitiveName$iv).append(" at element: ");
            int n = -1;
            boolean bl = false;
            String string = this_$iv$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
        }
        JsonPrimitive literal$iv = (JsonPrimitive)value$iv$iv;
        try {
            JsonPrimitive $this$decodeTaggedChar_u24lambda_u2412 = literal$iv;
            boolean bl = false;
            c = StringsKt.single($this$decodeTaggedChar_u24lambda_u2412.getContent());
        }
        catch (IllegalArgumentException e$iv) {
            super.unparsedPrimitive(literal$iv, primitiveName$iv, tag);
            throw new KotlinNothingValueException();
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String decodeTaggedString(String tag) {
        void value$iv;
        Intrinsics.checkNotNullParameter(tag, "tag");
        AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
        JsonElement jsonElement = this.currentElement(tag);
        String serialName$iv = "string";
        boolean $i$f$cast = false;
        boolean $i$f$cast2 = false;
        if (!(value$iv instanceof JsonPrimitive)) {
            void this_$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv).append(" at element: ");
            int n = -1;
            boolean bl = false;
            String string = this_$iv.renderTagStack(tag);
            throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv.toString());
        }
        JsonPrimitive value = (JsonPrimitive)value$iv;
        if (!(value instanceof JsonLiteral)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected string value for a non-null key '" + tag + "', got null literal instead at element: " + this.renderTagStack(tag), this.currentObject().toString());
        }
        if (!((JsonLiteral)value).isString() && !this.getJson().getConfiguration().isLenient()) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "String literal for key '" + tag + "' should be quoted at element: " + this.renderTagStack(tag) + ".\nUse 'isLenient = true' in 'Json {}' builder to accept non-compliant JSON.", this.currentObject().toString());
        }
        return ((JsonLiteral)value).getContent();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Decoder decodeTaggedInline(String tag, SerialDescriptor inlineDescriptor) {
        Decoder decoder;
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(inlineDescriptor, "inlineDescriptor");
        if (StreamingJsonEncoderKt.isUnsignedNumber(inlineDescriptor)) {
            void value$iv$iv;
            AbstractJsonTreeDecoder this_$iv = this;
            boolean $i$f$getPrimitiveValue = false;
            AbstractJsonTreeDecoder abstractJsonTreeDecoder = this_$iv;
            JsonElement jsonElement = this_$iv.currentElement(tag);
            String serialName$iv$iv = inlineDescriptor.getSerialName();
            boolean $i$f$cast = false;
            boolean $i$f$cast2 = false;
            if (!(value$iv$iv instanceof JsonPrimitive)) {
                void this_$iv$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonPrimitive.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                int n = -1;
                boolean bl = false;
                String string = this_$iv$iv.renderTagStack(tag);
                throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv$iv.toString());
            }
            StringJsonLexer lexer = StringJsonLexerKt.StringJsonLexer(this.getJson(), ((JsonPrimitive)value$iv$iv).getContent());
            decoder = new JsonDecoderForUnsignedTypes(lexer, this.getJson());
        } else {
            decoder = super.decodeTaggedInline(tag, inlineDescriptor);
        }
        return decoder;
    }

    @Override
    public Decoder decodeInline(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.getCurrentTagOrNull() != null ? super.decodeInline(descriptor) : new JsonPrimitiveDecoder(this.getJson(), this.getValue(), this.polymorphicDiscriminator).decodeInline(descriptor);
    }

    public /* synthetic */ AbstractJsonTreeDecoder(Json json, JsonElement value, String polymorphicDiscriminator, DefaultConstructorMarker $constructor_marker) {
        this(json, value, polymorphicDiscriminator);
    }
}

