/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.encoding;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.NoOpEncoder;

public abstract class AbstractEncoder
implements CompositeEncoder,
Encoder {
    @Override
    public CompositeEncoder beginStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this;
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
    }

    public boolean encodeElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return true;
    }

    public void encodeValue(Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        throw new SerializationException("Non-serializable " + Reflection.getOrCreateKotlinClass(value.getClass()) + " is not supported by " + Reflection.getOrCreateKotlinClass(this.getClass()) + " encoder");
    }

    @Override
    public void encodeNull() {
        throw new SerializationException("'null' is not supported by default");
    }

    @Override
    public void encodeBoolean(boolean value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeByte(byte value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeShort(short value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeInt(int value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeLong(long value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeFloat(float value) {
        this.encodeValue(Float.valueOf(value));
    }

    @Override
    public void encodeDouble(double value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeChar(char value) {
        this.encodeValue(Character.valueOf(value));
    }

    @Override
    public void encodeString(String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.encodeValue(value);
    }

    @Override
    public Encoder encodeInline(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this;
    }

    @Override
    public final void encodeBooleanElement(SerialDescriptor descriptor, int index, boolean value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeBoolean(value);
        }
    }

    @Override
    public final void encodeByteElement(SerialDescriptor descriptor, int index, byte value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeByte(value);
        }
    }

    @Override
    public final void encodeShortElement(SerialDescriptor descriptor, int index, short value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeShort(value);
        }
    }

    @Override
    public final void encodeIntElement(SerialDescriptor descriptor, int index, int value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeInt(value);
        }
    }

    @Override
    public final void encodeLongElement(SerialDescriptor descriptor, int index, long value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeLong(value);
        }
    }

    @Override
    public final void encodeFloatElement(SerialDescriptor descriptor, int index, float value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeFloat(value);
        }
    }

    @Override
    public final void encodeDoubleElement(SerialDescriptor descriptor, int index, double value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeDouble(value);
        }
    }

    @Override
    public final void encodeCharElement(SerialDescriptor descriptor, int index, char value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.encodeElement(descriptor, index)) {
            this.encodeChar(value);
        }
    }

    @Override
    public final void encodeStringElement(SerialDescriptor descriptor, int index, String value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.encodeElement(descriptor, index)) {
            this.encodeString(value);
        }
    }

    @Override
    public final Encoder encodeInlineElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.encodeElement(descriptor, index) ? this.encodeInline(descriptor.getElementDescriptor(index)) : (Encoder)NoOpEncoder.INSTANCE;
    }

    @Override
    public <T> void encodeSerializableElement(SerialDescriptor descriptor, int index, SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        if (this.encodeElement(descriptor, index)) {
            this.encodeSerializableValue(serializer, value);
        }
    }

    @Override
    public CompositeEncoder beginCollection(SerialDescriptor descriptor, int collectionSize) {
        return Encoder.DefaultImpls.beginCollection(this, descriptor, collectionSize);
    }

    @Override
    public <T> void encodeSerializableValue(SerializationStrategy<? super T> serializer, T value) {
        Encoder.DefaultImpls.encodeSerializableValue(this, serializer, value);
    }
}

