/*
 * Decompiled with CFR 0.152.
 */
package kotlin.sequences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.DropSequence;
import kotlin.sequences.DropTakeSequence;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.sequences.SequencesKt___SequencesJvmKt;
import kotlin.sequences.TransformingSequence;
import kotlin.text.StringsKt;

class SequencesKt___SequencesKt
extends SequencesKt___SequencesJvmKt {
    public static final <T> Sequence<T> drop(Sequence<? extends T> $this$drop, int n) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$drop, "<this>");
        boolean bl2 = bl = n >= 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Requested element count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return n == 0 ? $this$drop : ($this$drop instanceof DropTakeSequence ? ((DropTakeSequence)$this$drop).drop(n) : (Sequence)new DropSequence<T>($this$drop, n));
    }

    public static final <T> List<T> toList(Sequence<? extends T> $this$toList) {
        Intrinsics.checkNotNullParameter($this$toList, "<this>");
        Iterator<T> it = $this$toList.iterator();
        if (!it.hasNext()) {
            return CollectionsKt.emptyList();
        }
        T element = it.next();
        if (!it.hasNext()) {
            return CollectionsKt.listOf(element);
        }
        ArrayList<T> dst = new ArrayList<T>();
        dst.add(element);
        while (it.hasNext()) {
            dst.add(it.next());
        }
        return dst;
    }

    public static final <T, R> Sequence<R> map(Sequence<? extends T> $this$map, Function1<? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter($this$map, "<this>");
        Intrinsics.checkNotNullParameter(transform, "transform");
        return new TransformingSequence<T, R>($this$map, transform);
    }

    public static final <T, A extends Appendable> A joinTo(Sequence<? extends T> $this$joinTo, A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, int limit, CharSequence truncated, Function1<? super T, ? extends CharSequence> transform) {
        Intrinsics.checkNotNullParameter($this$joinTo, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        Intrinsics.checkNotNullParameter(truncated, "truncated");
        buffer.append(prefix);
        int count = 0;
        Iterator<T> iterator2 = $this$joinTo.iterator();
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (++count > 1) {
                buffer.append(separator);
            }
            if (limit >= 0 && count > limit) break;
            StringsKt.appendElement(buffer, element, transform);
        }
        if (limit >= 0 && count > limit) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
        return buffer;
    }

    public static final <T> String joinToString(Sequence<? extends T> $this$joinToString, CharSequence separator, CharSequence prefix, CharSequence postfix, int limit, CharSequence truncated, Function1<? super T, ? extends CharSequence> transform) {
        Intrinsics.checkNotNullParameter($this$joinToString, "<this>");
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        Intrinsics.checkNotNullParameter(truncated, "truncated");
        String string = ((StringBuilder)SequencesKt.joinTo($this$joinToString, (Appendable)new StringBuilder(), separator, prefix, postfix, limit, truncated, transform)).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String joinToString$default(Sequence sequence, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x20) != 0) {
            function1 = null;
        }
        return SequencesKt.joinToString(sequence, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static final <T> Iterable<T> asIterable(Sequence<? extends T> $this$asIterable) {
        Intrinsics.checkNotNullParameter($this$asIterable, "<this>");
        return new Iterable<T>($this$asIterable){
            final /* synthetic */ Sequence $this_asIterable$inlined;
            {
                this.$this_asIterable$inlined = sequence;
            }

            public Iterator<T> iterator() {
                boolean bl = false;
                return this.$this_asIterable$inlined.iterator();
            }
        };
    }
}

