/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.CollectionsKt___CollectionsJvmKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;

class CollectionsKt___CollectionsKt
extends CollectionsKt___CollectionsJvmKt {
    public static final <T> boolean contains(Iterable<? extends T> $this$contains, T element) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        if ($this$contains instanceof Collection) {
            return ((Collection)$this$contains).contains(element);
        }
        return CollectionsKt.indexOf($this$contains, element) >= 0;
    }

    public static final <T> T first(Iterable<? extends T> $this$first) {
        Intrinsics.checkNotNullParameter($this$first, "<this>");
        if ($this$first instanceof List) {
            return CollectionsKt.first((List)$this$first);
        }
        Iterator<T> iterator2 = $this$first.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException("Collection is empty.");
        }
        return iterator2.next();
    }

    public static final <T> T first(List<? extends T> $this$first) {
        Intrinsics.checkNotNullParameter($this$first, "<this>");
        if ($this$first.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        return $this$first.get(0);
    }

    public static final <T> T firstOrNull(List<? extends T> $this$firstOrNull) {
        Intrinsics.checkNotNullParameter($this$firstOrNull, "<this>");
        return $this$firstOrNull.isEmpty() ? null : (T)$this$firstOrNull.get(0);
    }

    public static final <T> T getOrNull(List<? extends T> $this$getOrNull, int index) {
        Intrinsics.checkNotNullParameter($this$getOrNull, "<this>");
        return (0 <= index ? index < $this$getOrNull.size() : false) ? (T)$this$getOrNull.get(index) : null;
    }

    public static final <T> int indexOf(Iterable<? extends T> $this$indexOf, T element) {
        Intrinsics.checkNotNullParameter($this$indexOf, "<this>");
        if ($this$indexOf instanceof List) {
            return ((List)$this$indexOf).indexOf(element);
        }
        int index = 0;
        for (T item : $this$indexOf) {
            if (index < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            if (Intrinsics.areEqual(element, item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static final <T> T last(Iterable<? extends T> $this$last) {
        Intrinsics.checkNotNullParameter($this$last, "<this>");
        if ($this$last instanceof List) {
            return CollectionsKt.last((List)$this$last);
        }
        Iterator<T> iterator2 = $this$last.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException("Collection is empty.");
        }
        T last = iterator2.next();
        while (iterator2.hasNext()) {
            last = iterator2.next();
        }
        return last;
    }

    public static final <T> T last(List<? extends T> $this$last) {
        Intrinsics.checkNotNullParameter($this$last, "<this>");
        if ($this$last.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        return $this$last.get(CollectionsKt.getLastIndex($this$last));
    }

    public static final <T> T lastOrNull(List<? extends T> $this$lastOrNull) {
        Intrinsics.checkNotNullParameter($this$lastOrNull, "<this>");
        return $this$lastOrNull.isEmpty() ? null : (T)$this$lastOrNull.get($this$lastOrNull.size() - 1);
    }

    public static final <T> T single(Iterable<? extends T> $this$single) {
        Intrinsics.checkNotNullParameter($this$single, "<this>");
        if ($this$single instanceof List) {
            return CollectionsKt.single((List)$this$single);
        }
        Iterator<T> iterator2 = $this$single.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException("Collection is empty.");
        }
        T single = iterator2.next();
        if (iterator2.hasNext()) {
            throw new IllegalArgumentException("Collection has more than one element.");
        }
        return single;
    }

    public static final <T> T single(List<? extends T> $this$single) {
        Intrinsics.checkNotNullParameter($this$single, "<this>");
        switch ($this$single.size()) {
            case 0: {
                throw new NoSuchElementException("List is empty.");
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("List has more than one element.");
            }
        }
        return $this$single.get(0);
    }

    public static final <T> T singleOrNull(List<? extends T> $this$singleOrNull) {
        Intrinsics.checkNotNullParameter($this$singleOrNull, "<this>");
        return $this$singleOrNull.size() == 1 ? (T)$this$singleOrNull.get(0) : null;
    }

    public static final <T> List<T> drop(Iterable<? extends T> $this$drop, int n) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$drop, "<this>");
        boolean bl2 = bl = n >= 0;
        if (!bl) {
            boolean $i$a$-require-CollectionsKt___CollectionsKt$drop$22 = false;
            String $i$a$-require-CollectionsKt___CollectionsKt$drop$22 = "Requested element count " + n + " is less than zero.";
            throw new IllegalArgumentException($i$a$-require-CollectionsKt___CollectionsKt$drop$22.toString());
        }
        if (n == 0) {
            return CollectionsKt.toList($this$drop);
        }
        ArrayList<Object> list = null;
        if ($this$drop instanceof Collection) {
            int resultSize = ((Collection)$this$drop).size() - n;
            if (resultSize <= 0) {
                return CollectionsKt.emptyList();
            }
            if (resultSize == 1) {
                return CollectionsKt.listOf(CollectionsKt.last($this$drop));
            }
            list = new ArrayList(resultSize);
            if ($this$drop instanceof List) {
                if ($this$drop instanceof RandomAccess) {
                    int n2 = ((Collection)$this$drop).size();
                    for (int index = n; index < n2; ++index) {
                        list.add(((List)$this$drop).get(index));
                    }
                } else {
                    Iterator iterator2 = ((List)$this$drop).listIterator(n);
                    while (iterator2.hasNext()) {
                        Object item = iterator2.next();
                        list.add(item);
                    }
                }
                return list;
            }
        } else {
            list = new ArrayList<Object>();
        }
        int count = 0;
        for (T item : $this$drop) {
            if (count >= n) {
                list.add(item);
                continue;
            }
            ++count;
        }
        return CollectionsKt.optimizeReadOnlyList((List)list);
    }

    public static final <T> List<T> dropLast(List<? extends T> $this$dropLast, int n) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$dropLast, "<this>");
        boolean bl2 = bl = n >= 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Requested element count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.take((Iterable)$this$dropLast, RangesKt.coerceAtLeast($this$dropLast.size() - n, 0));
    }

    public static final <T> List<T> take(Iterable<? extends T> $this$take, int n) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$take, "<this>");
        boolean bl2 = bl = n >= 0;
        if (!bl) {
            boolean $i$a$-require-CollectionsKt___CollectionsKt$take$22 = false;
            String $i$a$-require-CollectionsKt___CollectionsKt$take$22 = "Requested element count " + n + " is less than zero.";
            throw new IllegalArgumentException($i$a$-require-CollectionsKt___CollectionsKt$take$22.toString());
        }
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        if ($this$take instanceof Collection) {
            if (n >= ((Collection)$this$take).size()) {
                return CollectionsKt.toList($this$take);
            }
            if (n == 1) {
                return CollectionsKt.listOf(CollectionsKt.first($this$take));
            }
        }
        int count = 0;
        ArrayList<T> list = new ArrayList<T>(n);
        for (T item : $this$take) {
            list.add(item);
            if (++count != n) continue;
            break;
        }
        return CollectionsKt.optimizeReadOnlyList((List)list);
    }

    public static final boolean[] toBooleanArray(Collection<Boolean> $this$toBooleanArray) {
        Intrinsics.checkNotNullParameter($this$toBooleanArray, "<this>");
        boolean[] result2 = new boolean[$this$toBooleanArray.size()];
        int index = 0;
        for (boolean element : $this$toBooleanArray) {
            result2[index++] = element;
        }
        return result2;
    }

    public static final <T, C extends Collection<? super T>> C toCollection(Iterable<? extends T> $this$toCollection, C destination) {
        Intrinsics.checkNotNullParameter($this$toCollection, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        for (T item : $this$toCollection) {
            destination.add(item);
        }
        return destination;
    }

    public static final <T> HashSet<T> toHashSet(Iterable<? extends T> $this$toHashSet) {
        Intrinsics.checkNotNullParameter($this$toHashSet, "<this>");
        return (HashSet)CollectionsKt.toCollection($this$toHashSet, (Collection)new HashSet(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$toHashSet, 12))));
    }

    public static final <T> List<T> toList(Iterable<? extends T> $this$toList) {
        Intrinsics.checkNotNullParameter($this$toList, "<this>");
        if ($this$toList instanceof Collection) {
            List list;
            switch (((Collection)$this$toList).size()) {
                case 0: {
                    list = CollectionsKt.emptyList();
                    break;
                }
                case 1: {
                    list = CollectionsKt.listOf($this$toList instanceof List ? ((List)$this$toList).get(0) : $this$toList.iterator().next());
                    break;
                }
                default: {
                    list = CollectionsKt.toMutableList((Collection)$this$toList);
                }
            }
            return list;
        }
        return CollectionsKt.optimizeReadOnlyList(CollectionsKt.toMutableList($this$toList));
    }

    public static final <T> List<T> toMutableList(Iterable<? extends T> $this$toMutableList) {
        Intrinsics.checkNotNullParameter($this$toMutableList, "<this>");
        if ($this$toMutableList instanceof Collection) {
            return CollectionsKt.toMutableList((Collection)$this$toMutableList);
        }
        return (List)CollectionsKt.toCollection($this$toMutableList, (Collection)new ArrayList());
    }

    public static final <T> List<T> toMutableList(Collection<? extends T> $this$toMutableList) {
        Intrinsics.checkNotNullParameter($this$toMutableList, "<this>");
        return new ArrayList<T>($this$toMutableList);
    }

    public static final <T> Set<T> toSet(Iterable<? extends T> $this$toSet) {
        Intrinsics.checkNotNullParameter($this$toSet, "<this>");
        if ($this$toSet instanceof Collection) {
            Set set;
            switch (((Collection)$this$toSet).size()) {
                case 0: {
                    set = SetsKt.emptySet();
                    break;
                }
                case 1: {
                    set = SetsKt.setOf($this$toSet instanceof List ? ((List)$this$toSet).get(0) : $this$toSet.iterator().next());
                    break;
                }
                default: {
                    set = (Set)CollectionsKt.toCollection($this$toSet, (Collection)new LinkedHashSet(MapsKt.mapCapacity(((Collection)$this$toSet).size())));
                }
            }
            return set;
        }
        return SetsKt.optimizeReadOnlySet((Set)CollectionsKt.toCollection($this$toSet, (Collection)new LinkedHashSet()));
    }

    public static final <T extends Comparable<? super T>> T minOrNull(Iterable<? extends T> $this$minOrNull) {
        Intrinsics.checkNotNullParameter($this$minOrNull, "<this>");
        Iterator<T> iterator2 = $this$minOrNull.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        Comparable min = (Comparable)iterator2.next();
        while (iterator2.hasNext()) {
            Comparable e = (Comparable)iterator2.next();
            if (min.compareTo(e) <= 0) continue;
            min = e;
        }
        return (T)min;
    }

    public static final <T> List<T> plus(Collection<? extends T> $this$plus, T element) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        ArrayList<T> result2 = new ArrayList<T>($this$plus.size() + 1);
        result2.addAll($this$plus);
        result2.add(element);
        return result2;
    }

    public static final <T> List<T> plus(Collection<? extends T> $this$plus, Iterable<? extends T> elements) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements instanceof Collection) {
            ArrayList<T> result2 = new ArrayList<T>($this$plus.size() + ((Collection)elements).size());
            result2.addAll($this$plus);
            result2.addAll((Collection)elements);
            return result2;
        }
        ArrayList<? extends T> result3 = new ArrayList<T>($this$plus);
        CollectionsKt.addAll((Collection)result3, elements);
        return result3;
    }

    public static final <T, A extends Appendable> A joinTo(Iterable<? extends T> $this$joinTo, A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, int limit, CharSequence truncated, Function1<? super T, ? extends CharSequence> transform) {
        Intrinsics.checkNotNullParameter($this$joinTo, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        Intrinsics.checkNotNullParameter(truncated, "truncated");
        buffer.append(prefix);
        int count = 0;
        for (T element : $this$joinTo) {
            if (++count > 1) {
                buffer.append(separator);
            }
            if (limit >= 0 && count > limit) break;
            StringsKt.appendElement(buffer, element, transform);
        }
        if (limit >= 0 && count > limit) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
        return buffer;
    }

    public static /* synthetic */ Appendable joinTo$default(Iterable iterable, Appendable appendable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 4) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 8) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x40) != 0) {
            function1 = null;
        }
        return CollectionsKt.joinTo(iterable, appendable, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static final <T> String joinToString(Iterable<? extends T> $this$joinToString, CharSequence separator, CharSequence prefix, CharSequence postfix, int limit, CharSequence truncated, Function1<? super T, ? extends CharSequence> transform) {
        Intrinsics.checkNotNullParameter($this$joinToString, "<this>");
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        Intrinsics.checkNotNullParameter(truncated, "truncated");
        String string = ((StringBuilder)CollectionsKt.joinTo($this$joinToString, (Appendable)new StringBuilder(), separator, prefix, postfix, limit, truncated, transform)).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String joinToString$default(Iterable iterable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x20) != 0) {
            function1 = null;
        }
        return CollectionsKt.joinToString(iterable, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static final <T> Sequence<T> asSequence(Iterable<? extends T> $this$asSequence) {
        Intrinsics.checkNotNullParameter($this$asSequence, "<this>");
        return new Sequence<T>($this$asSequence){
            final /* synthetic */ Iterable $this_asSequence$inlined;
            {
                this.$this_asSequence$inlined = iterable;
            }

            public Iterator<T> iterator() {
                boolean bl = false;
                return this.$this_asSequence$inlined.iterator();
            }
        };
    }
}

