/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.http.HttpBody;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

public final class HttpRequest {
    private final HttpMethod method;
    private final String url;
    private final List<HttpHeader> headers;
    private final HttpBody body;
    private final ExecutionContext executionContext;

    private HttpRequest(HttpMethod method, String url, List<HttpHeader> headers, HttpBody body, ExecutionContext executionContext) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.executionContext = executionContext;
    }

    public final HttpMethod getMethod() {
        return this.method;
    }

    public final String getUrl() {
        return this.url;
    }

    public final List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public final HttpBody getBody() {
        return this.body;
    }

    public final Builder newBuilder(HttpMethod method, String url) {
        Builder builder;
        Intrinsics.checkNotNullParameter((Object)method, "method");
        Intrinsics.checkNotNullParameter(url, "url");
        Builder $this$newBuilder_u24lambda_u240 = builder = new Builder(method, url);
        boolean bl = false;
        if (this.body != null) {
            $this$newBuilder_u24lambda_u240.body(this.body);
        }
        $this$newBuilder_u24lambda_u240.addHeaders(this.headers);
        return builder;
    }

    public static /* synthetic */ Builder newBuilder$default(HttpRequest httpRequest, HttpMethod httpMethod, String string, int n, Object object) {
        if ((n & 1) != 0) {
            httpMethod = httpRequest.method;
        }
        if ((n & 2) != 0) {
            string = httpRequest.url;
        }
        return httpRequest.newBuilder(httpMethod, string);
    }

    public /* synthetic */ HttpRequest(HttpMethod method, String url, List headers, HttpBody body, ExecutionContext executionContext, DefaultConstructorMarker $constructor_marker) {
        this(method, url, headers, body, executionContext);
    }

    public static final class Builder {
        private final HttpMethod method;
        private final String url;
        private HttpBody body;
        private final List<HttpHeader> headers;
        private ExecutionContext executionContext;

        public Builder(HttpMethod method, String url) {
            Intrinsics.checkNotNullParameter((Object)method, "method");
            Intrinsics.checkNotNullParameter(url, "url");
            this.method = method;
            this.url = url;
            this.headers = new ArrayList();
            this.executionContext = ExecutionContext.Empty;
        }

        public final Builder body(HttpBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter(body, "body");
            Builder $this$body_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u240.body = body;
            return builder;
        }

        public final Builder addHeader(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$addHeader_u24lambda_u241 = builder = this;
            boolean bl = false;
            ((Collection)$this$addHeader_u24lambda_u241.headers).add(new HttpHeader(name, value));
            return builder;
        }

        public final Builder addHeaders(List<HttpHeader> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, "headers");
            Builder $this$addHeaders_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addHeaders_u24lambda_u242.headers.addAll((Collection<HttpHeader>)headers);
            return builder;
        }

        public final Builder addExecutionContext(ExecutionContext executionContext) {
            Builder builder;
            Intrinsics.checkNotNullParameter(executionContext, "executionContext");
            Builder $this$addExecutionContext_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$addExecutionContext_u24lambda_u243.executionContext = $this$addExecutionContext_u24lambda_u243.executionContext.plus(executionContext);
            return builder;
        }

        public final HttpRequest build() {
            return new HttpRequest(this.method, this.url, this.headers, this.body, this.executionContext, null);
        }
    }
}

