/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.Upload;
import com.apollographql.apollo.api.http.HttpBody;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.apollo.api.http.UploadsHttpBody;
import com.apollographql.apollo.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.api.json.MapJsonWriter;
import com.apollographql.apollo.api.json.internal.FileUploadAwareJsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    public static final Companion Companion = new Companion(null);
    private final String serverUrl;
    private static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    private static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    private static final String HEADER_APOLLO_REQUIRE_PREFLIGHT = "Apollo-Require-Preflight";
    private static final String HEADER_ACCEPT_NAME = "Accept";
    private static final String HEADER_ACCEPT_VALUE_DEFER = "multipart/mixed;deferSpec=20220824, application/json";
    private static final String HEADER_ACCEPT_VALUE_MULTIPART = "multipart/mixed;subscriptionSpec=1.0, application/json";

    public DefaultHttpRequestComposer(String serverUrl2) {
        Intrinsics.checkNotNullParameter(serverUrl2, "serverUrl");
        this.serverUrl = serverUrl2;
    }

    @Override
    public <D extends Operation.Data> HttpRequest compose(ApolloRequest<D> apolloRequest) {
        HttpRequest.Builder builder;
        List list;
        Intrinsics.checkNotNullParameter(apolloRequest, "apolloRequest");
        Operation<D> operation = apolloRequest.getOperation();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
        List $this$compose_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        boolean bl2 = apolloRequest.getOperation() instanceof Subscription ? $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_MULTIPART)) : $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_DEFER));
        if (apolloRequest.getHttpHeaders() != null) {
            $this$compose_u24lambda_u240.addAll((Collection)apolloRequest.getHttpHeaders());
        }
        List requestHeaders = list;
        Boolean bl3 = apolloRequest.getSendApqExtensions();
        boolean sendApqExtensions = bl3 != null ? bl3 : false;
        Boolean bl4 = apolloRequest.getSendDocument();
        boolean sendDocument = bl4 != null ? bl4 : true;
        HttpMethod httpMethod = apolloRequest.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                builder = new HttpRequest.Builder(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, customScalarAdapters2, sendApqExtensions, sendDocument)).addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                break;
            }
            case 2: {
                String query2 = sendDocument ? operation.document() : null;
                HttpBody body = Companion.buildPostBody(operation, customScalarAdapters2, sendApqExtensions, query2);
                HttpRequest.Builder it = new HttpRequest.Builder(HttpMethod.Post, this.serverUrl).body(body);
                boolean bl5 = false;
                if (StringsKt.startsWith$default(body.getContentType(), "multipart/form-data", false, 2, null)) {
                    builder = it.addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                    break;
                }
                builder = it;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest.Builder httpRequestBuilder = builder;
        return httpRequestBuilder.addHeaders(requestHeaders).addExecutionContext(apolloRequest.getExecutionContext()).build();
    }

    public static final class Companion {
        private Companion() {
        }

        private final <D extends Operation.Data> String buildGetUrl(String serverUrl2, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendDocument) {
            return this.appendQueryParameters(serverUrl2, this.composeGetParams(operation, customScalarAdapters, sendApqExtensions, sendDocument));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, String query2, Function1<? super JsonWriter, Unit> extensionsWriter) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u241 = $this$writeObject$iv;
            boolean bl = false;
            $this$composePostParams_u24lambda_u241.name("operationName");
            $this$composePostParams_u24lambda_u241.value(operation.name());
            $this$composePostParams_u24lambda_u241.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composePostParams_u24lambda_u241);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u241_u24lambda_u240 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composePostParams_u24lambda_u241_u24lambda_u240, customScalarAdapters, false);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query2 != null) {
                $this$composePostParams_u24lambda_u241.name("query");
                $this$composePostParams_u24lambda_u241.value(query2);
            }
            extensionsWriter.invoke($this$composePostParams_u24lambda_u241);
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, String query2) {
            return this.composePostParams(writer, operation, customScalarAdapters, query2, this.apqExtensionsWriter(operation.id(), sendApqExtensions));
        }

        private final Function1<JsonWriter, Unit> apqExtensionsWriter(String id, boolean sendApqExtensions) {
            return arg_0 -> Companion.apqExtensionsWriter$lambda$4(sendApqExtensions, id, arg_0);
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            String indent$iv = null;
            boolean $i$f$buildJsonString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u247 = new BufferedSinkJsonWriter(buffer$iv, indent$iv);
            boolean bl = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composeGetParams_u24lambda_u247);
            JsonWriter $this$writeObject$iv = uploadAwareWriter;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u247_u24lambda_u245 = $this$writeObject$iv;
            boolean bl2 = false;
            operation.serializeVariables($this$composeGetParams_u24lambda_u247_u24lambda_u245, customScalarAdapters, false);
            $this$writeObject$iv.endObject();
            if (!uploadAwareWriter.collectedUploads().isEmpty()) {
                boolean $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = false;
                String $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = "FileUpload and Http GET are not supported at the same time";
                throw new IllegalStateException($i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            if (autoPersistQueries) {
                String indent$iv2 = null;
                boolean $i$f$buildJsonString2 = false;
                Buffer buffer$iv2 = new Buffer();
                JsonWriter $this$composeGetParams_u24lambda_u2410 = new BufferedSinkJsonWriter(buffer$iv2, indent$iv2);
                boolean bl3 = false;
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u2410;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2410_u24lambda_u249 = $this$writeObject$iv;
                boolean bl4 = false;
                $this$composeGetParams_u24lambda_u2410_u24lambda_u249.name("persistedQuery");
                JsonWriter $this$writeObject$iv2 = $this$composeGetParams_u24lambda_u2410_u24lambda_u249;
                boolean $i$f$writeObject2 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = $this$writeObject$iv2;
                boolean bl5 = false;
                $this$composeGetParams_u24lambda_u2410_u24lambda_u249_u24lambda_u248.name("version").value(1);
                $this$composeGetParams_u24lambda_u2410_u24lambda_u249_u24lambda_u248.name("sha256Hash").value(operation.id());
                $this$writeObject$iv2.endObject();
                $this$writeObject$iv.endObject();
                String extensions = buffer$iv2.readUtf8();
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        public final String appendQueryParameters(String $this$appendQueryParameters, Map<String, String> parameters) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter($this$appendQueryParameters, "<this>");
            Intrinsics.checkNotNullParameter(parameters, "parameters");
            StringBuilder $this$appendQueryParameters_u24lambda_u2412 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$appendQueryParameters_u24lambda_u2412.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, "?", false, 2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StringBuilder stringBuilder2;
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                if (hasQuestionMark) {
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u2412.append('&');
                } else {
                    hasQuestionMark = true;
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u2412.append('?');
                }
                $this$appendQueryParameters_u24lambda_u2412.append(UrlEncodeKt.urlEncode((String)it.getKey()));
                $this$appendQueryParameters_u24lambda_u2412.append('=');
                $this$appendQueryParameters_u24lambda_u2412.append(UrlEncodeKt.urlEncode((String)it.getValue()));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public final <D extends Operation.Data> HttpBody buildPostBody(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, String query2) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
            return this.buildPostBody(operation, customScalarAdapters, query2, this.apqExtensionsWriter(operation.id(), autoPersistQueries));
        }

        public final <D extends Operation.Data> HttpBody buildPostBody(Operation<D> operation, CustomScalarAdapters customScalarAdapters, String query2, Function1<? super JsonWriter, Unit> extensionsWriter) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
            Intrinsics.checkNotNullParameter(extensionsWriter, "extensionsWriter");
            Map uploads = null;
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildPostBody_u24lambda_u2413 = new BufferedSinkJsonWriter(buffer$iv, indent$iv);
            boolean bl = false;
            uploads = Companion.composePostParams($this$buildPostBody_u24lambda_u2413, operation, customScalarAdapters, query2, extensionsWriter);
            ByteString operationByteString = buffer$iv.readByteString();
            return uploads.isEmpty() ? (HttpBody)new HttpBody(operationByteString){
                private final String contentType;
                private final long contentLength;
                final /* synthetic */ ByteString $operationByteString;
                {
                    this.$operationByteString = $operationByteString;
                    this.contentType = "application/json";
                    this.contentLength = $operationByteString.size();
                }

                public String getContentType() {
                    return this.contentType;
                }

                public long getContentLength() {
                    return this.contentLength;
                }

                public void writeTo(BufferedSink bufferedSink) {
                    Intrinsics.checkNotNullParameter(bufferedSink, "bufferedSink");
                    bufferedSink.write(this.$operationByteString);
                }
            } : (HttpBody)new UploadsHttpBody(uploads, operationByteString);
        }

        public final <D extends Operation.Data> Map<String, Object> composePayload(ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, "apolloRequest");
            Operation<D> operation = apolloRequest.getOperation();
            Boolean bl = apolloRequest.getSendApqExtensions();
            boolean sendApqExtensions = bl != null ? bl : false;
            Boolean bl2 = apolloRequest.getSendDocument();
            boolean sendDocument = bl2 != null ? bl2 : true;
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
            if (customScalarAdapters == null) {
                customScalarAdapters = CustomScalarAdapters.Empty;
            }
            CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
            String query2 = sendDocument ? operation.document() : null;
            boolean $i$f$buildJsonMap = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter $this$composePayload_u24lambda_u2415 = writer$iv;
            boolean bl3 = false;
            Companion.composePostParams($this$composePayload_u24lambda_u2415, operation, customScalarAdapters2, sendApqExtensions, query2);
            Object object = writer$iv.root();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            return (Map)object;
        }

        private static final Unit apqExtensionsWriter$lambda$4(boolean $sendApqExtensions, String $id, JsonWriter jsonWriter) {
            Intrinsics.checkNotNullParameter($id, "$id");
            Intrinsics.checkNotNullParameter(jsonWriter, "<this>");
            if ($sendApqExtensions) {
                jsonWriter.name("extensions");
                JsonWriter $this$writeObject$iv = jsonWriter;
                boolean $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$apqExtensionsWriter_u24lambda_u244_u24lambda_u243 = $this$writeObject$iv;
                boolean bl = false;
                $this$apqExtensionsWriter_u24lambda_u244_u24lambda_u243.name("persistedQuery");
                JsonWriter $this$writeObject$iv2 = $this$apqExtensionsWriter_u24lambda_u244_u24lambda_u243;
                boolean $i$f$writeObject2 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$apqExtensionsWriter_u24lambda_u244_u24lambda_u243_u24lambda_u242 = $this$writeObject$iv2;
                boolean bl2 = false;
                $this$apqExtensionsWriter_u24lambda_u244_u24lambda_u243_u24lambda_u242.name("version").value(1);
                $this$apqExtensionsWriter_u24lambda_u244_u24lambda_u243_u24lambda_u242.name("sha256Hash").value($id);
                $this$writeObject$iv2.endObject();
                $this$writeObject$iv.endObject();
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.Get.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.Post.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

