/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexV1;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public abstract class PackBitmapIndex {
    public static final int FLAG_REUSE = 1;
    byte[] packChecksum;

    public static PackBitmapIndex open(File idxFile, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        SilentFileInputStream fd = new SilentFileInputStream(idxFile);
        try {
            PackBitmapIndex packBitmapIndex = PackBitmapIndex.read(fd, packIndex, reverseIndex);
            return packBitmapIndex;
        }
        catch (IOException ioe) {
            throw new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, idxFile.getAbsolutePath()), ioe);
        }
        finally {
            try {
                fd.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public static PackBitmapIndex read(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        return new PackBitmapIndexV1(fd, packIndex, reverseIndex);
    }

    public abstract int findPosition(AnyObjectId var1);

    public abstract ObjectId getObject(int var1) throws IllegalArgumentException;

    public abstract EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap var1, int var2);

    public abstract EWAHCompressedBitmap getBitmap(AnyObjectId var1);

    public abstract int getObjectCount();

    public abstract int getBitmapCount();
}

