/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;

public class AndroidSocketAdapter
implements SocketAdapter {
    public static final Companion Companion = new Companion(null);
    private final Class<? super SSLSocket> sslSocketClass;
    private final Method setUseSessionTickets;
    private final Method setHostname;
    private final Method getAlpnSelectedProtocol;
    private final Method setAlpnProtocols;
    private static final DeferredSocketAdapter.Factory playProviderFactory = Companion.factory("com.google.android.gms.org.conscrypt");

    public AndroidSocketAdapter(Class<? super SSLSocket> sslSocketClass) {
        Intrinsics.checkNotNullParameter(sslSocketClass, "sslSocketClass");
        this.sslSocketClass = sslSocketClass;
        Class[] classArray = new Class[]{Boolean.TYPE};
        Class[] classArray2 = this.sslSocketClass.getDeclaredMethod("setUseSessionTickets", classArray);
        Intrinsics.checkNotNullExpressionValue(classArray2, "sslSocketClass.getDeclar\u2026:class.javaPrimitiveType)");
        this.setUseSessionTickets = classArray2;
        classArray2 = new Class[]{String.class};
        this.setHostname = this.sslSocketClass.getMethod("setHostname", classArray2);
        this.getAlpnSelectedProtocol = this.sslSocketClass.getMethod("getAlpnSelectedProtocol", new Class[0]);
        classArray2 = new Class[]{byte[].class};
        this.setAlpnProtocols = this.sslSocketClass.getMethod("setAlpnProtocols", classArray2);
    }

    @Override
    public boolean isSupported() {
        return AndroidPlatform.Companion.isSupported();
    }

    @Override
    public boolean matchesSocket(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        return this.sslSocketClass.isInstance(sslSocket);
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(protocols, "protocols");
        if (this.matchesSocket(sslSocket)) {
            try {
                Object[] objectArray = new Object[]{true};
                this.setUseSessionTickets.invoke((Object)sslSocket, objectArray);
                if (hostname != null) {
                    objectArray = new Object[]{hostname};
                    this.setHostname.invoke((Object)sslSocket, objectArray);
                }
                objectArray = new Object[]{Platform.Companion.concatLengthPrefixed(protocols)};
                this.setAlpnProtocols.invoke((Object)sslSocket, objectArray);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket sslSocket) {
        String string;
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        if (!this.matchesSocket(sslSocket)) {
            return null;
        }
        try {
            byte[] alpnResult;
            byte[] byArray = alpnResult = (byte[])this.getAlpnSelectedProtocol.invoke((Object)sslSocket, new Object[0]);
            string = byArray == null ? null : new String(byArray, Charsets.UTF_8);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof NullPointerException) || !Intrinsics.areEqual(((NullPointerException)cause).getMessage(), "ssl == null")) {
                throw new AssertionError((Object)e);
            }
            string = null;
        }
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public final DeferredSocketAdapter.Factory getPlayProviderFactory() {
            return playProviderFactory;
        }

        private final AndroidSocketAdapter build(Class<? super SSLSocket> actualSSLSocketClass) {
            Class<? super SSLSocket> possibleClass = actualSSLSocketClass;
            while (possibleClass != null && !Intrinsics.areEqual(possibleClass.getSimpleName(), "OpenSSLSocketImpl")) {
                if ((possibleClass = possibleClass.getSuperclass()) == null) {
                    throw new AssertionError((Object)Intrinsics.stringPlus("No OpenSSLSocketImpl superclass of socket of type ", actualSSLSocketClass));
                }
            }
            Class<? super SSLSocket> clazz = possibleClass;
            Intrinsics.checkNotNull(clazz);
            return new AndroidSocketAdapter(clazz);
        }

        public final DeferredSocketAdapter.Factory factory(String packageName) {
            Intrinsics.checkNotNullParameter(packageName, "packageName");
            return new DeferredSocketAdapter.Factory(packageName){
                final /* synthetic */ String $packageName;
                {
                    this.$packageName = $packageName;
                }

                public boolean matchesSocket(SSLSocket sslSocket) {
                    Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
                    String string = sslSocket.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue(string, "sslSocket.javaClass.name");
                    return StringsKt.startsWith$default(string, Intrinsics.stringPlus(this.$packageName, "."), false, 2, null);
                }

                public SocketAdapter create(SSLSocket sslSocket) {
                    Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
                    return okhttp3.internal.platform.android.AndroidSocketAdapter$Companion.access$build(AndroidSocketAdapter.Companion, sslSocket.getClass());
                }
            };
        }

        public static final /* synthetic */ AndroidSocketAdapter access$build(Companion $this, Class actualSSLSocketClass) {
            return $this.build(actualSSLSocketClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

