/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;

public final class Headers
implements Iterable<Pair<? extends String, ? extends String>>,
KMappedMarker {
    public static final Companion Companion = new Companion(null);
    private final String[] namesAndValues;

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    public final String get(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Headers.Companion.get(this.namesAndValues, name);
    }

    public final int size() {
        return this.namesAndValues.length / 2;
    }

    public final String name(int index) {
        return this.namesAndValues[index * 2];
    }

    public final String value(int index) {
        return this.namesAndValues[index * 2 + 1];
    }

    public final List<String> values(String name) {
        List<String> list;
        Intrinsics.checkNotNullParameter(name, "name");
        List result2 = null;
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            int i;
            if (!StringsKt.equals(name, this.name(i = n++), true)) continue;
            if (result2 == null) {
                result2 = new ArrayList(2);
            }
            result2.add(this.value(i));
        }
        if (result2 != null) {
            List list2 = Collections.unmodifiableList(result2);
            Intrinsics.checkNotNullExpressionValue(list2, "{\n      Collections.unmodifiableList(result)\n    }");
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public Iterator<Pair<String, String>> iterator() {
        int n = 0;
        int n2 = this.size();
        Pair[] pairArray = new Pair[n2];
        while (n < n2) {
            int n3 = n++;
            pairArray[n3] = TuplesKt.to(this.name(n3), this.value(n3));
        }
        return ArrayIteratorKt.iterator(pairArray);
    }

    public final Builder newBuilder() {
        Builder result2 = new Builder();
        CollectionsKt.addAll((Collection)result2.getNamesAndValues$okhttp(), this.namesAndValues);
        return result2;
    }

    public boolean equals(Object other) {
        return other instanceof Headers && Arrays.equals(this.namesAndValues, ((Headers)other).namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            int i = n++;
            String name = this.name(i);
            String value = this.value(i);
            $this$toString_u24lambda_u2d0.append(name);
            $this$toString_u24lambda_u2d0.append(": ");
            $this$toString_u24lambda_u2d0.append(Util.isSensitiveHeader(name) ? "\u2588\u2588" : value);
            $this$toString_u24lambda_u2d0.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public /* synthetic */ Headers(String[] namesAndValues, DefaultConstructorMarker $constructor_marker) {
        this(namesAndValues);
    }

    public static final class Builder {
        private final List<String> namesAndValues = new ArrayList(20);

        public final List<String> getNamesAndValues$okhttp() {
            return this.namesAndValues;
        }

        public final Builder addLenient$okhttp(String line) {
            Builder builder;
            Intrinsics.checkNotNullParameter(line, "line");
            Builder $this$addLenient_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)line, ':', 1, false, 4, null);
            if (index != -1) {
                String string = line;
                int n = 0;
                String string2 = string.substring(n, index);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = line;
                n = index + 1;
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                $this$addLenient_u24lambda_u2d0.addLenient$okhttp(string2, string3);
            } else if (line.charAt(0) == ':') {
                String string = line;
                int n = 1;
                String string4 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
                $this$addLenient_u24lambda_u2d0.addLenient$okhttp("", string4);
            } else {
                $this$addLenient_u24lambda_u2d0.addLenient$okhttp("", line);
            }
            return builder;
        }

        public final Builder add(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$add_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            Companion.checkName(name);
            Companion.checkValue(value, name);
            $this$add_u24lambda_u2d3.addLenient$okhttp(name, value);
            return builder;
        }

        public final Builder addLenient$okhttp(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$addLenient_u24lambda_u2d10 = builder = this;
            boolean bl = false;
            $this$addLenient_u24lambda_u2d10.getNamesAndValues$okhttp().add(name);
            $this$addLenient_u24lambda_u2d10.getNamesAndValues$okhttp().add(((Object)StringsKt.trim(value)).toString());
            return builder;
        }

        public final Builder removeAll(String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Builder $this$removeAll_u24lambda_u2d11 = builder = this;
            boolean bl = false;
            for (int i = 0; i < $this$removeAll_u24lambda_u2d11.getNamesAndValues$okhttp().size(); i += 2) {
                if (!StringsKt.equals(name, $this$removeAll_u24lambda_u2d11.getNamesAndValues$okhttp().get(i), true)) continue;
                $this$removeAll_u24lambda_u2d11.getNamesAndValues$okhttp().remove(i);
                $this$removeAll_u24lambda_u2d11.getNamesAndValues$okhttp().remove(i);
                i -= 2;
            }
            return builder;
        }

        public final Builder set(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$set_u24lambda_u2d12 = builder = this;
            boolean bl = false;
            Companion.checkName(name);
            Companion.checkValue(value, name);
            $this$set_u24lambda_u2d12.removeAll(name);
            $this$set_u24lambda_u2d12.addLenient$okhttp(name, value);
            return builder;
        }

        public final String get(String name) {
            int n;
            Intrinsics.checkNotNullParameter(name, "name");
            int n2 = n = this.namesAndValues.size() - 2;
            int n3 = ProgressionUtilKt.getProgressionLastElement(n, 0, -2);
            if (n3 <= n2) {
                int i;
                do {
                    i = n2;
                    n2 -= 2;
                    if (!StringsKt.equals(name, this.namesAndValues.get(i), true)) continue;
                    return this.namesAndValues.get(i + 1);
                } while (i != n3);
            }
            return null;
        }

        public final Headers build() {
            Collection $this$toTypedArray$iv = this.namesAndValues;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return new Headers(stringArray, null);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        private final String get(String[] namesAndValues, String name) {
            int n;
            int n2 = n = namesAndValues.length - 2;
            int n3 = ProgressionUtilKt.getProgressionLastElement(n, 0, -2);
            if (n3 <= n2) {
                int i;
                do {
                    i = n2;
                    n2 -= 2;
                    if (!StringsKt.equals(name, namesAndValues[i], true)) continue;
                    return namesAndValues[i + 1];
                } while (i != n3);
            }
            return null;
        }

        public final Headers of(String ... namesAndValues) {
            Intrinsics.checkNotNullParameter(namesAndValues, "namesAndValues");
            if (!(namesAndValues.length % 2 == 0)) {
                boolean bl = false;
                String string = "Expected alternating header names and values";
                throw new IllegalArgumentException(string.toString());
            }
            String[] namesAndValues2 = (String[])namesAndValues.clone();
            int n = 0;
            int n2 = namesAndValues2.length;
            while (n < n2) {
                int i;
                if (!(namesAndValues2[i = n++] != null)) {
                    boolean $i$a$-require-Headers$Companion$headersOf$32 = false;
                    String $i$a$-require-Headers$Companion$headersOf$32 = "Headers cannot be null";
                    throw new IllegalArgumentException($i$a$-require-Headers$Companion$headersOf$32.toString());
                }
                namesAndValues2[i] = ((Object)StringsKt.trim(namesAndValues2[i])).toString();
            }
            n2 = 0;
            n = namesAndValues2.length + -1;
            int n3 = ProgressionUtilKt.getProgressionLastElement(0, n, 2);
            if (n2 <= n3) {
                int i;
                do {
                    i = n2;
                    n2 += 2;
                    String name = namesAndValues2[i];
                    String value = namesAndValues2[i + 1];
                    this.checkName(name);
                    this.checkValue(value, name);
                } while (i != n3);
            }
            return new Headers(namesAndValues2, null);
        }

        private final void checkName(String name) {
            if (!(((CharSequence)name).length() > 0)) {
                boolean bl = false;
                String string = "name is empty";
                throw new IllegalArgumentException(string.toString());
            }
            int n = 0;
            int n2 = name.length();
            while (n < n2) {
                int i;
                char c;
                if ('!' <= (c = name.charAt(i = n++)) ? c < '\u007f' : false) continue;
                boolean bl = false;
                Object[] objectArray = new Object[]{(int)c, i, name};
                String string = Util.format("Unexpected char %#04x at %d in header name: %s", objectArray);
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void checkValue(String value, String name) {
            int i;
            char c;
            boolean bl;
            int n = 0;
            int n2 = value.length();
            do {
                block6: {
                    block5: {
                        if (n >= n2) {
                            return;
                        }
                        if ((c = value.charAt(i = n++)) == '\t') break block5;
                        boolean bl2 = ' ' <= c ? c < '\u007f' : false;
                        if (!bl2) break block6;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
            } while (bl);
            boolean bl3 = false;
            Object[] objectArray = new Object[]{(int)c, i, name};
            String string = Intrinsics.stringPlus(Util.format("Unexpected char %#04x at %d in %s value", objectArray), Util.isSensitiveHeader(name) ? "" : Intrinsics.stringPlus(": ", value));
            throw new IllegalArgumentException(string.toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

