/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http.DatesKt;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class Cookie {
    public static final Companion Companion = new Companion(null);
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");

    private Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly) {
        this.name = name;
        this.value = value;
        this.expiresAt = expiresAt;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.persistent = persistent;
        this.hostOnly = hostOnly;
    }

    public final String name() {
        return this.name;
    }

    public final String value() {
        return this.value;
    }

    public final long expiresAt() {
        return this.expiresAt;
    }

    public final String domain() {
        return this.domain;
    }

    public final String path() {
        return this.path;
    }

    public final boolean secure() {
        return this.secure;
    }

    public final boolean httpOnly() {
        return this.httpOnly;
    }

    public final boolean persistent() {
        return this.persistent;
    }

    public final boolean hostOnly() {
        return this.hostOnly;
    }

    public boolean equals(Object other) {
        return other instanceof Cookie && Intrinsics.areEqual(((Cookie)other).name, this.name) && Intrinsics.areEqual(((Cookie)other).value, this.value) && ((Cookie)other).expiresAt == this.expiresAt && Intrinsics.areEqual(((Cookie)other).domain, this.domain) && Intrinsics.areEqual(((Cookie)other).path, this.path) && ((Cookie)other).secure == this.secure && ((Cookie)other).httpOnly == this.httpOnly && ((Cookie)other).persistent == this.persistent && ((Cookie)other).hostOnly == this.hostOnly;
    }

    @IgnoreJRERequirement
    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        result2 = 31 * result2 + Long.hashCode(this.expiresAt);
        result2 = 31 * result2 + this.domain.hashCode();
        result2 = 31 * result2 + this.path.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.secure);
        result2 = 31 * result2 + Boolean.hashCode(this.httpOnly);
        result2 = 31 * result2 + Boolean.hashCode(this.persistent);
        result2 = 31 * result2 + Boolean.hashCode(this.hostOnly);
        return result2;
    }

    public String toString() {
        return this.toString$okhttp(false);
    }

    public final String toString$okhttp(boolean forObsoleteRfc2965) {
        StringBuilder $this$toString_u24lambda_u2d0 = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d0.append(this.name());
        $this$toString_u24lambda_u2d0.append('=');
        $this$toString_u24lambda_u2d0.append(this.value());
        if (this.persistent()) {
            if (this.expiresAt() == Long.MIN_VALUE) {
                $this$toString_u24lambda_u2d0.append("; max-age=0");
            } else {
                $this$toString_u24lambda_u2d0.append("; expires=").append(DatesKt.toHttpDateString(new Date(this.expiresAt())));
            }
        }
        if (!this.hostOnly()) {
            $this$toString_u24lambda_u2d0.append("; domain=");
            if (forObsoleteRfc2965) {
                $this$toString_u24lambda_u2d0.append(".");
            }
            $this$toString_u24lambda_u2d0.append(this.domain());
        }
        $this$toString_u24lambda_u2d0.append("; path=").append(this.path());
        if (this.secure()) {
            $this$toString_u24lambda_u2d0.append("; secure");
        }
        if (this.httpOnly()) {
            $this$toString_u24lambda_u2d0.append("; httponly");
        }
        String string = $this$toString_u24lambda_u2d0.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString()");
        return string;
    }

    public /* synthetic */ Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly, DefaultConstructorMarker $constructor_marker) {
        this(name, value, expiresAt, domain, path, secure, httpOnly, persistent, hostOnly);
    }

    public static final class Companion {
        private Companion() {
        }

        private final boolean domainMatch(String urlHost, String domain) {
            if (Intrinsics.areEqual(urlHost, domain)) {
                return true;
            }
            return StringsKt.endsWith$default(urlHost, domain, false, 2, null) && urlHost.charAt(urlHost.length() - domain.length() - 1) == '.' && !Util.canParseAsIpAddress(urlHost);
        }

        public final Cookie parse(HttpUrl url, String setCookie) {
            Intrinsics.checkNotNullParameter(url, "url");
            Intrinsics.checkNotNullParameter(setCookie, "setCookie");
            return this.parse$okhttp(System.currentTimeMillis(), url, setCookie);
        }

        public final Cookie parse$okhttp(long currentTimeMillis, HttpUrl url, String setCookie) {
            long deltaMilliseconds;
            Intrinsics.checkNotNullParameter(url, "url");
            Intrinsics.checkNotNullParameter(setCookie, "setCookie");
            int cookiePairEnd = Util.delimiterOffset$default(setCookie, ';', 0, 0, 6, null);
            int pairEqualsSign = Util.delimiterOffset$default(setCookie, '=', 0, cookiePairEnd, 2, null);
            if (pairEqualsSign == cookiePairEnd) {
                return null;
            }
            String cookieName = Util.trimSubstring$default(setCookie, 0, pairEqualsSign, 1, null);
            if (((CharSequence)cookieName).length() == 0 || Util.indexOfControlOrNonAscii(cookieName) != -1) {
                return null;
            }
            String cookieValue = Util.trimSubstring(setCookie, pairEqualsSign + 1, cookiePairEnd);
            if (Util.indexOfControlOrNonAscii(cookieValue) != -1) {
                return null;
            }
            long expiresAt = 253402300799999L;
            long deltaSeconds = -1L;
            String domain = null;
            String path = null;
            boolean secureOnly = false;
            boolean httpOnly = false;
            boolean hostOnly = true;
            boolean persistent = false;
            int pos = cookiePairEnd + 1;
            int limit = setCookie.length();
            while (pos < limit) {
                int attributePairEnd = Util.delimiterOffset(setCookie, ';', pos, limit);
                int attributeEqualsSign = Util.delimiterOffset(setCookie, '=', pos, attributePairEnd);
                String attributeName = Util.trimSubstring(setCookie, pos, attributeEqualsSign);
                String attributeValue = attributeEqualsSign < attributePairEnd ? Util.trimSubstring(setCookie, attributeEqualsSign + 1, attributePairEnd) : "";
                if (StringsKt.equals(attributeName, "expires", true)) {
                    try {
                        expiresAt = this.parseExpires(attributeValue, 0, attributeValue.length());
                        persistent = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals(attributeName, "max-age", true)) {
                    try {
                        deltaSeconds = this.parseMaxAge(attributeValue);
                        persistent = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (StringsKt.equals(attributeName, "domain", true)) {
                    try {
                        domain = this.parseDomain(attributeValue);
                        hostOnly = false;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals(attributeName, "path", true)) {
                    path = attributeValue;
                } else if (StringsKt.equals(attributeName, "secure", true)) {
                    secureOnly = true;
                } else if (StringsKt.equals(attributeName, "httponly", true)) {
                    httpOnly = true;
                }
                pos = attributePairEnd + 1;
            }
            if (deltaSeconds == Long.MIN_VALUE) {
                expiresAt = Long.MIN_VALUE;
            } else if (deltaSeconds != -1L && ((expiresAt = currentTimeMillis + (deltaMilliseconds = deltaSeconds <= 9223372036854775L ? deltaSeconds * (long)1000 : Long.MAX_VALUE)) < currentTimeMillis || expiresAt > 253402300799999L)) {
                expiresAt = 253402300799999L;
            }
            String urlHost = url.host();
            if (domain == null) {
                domain = urlHost;
            } else if (!this.domainMatch(urlHost, domain)) {
                return null;
            }
            if (urlHost.length() != domain.length() && PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne(domain) == null) {
                return null;
            }
            if (path == null || !StringsKt.startsWith$default(path, "/", false, 2, null)) {
                String string;
                String encodedPath = url.encodedPath();
                int lastSlash = StringsKt.lastIndexOf$default((CharSequence)encodedPath, '/', 0, false, 6, null);
                if (lastSlash != 0) {
                    String string2 = encodedPath;
                    int n = 0;
                    String string3 = string2.substring(n, lastSlash);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string = "/";
                }
                path = string;
            }
            return new Cookie(cookieName, cookieValue, expiresAt, domain, path, secureOnly, httpOnly, persistent, hostOnly, null);
        }

        private final long parseExpires(String s, int pos, int limit) {
            String monthString;
            int pos2 = pos;
            pos2 = this.dateCharacterOffset(s, pos2, limit, false);
            int hour = 0;
            hour = -1;
            int minute = 0;
            minute = -1;
            int second = 0;
            second = -1;
            int dayOfMonth = 0;
            dayOfMonth = -1;
            int month = 0;
            month = -1;
            int year = 0;
            year = -1;
            Matcher matcher = TIME_PATTERN.matcher(s);
            while (pos2 < limit) {
                String string;
                int end = this.dateCharacterOffset(s, pos2 + 1, limit, true);
                matcher.region(pos2, end);
                if (hour == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                    string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue(string, "matcher.group(1)");
                    hour = Integer.parseInt(string);
                    string = matcher.group(2);
                    Intrinsics.checkNotNullExpressionValue(string, "matcher.group(2)");
                    minute = Integer.parseInt(string);
                    string = matcher.group(3);
                    Intrinsics.checkNotNullExpressionValue(string, "matcher.group(3)");
                    second = Integer.parseInt(string);
                } else if (dayOfMonth == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                    string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue(string, "matcher.group(1)");
                    dayOfMonth = Integer.parseInt(string);
                } else if (month == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                    String string2 = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue(string2, "matcher.group(1)");
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue(locale, "US");
                    Intrinsics.checkNotNullExpressionValue(string2.toLowerCase(locale), "this as java.lang.String).toLowerCase(locale)");
                    string2 = MONTH_PATTERN.pattern();
                    Intrinsics.checkNotNullExpressionValue(string2, "MONTH_PATTERN.pattern()");
                    month = StringsKt.indexOf$default((CharSequence)string2, monthString, 0, false, 6, null) / 4;
                } else if (year == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                    monthString = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue(monthString, "matcher.group(1)");
                    year = Integer.parseInt(monthString);
                }
                pos2 = this.dateCharacterOffset(s, end + 1, limit, false);
            }
            boolean bl = 70 <= year ? year < 100 : false;
            if (bl) {
                year += 1900;
            }
            boolean bl2 = 0 <= year ? year < 70 : false;
            if (bl2) {
                year += 2000;
            }
            if (!(year >= 1601)) {
                monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(month != -1)) {
                monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(1 <= dayOfMonth ? dayOfMonth < 32 : false)) {
                monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(0 <= hour ? hour < 24 : false)) {
                monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(0 <= minute ? minute < 60 : false)) {
                monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(0 <= second ? second < 60 : false)) {
                monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            GregorianCalendar $this$parseExpires_u24lambda_u2d0 = new GregorianCalendar(Util.UTC);
            boolean bl3 = false;
            $this$parseExpires_u24lambda_u2d0.setLenient(false);
            $this$parseExpires_u24lambda_u2d0.set(1, year);
            $this$parseExpires_u24lambda_u2d0.set(2, month - 1);
            $this$parseExpires_u24lambda_u2d0.set(5, dayOfMonth);
            $this$parseExpires_u24lambda_u2d0.set(11, hour);
            $this$parseExpires_u24lambda_u2d0.set(12, minute);
            $this$parseExpires_u24lambda_u2d0.set(13, second);
            $this$parseExpires_u24lambda_u2d0.set(14, 0);
            return $this$parseExpires_u24lambda_u2d0.getTimeInMillis();
        }

        /*
         * Enabled aggressive block sorting
         */
        private final int dateCharacterOffset(String input, int pos, int limit, boolean invert) {
            int i;
            boolean bl;
            boolean dateCharacter;
            int n = pos;
            do {
                block6: {
                    block5: {
                        char c;
                        if (n >= limit) {
                            return limit;
                        }
                        if ((c = input.charAt(i = n++)) < ' ' && c != '\t' || c >= '\u007f') break block5;
                        if (c <= '9' ? '0' <= c : false) break block5;
                        if (c <= 'z' ? 'a' <= c : false) break block5;
                        boolean bl2 = c <= 'Z' ? 'A' <= c : false;
                        if (!bl2 && c != ':') break block6;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
            } while ((dateCharacter = bl) != !invert);
            return i;
        }

        private final long parseMaxAge(String s) {
            try {
                long parsed = Long.parseLong(s);
                return parsed <= 0L ? Long.MIN_VALUE : parsed;
            }
            catch (NumberFormatException e) {
                CharSequence charSequence = s;
                if (new Regex("-?\\d+").matches(charSequence)) {
                    return StringsKt.startsWith$default(s, "-", false, 2, null) ? Long.MIN_VALUE : Long.MAX_VALUE;
                }
                throw e;
            }
        }

        private final String parseDomain(String s) {
            if (!(!StringsKt.endsWith$default(s, ".", false, 2, null))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            String string = HostnamesKt.toCanonicalHost(StringsKt.removePrefix(s, "."));
            if (string == null) {
                throw new IllegalArgumentException();
            }
            return string;
        }

        public final List<Cookie> parseAll(HttpUrl url, Headers headers) {
            List<Cookie> list;
            Intrinsics.checkNotNullParameter(url, "url");
            Intrinsics.checkNotNullParameter(headers, "headers");
            List<String> cookieStrings = headers.values("Set-Cookie");
            List cookies = null;
            int n = 0;
            int n2 = cookieStrings.size();
            while (n < n2) {
                Cookie cookie;
                int i;
                if (this.parse(url, cookieStrings.get(i = n++)) == null) continue;
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                cookies.add(cookie);
            }
            if (cookies != null) {
                List list2 = Collections.unmodifiableList(cookies);
                Intrinsics.checkNotNullExpressionValue(list2, "{\n        Collections.un\u2026ableList(cookies)\n      }");
                list = list2;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

