/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.internal.Util;

public final class CacheControl {
    public static final Companion Companion = new Companion(null);
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    private final boolean noTransform;
    private final boolean immutable;
    private String headerValue;
    public static final CacheControl FORCE_NETWORK = new Builder().noCache().build();
    public static final CacheControl FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();

    private CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue) {
        this.noCache = noCache;
        this.noStore = noStore;
        this.maxAgeSeconds = maxAgeSeconds;
        this.sMaxAgeSeconds = sMaxAgeSeconds;
        this.isPrivate = isPrivate;
        this.isPublic = isPublic;
        this.mustRevalidate = mustRevalidate;
        this.maxStaleSeconds = maxStaleSeconds;
        this.minFreshSeconds = minFreshSeconds;
        this.onlyIfCached = onlyIfCached;
        this.noTransform = noTransform;
        this.immutable = immutable;
        this.headerValue = headerValue;
    }

    public final boolean noCache() {
        return this.noCache;
    }

    public final boolean noStore() {
        return this.noStore;
    }

    public final int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public final int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    public final boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public final int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public final int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public final boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public final boolean noTransform() {
        return this.noTransform;
    }

    public final boolean immutable() {
        return this.immutable;
    }

    public String toString() {
        String result2 = this.headerValue;
        if (result2 == null) {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.noCache()) {
                $this$toString_u24lambda_u2d0.append("no-cache, ");
            }
            if (this.noStore()) {
                $this$toString_u24lambda_u2d0.append("no-store, ");
            }
            if (this.maxAgeSeconds() != -1) {
                $this$toString_u24lambda_u2d0.append("max-age=").append(this.maxAgeSeconds()).append(", ");
            }
            if (this.sMaxAgeSeconds() != -1) {
                $this$toString_u24lambda_u2d0.append("s-maxage=").append(this.sMaxAgeSeconds()).append(", ");
            }
            if (this.isPrivate()) {
                $this$toString_u24lambda_u2d0.append("private, ");
            }
            if (this.isPublic()) {
                $this$toString_u24lambda_u2d0.append("public, ");
            }
            if (this.mustRevalidate()) {
                $this$toString_u24lambda_u2d0.append("must-revalidate, ");
            }
            if (this.maxStaleSeconds() != -1) {
                $this$toString_u24lambda_u2d0.append("max-stale=").append(this.maxStaleSeconds()).append(", ");
            }
            if (this.minFreshSeconds() != -1) {
                $this$toString_u24lambda_u2d0.append("min-fresh=").append(this.minFreshSeconds()).append(", ");
            }
            if (this.onlyIfCached()) {
                $this$toString_u24lambda_u2d0.append("only-if-cached, ");
            }
            if (this.noTransform()) {
                $this$toString_u24lambda_u2d0.append("no-transform, ");
            }
            if (this.immutable()) {
                $this$toString_u24lambda_u2d0.append("immutable, ");
            }
            if (((CharSequence)$this$toString_u24lambda_u2d0).length() == 0) {
                return "";
            }
            $this$toString_u24lambda_u2d0.delete($this$toString_u24lambda_u2d0.length() - 2, $this$toString_u24lambda_u2d0.length());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            this.headerValue = result2 = string;
        }
        return result2;
    }

    public /* synthetic */ CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue, DefaultConstructorMarker $constructor_marker) {
        this(noCache, noStore, maxAgeSeconds, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue);
    }

    public static final class Builder {
        private boolean noCache;
        private boolean noStore;
        private int maxAgeSeconds = -1;
        private int maxStaleSeconds = -1;
        private int minFreshSeconds = -1;
        private boolean onlyIfCached;
        private boolean noTransform;
        private boolean immutable;

        public final Builder noCache() {
            Builder builder;
            Builder $this$noCache_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$noCache_u24lambda_u2d0.noCache = true;
            return builder;
        }

        public final Builder maxStale(int maxStale, TimeUnit timeUnit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
            Builder $this$maxStale_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            if (!(maxStale >= 0)) {
                boolean bl2 = false;
                String string = Intrinsics.stringPlus("maxStale < 0: ", maxStale);
                throw new IllegalArgumentException(string.toString());
            }
            long maxStaleSecondsLong = timeUnit.toSeconds(maxStale);
            $this$maxStale_u24lambda_u2d5.maxStaleSeconds = $this$maxStale_u24lambda_u2d5.clampToInt(maxStaleSecondsLong);
            return builder;
        }

        public final Builder onlyIfCached() {
            Builder builder;
            Builder $this$onlyIfCached_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$onlyIfCached_u24lambda_u2d8.onlyIfCached = true;
            return builder;
        }

        private final int clampToInt(long $this$clampToInt) {
            return $this$clampToInt > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)$this$clampToInt;
        }

        public final CacheControl build() {
            return new CacheControl(this.noCache, this.noStore, this.maxAgeSeconds, -1, false, false, false, this.maxStaleSeconds, this.minFreshSeconds, this.onlyIfCached, this.noTransform, this.immutable, null, null);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final CacheControl parse(Headers headers) {
            Intrinsics.checkNotNullParameter(headers, "headers");
            boolean noCache = false;
            boolean noStore = false;
            int maxAgeSeconds = -1;
            int sMaxAgeSeconds = -1;
            boolean isPrivate = false;
            boolean isPublic = false;
            boolean mustRevalidate = false;
            int maxStaleSeconds = -1;
            int minFreshSeconds = -1;
            boolean onlyIfCached = false;
            boolean noTransform = false;
            boolean immutable = false;
            boolean canUseHeaderValue = true;
            String headerValue = null;
            int n = 0;
            int n2 = headers.size();
            while (n < n2) {
                int i = n++;
                String name = headers.name(i);
                String value = headers.value(i);
                if (StringsKt.equals(name, "Cache-Control", true)) {
                    if (headerValue != null) {
                        canUseHeaderValue = false;
                    } else {
                        headerValue = value;
                    }
                } else {
                    if (!StringsKt.equals(name, "Pragma", true)) continue;
                    canUseHeaderValue = false;
                }
                int pos = 0;
                while (pos < value.length()) {
                    int n3;
                    int tokenStart = pos;
                    pos = this.indexOfElement(value, "=,;", pos);
                    String string = value.substring(tokenStart, pos);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String directive = ((Object)StringsKt.trim(string)).toString();
                    String parameter = null;
                    if (pos == value.length() || value.charAt(pos) == ',' || value.charAt(pos) == ';') {
                        n3 = pos;
                        pos = n3 + 1;
                        parameter = null;
                    } else {
                        int parameterStart;
                        n3 = pos;
                        pos = n3 + 1;
                        if ((pos = Util.indexOfNonWhitespace(value, pos)) < value.length() && value.charAt(pos) == '\"') {
                            n3 = pos;
                            parameterStart = pos = n3 + 1;
                            pos = StringsKt.indexOf$default((CharSequence)value, '\"', pos, false, 4, null);
                            String string2 = value.substring(parameterStart, pos);
                            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                            parameter = string2;
                            int n4 = pos;
                            pos = n4 + 1;
                        } else {
                            parameterStart = pos;
                            pos = this.indexOfElement(value, ",;", pos);
                            String string3 = value.substring(parameterStart, pos);
                            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                            parameter = ((Object)StringsKt.trim(string3)).toString();
                        }
                    }
                    if (StringsKt.equals("no-cache", directive, true)) {
                        noCache = true;
                        continue;
                    }
                    if (StringsKt.equals("no-store", directive, true)) {
                        noStore = true;
                        continue;
                    }
                    if (StringsKt.equals("max-age", directive, true)) {
                        maxAgeSeconds = Util.toNonNegativeInt(parameter, -1);
                        continue;
                    }
                    if (StringsKt.equals("s-maxage", directive, true)) {
                        sMaxAgeSeconds = Util.toNonNegativeInt(parameter, -1);
                        continue;
                    }
                    if (StringsKt.equals("private", directive, true)) {
                        isPrivate = true;
                        continue;
                    }
                    if (StringsKt.equals("public", directive, true)) {
                        isPublic = true;
                        continue;
                    }
                    if (StringsKt.equals("must-revalidate", directive, true)) {
                        mustRevalidate = true;
                        continue;
                    }
                    if (StringsKt.equals("max-stale", directive, true)) {
                        maxStaleSeconds = Util.toNonNegativeInt(parameter, Integer.MAX_VALUE);
                        continue;
                    }
                    if (StringsKt.equals("min-fresh", directive, true)) {
                        minFreshSeconds = Util.toNonNegativeInt(parameter, -1);
                        continue;
                    }
                    if (StringsKt.equals("only-if-cached", directive, true)) {
                        onlyIfCached = true;
                        continue;
                    }
                    if (StringsKt.equals("no-transform", directive, true)) {
                        noTransform = true;
                        continue;
                    }
                    if (!StringsKt.equals("immutable", directive, true)) continue;
                    immutable = true;
                }
            }
            if (!canUseHeaderValue) {
                headerValue = null;
            }
            return new CacheControl(noCache, noStore, maxAgeSeconds, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue, null);
        }

        private final int indexOfElement(String $this$indexOfElement, String characters, int startIndex) {
            int n = startIndex;
            int n2 = $this$indexOfElement.length();
            while (n < n2) {
                int i;
                if (!StringsKt.contains$default((CharSequence)characters, $this$indexOfElement.charAt(i = n++), false, 2, null)) continue;
                return i;
            }
            return $this$indexOfElement.length();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

