/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonNames;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.DescriptorSchemaCache;
import kotlinx.serialization.json.internal.JsonException;

public final class JsonNamesMapKt {
    private static final DescriptorSchemaCache.Key<Map<String, Integer>> JsonDeserializationNamesKey = new DescriptorSchemaCache.Key();
    private static final DescriptorSchemaCache.Key<String[]> JsonSerializationNamesKey = new DescriptorSchemaCache.Key();

    public static final DescriptorSchemaCache.Key<Map<String, Integer>> getJsonDeserializationNamesKey() {
        return JsonDeserializationNamesKey;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Integer> buildDeserializationNamesMap(SerialDescriptor $this$buildDeserializationNamesMap, Json json) {
        Map<String, Integer> map2;
        Map<String, Integer> builder = new LinkedHashMap();
        boolean useLowercaseEnums = JsonNamesMapKt.decodeCaseInsensitive(json, $this$buildDeserializationNamesMap);
        JsonNamingStrategy strategyForClasses = JsonNamesMapKt.namingStrategy($this$buildDeserializationNamesMap, json);
        int n = $this$buildDeserializationNamesMap.getElementsCount();
        for (int i = 0; i < n; ++i) {
            String it;
            String nameToPut;
            String string;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = $this$buildDeserializationNamesMap.getElementAnnotations(i);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JsonNames)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String[] stringArray = (String[])CollectionsKt.singleOrNull((List)destination$iv$iv);
            if (stringArray != null && (stringArray = stringArray.names()) != null) {
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (int j = 0; j < n2; ++j) {
                    String string2;
                    String element$iv;
                    String name = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    if (useLowercaseEnums) {
                        String string3 = name.toLowerCase(Locale.ROOT);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                    } else {
                        string2 = name;
                    }
                    JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(builder, $this$buildDeserializationNamesMap, string2, i);
                }
            }
            if (useLowercaseEnums) {
                String string4 = $this$buildDeserializationNamesMap.getElementName(i).toLowerCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            } else {
                JsonNamingStrategy jsonNamingStrategy = strategyForClasses;
                string = nameToPut = jsonNamingStrategy != null ? jsonNamingStrategy.serialNameForJson($this$buildDeserializationNamesMap, i, $this$buildDeserializationNamesMap.getElementName(i)) : null;
            }
            if (nameToPut == null) continue;
            boolean bl = false;
            JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(builder, $this$buildDeserializationNamesMap, it, i);
        }
        Map<String, Integer> map3 = builder;
        if (map3.isEmpty()) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        } else {
            map2 = map3;
        }
        return map2;
    }

    public static final Map<String, Integer> deserializationNamesMap(Json $this$deserializationNamesMap, SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter($this$deserializationNamesMap, "<this>");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return JsonSchemaCacheKt.getSchemaCache($this$deserializationNamesMap).getOrPut(descriptor, JsonDeserializationNamesKey, () -> JsonNamesMapKt.deserializationNamesMap$lambda$3(descriptor, $this$deserializationNamesMap));
    }

    public static final String[] serializationNamesIndices(SerialDescriptor $this$serializationNamesIndices, Json json, JsonNamingStrategy strategy) {
        Intrinsics.checkNotNullParameter($this$serializationNamesIndices, "<this>");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        return JsonSchemaCacheKt.getSchemaCache(json).getOrPut($this$serializationNamesIndices, JsonSerializationNamesKey, () -> JsonNamesMapKt.serializationNamesIndices$lambda$4($this$serializationNamesIndices, strategy));
    }

    public static final String getJsonElementName(SerialDescriptor $this$getJsonElementName, Json json, int index) {
        Intrinsics.checkNotNullParameter($this$getJsonElementName, "<this>");
        Intrinsics.checkNotNullParameter(json, "json");
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy($this$getJsonElementName, json);
        return strategy == null ? $this$getJsonElementName.getElementName(index) : JsonNamesMapKt.serializationNamesIndices($this$getJsonElementName, json, strategy)[index];
    }

    public static final JsonNamingStrategy namingStrategy(SerialDescriptor $this$namingStrategy, Json json) {
        Intrinsics.checkNotNullParameter($this$namingStrategy, "<this>");
        Intrinsics.checkNotNullParameter(json, "json");
        return Intrinsics.areEqual($this$namingStrategy.getKind(), StructureKind.CLASS.INSTANCE) ? json.getConfiguration().getNamingStrategy() : null;
    }

    private static final int getJsonNameIndexSlowPath(SerialDescriptor $this$getJsonNameIndexSlowPath, Json json, String name) {
        Integer n = JsonNamesMapKt.deserializationNamesMap(json, $this$getJsonNameIndexSlowPath).get(name);
        return n != null ? n : -3;
    }

    private static final boolean decodeCaseInsensitive(Json $this$decodeCaseInsensitive, SerialDescriptor descriptor) {
        return $this$decodeCaseInsensitive.getConfiguration().getDecodeEnumsCaseInsensitive() && Intrinsics.areEqual(descriptor.getKind(), SerialKind.ENUM.INSTANCE);
    }

    public static final int getJsonNameIndex(SerialDescriptor $this$getJsonNameIndex, Json json, String name) {
        Intrinsics.checkNotNullParameter($this$getJsonNameIndex, "<this>");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(name, "name");
        if (JsonNamesMapKt.decodeCaseInsensitive(json, $this$getJsonNameIndex)) {
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            return JsonNamesMapKt.getJsonNameIndexSlowPath($this$getJsonNameIndex, json, string);
        }
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy($this$getJsonNameIndex, json);
        if (strategy != null) {
            return JsonNamesMapKt.getJsonNameIndexSlowPath($this$getJsonNameIndex, json, name);
        }
        int index = $this$getJsonNameIndex.getElementIndex(name);
        if (index != -3) {
            return index;
        }
        if (!json.getConfiguration().getUseAlternativeNames()) {
            return index;
        }
        return JsonNamesMapKt.getJsonNameIndexSlowPath($this$getJsonNameIndex, json, name);
    }

    private static final void buildDeserializationNamesMap$putOrThrow(Map<String, Integer> $this$buildDeserializationNamesMap_u24putOrThrow, SerialDescriptor $this_buildDeserializationNamesMap, String name, int index) {
        String entity;
        String string = entity = Intrinsics.areEqual($this_buildDeserializationNamesMap.getKind(), SerialKind.ENUM.INSTANCE) ? "enum value" : "property";
        if ($this$buildDeserializationNamesMap_u24putOrThrow.containsKey(name)) {
            throw new JsonException("The suggested name '" + name + "' for " + entity + ' ' + $this_buildDeserializationNamesMap.getElementName(index) + " is already one of the names for " + entity + ' ' + $this_buildDeserializationNamesMap.getElementName(((Number)MapsKt.getValue($this$buildDeserializationNamesMap_u24putOrThrow, name)).intValue()) + " in " + $this_buildDeserializationNamesMap);
        }
        Integer n = index;
        $this$buildDeserializationNamesMap_u24putOrThrow.put(name, n);
    }

    private static final Map deserializationNamesMap$lambda$3(SerialDescriptor $descriptor, Json $this_deserializationNamesMap) {
        return JsonNamesMapKt.buildDeserializationNamesMap($descriptor, $this_deserializationNamesMap);
    }

    private static final String[] serializationNamesIndices$lambda$4(SerialDescriptor $this_serializationNamesIndices, JsonNamingStrategy $strategy) {
        int n = 0;
        int n2 = $this_serializationNamesIndices.getElementsCount();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            String baseName = $this_serializationNamesIndices.getElementName(n3);
            stringArray[n3] = $strategy.serialNameForJson($this_serializationNamesIndices, n3, baseName);
        }
        return stringArray;
    }
}

