/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObjectSerializer;
import kotlinx.serialization.json.internal.StringOpsKt;

public final class JsonObject
extends JsonElement
implements Map<String, JsonElement>,
KMappedMarker {
    public static final Companion Companion = new Companion(null);
    private final Map<String, JsonElement> content;

    public JsonObject(Map<String, ? extends JsonElement> content) {
        Intrinsics.checkNotNullParameter(content, "content");
        super(null);
        this.content = content;
    }

    @Override
    public boolean equals(Object other) {
        return Intrinsics.areEqual(this.content, other);
    }

    @Override
    public int hashCode() {
        return ((Object)this.content).hashCode();
    }

    public String toString() {
        return CollectionsKt.joinToString$default(this.content.entrySet(), ",", "{", "}", 0, null, JsonObject::toString$lambda$1, 24, null);
    }

    public boolean containsKey(String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.content.containsKey(key);
    }

    public boolean containsValue(JsonElement value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return this.content.containsValue(value);
    }

    public JsonElement get(String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.content.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public Set<Map.Entry<String, JsonElement>> getEntries() {
        return this.content.entrySet();
    }

    public Set<String> getKeys() {
        return this.content.keySet();
    }

    public int getSize() {
        return this.content.size();
    }

    public Collection<JsonElement> getValues() {
        return this.content.values();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonElement> from) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement remove(Object key) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super JsonElement, ? extends JsonElement> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    private static final CharSequence toString$lambda$1(Map.Entry entry) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        String k = (String)entry.getKey();
        JsonElement v = (JsonElement)entry.getValue();
        StringBuilder $this$toString_u24lambda_u241_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringOpsKt.printQuoted($this$toString_u24lambda_u241_u24lambda_u240, k);
        $this$toString_u24lambda_u241_u24lambda_u240.append(':');
        $this$toString_u24lambda_u241_u24lambda_u240.append(v);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public final KSerializer<JsonObject> serializer() {
            return JsonObjectSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

