/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializersKt;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.internal.JsonExceptionsKt;

final class JsonLiteralSerializer
implements KSerializer<JsonLiteral> {
    public static final JsonLiteralSerializer INSTANCE = new JsonLiteralSerializer();
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("kotlinx.serialization.json.JsonLiteral", PrimitiveKind.STRING.INSTANCE);

    private JsonLiteralSerializer() {
    }

    @Override
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(Encoder encoder, JsonLiteral value) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        JsonElementSerializersKt.access$verify(encoder);
        if (value.isString()) {
            encoder.encodeString(value.getContent());
            return;
        }
        if (value.getCoerceToInlineType$kotlinx_serialization_json() != null) {
            encoder.encodeInline(value.getCoerceToInlineType$kotlinx_serialization_json()).encodeString(value.getContent());
            return;
        }
        Comparable<Long> comparable = StringsKt.toLongOrNull(value.getContent());
        if (comparable != null) {
            long it = ((Number)((Object)comparable)).longValue();
            boolean bl = false;
            encoder.encodeLong(it);
            return;
        }
        comparable = UStringsKt.toULongOrNull(value.getContent());
        if (comparable != null) {
            long it = ((ULong)comparable).unbox-impl();
            boolean bl = false;
            encoder.encodeInline(BuiltinSerializersKt.serializer(ULong.Companion).getDescriptor()).encodeLong(it);
            return;
        }
        comparable = StringsKt.toDoubleOrNull(value.getContent());
        if (comparable != null) {
            double it = ((Number)((Object)comparable)).doubleValue();
            boolean bl = false;
            encoder.encodeDouble(it);
            return;
        }
        comparable = StringsKt.toBooleanStrictOrNull(value.getContent());
        if (comparable != null) {
            boolean it = (Boolean)comparable;
            boolean bl = false;
            encoder.encodeBoolean(it);
            return;
        }
        encoder.encodeString(value.getContent());
    }

    @Override
    public JsonLiteral deserialize(Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        JsonElement result2 = JsonElementSerializersKt.asJsonDecoder(decoder).decodeJsonElement();
        if (!(result2 instanceof JsonLiteral)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Unexpected JSON element, expected JsonLiteral, had " + Reflection.getOrCreateKotlinClass(result2.getClass()), result2.toString());
        }
        return (JsonLiteral)result2;
    }
}

