/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ThreadContextElement;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.internal.ThreadContextKt;
import kotlinx.coroutines.internal.ThreadState;

public final class ThreadContextKt {
    public static final Symbol NO_THREAD_ELEMENTS = new Symbol("NO_THREAD_ELEMENTS");
    private static final Function2<Object, CoroutineContext.Element, Object> countAll = countAll.1.INSTANCE;
    private static final Function2<ThreadContextElement<?>, CoroutineContext.Element, ThreadContextElement<?>> findOne = findOne.1.INSTANCE;
    private static final Function2<ThreadState, CoroutineContext.Element, ThreadState> updateState = updateState.1.INSTANCE;

    public static final Object threadContextElements(CoroutineContext context) {
        Object object = context.fold(0, countAll);
        Intrinsics.checkNotNull(object);
        return object;
    }

    public static final Object updateThreadContext(CoroutineContext context, Object countOrElement) {
        Object object;
        Object object2 = countOrElement;
        if (object2 == null) {
            object2 = ThreadContextKt.threadContextElements(context);
        }
        Object countOrElement2 = object2;
        if (countOrElement2 == Integer.valueOf(0)) {
            object = NO_THREAD_ELEMENTS;
        } else if (countOrElement2 instanceof Integer) {
            object = context.fold(new ThreadState(context, ((Number)countOrElement2).intValue()), updateState);
        } else {
            Intrinsics.checkNotNull(countOrElement2, "null cannot be cast to non-null type kotlinx.coroutines.ThreadContextElement<kotlin.Any?>");
            ThreadContextElement element = (ThreadContextElement)countOrElement2;
            object = element.updateThreadContext(context);
        }
        return object;
    }

    public static final void restoreThreadContext(CoroutineContext context, Object oldState) {
        if (oldState == NO_THREAD_ELEMENTS) {
            return;
        }
        if (oldState instanceof ThreadState) {
            ((ThreadState)oldState).restore(context);
        } else {
            ThreadContextElement<?> threadContextElement = context.fold(null, findOne);
            Intrinsics.checkNotNull(threadContextElement, "null cannot be cast to non-null type kotlinx.coroutines.ThreadContextElement<kotlin.Any?>");
            ThreadContextElement<?> element = threadContextElement;
            element.restoreThreadContext(context, oldState);
        }
    }
}

