/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.AbstractTimeSource;
import kotlinx.coroutines.AbstractTimeSourceKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.DefaultExecutor;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.DisposableFutureHandle;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.ResumeUndispatchedRunnable;
import kotlinx.coroutines.internal.ConcurrentKt;

public final class ExecutorCoroutineDispatcherImpl
extends ExecutorCoroutineDispatcher
implements Delay {
    private final Executor executor;

    public ExecutorCoroutineDispatcherImpl(Executor executor) {
        this.executor = executor;
        ConcurrentKt.removeFutureOnCancel(this.getExecutor());
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void dispatch(CoroutineContext context, Runnable block) {
        try {
            Executor executor = this.getExecutor();
            Object object = AbstractTimeSourceKt.access$getTimeSource$p();
            if (object == null || (object = ((AbstractTimeSource)object).wrapTask(block)) == null) {
                object = block;
            }
            executor.execute((Runnable)object);
        }
        catch (RejectedExecutionException e) {
            AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
            if (abstractTimeSource != null) {
                abstractTimeSource.unTrackTask();
            }
            this.cancelJobOnRejection(context, e);
            Dispatchers.getIO().dispatch(context, block);
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long timeMillis, CancellableContinuation<? super Unit> continuation) {
        ScheduledFuture<?> future;
        Executor executor = this.getExecutor();
        ScheduledExecutorService scheduledExecutorService = executor instanceof ScheduledExecutorService ? (ScheduledExecutorService)executor : null;
        ScheduledFuture<?> scheduledFuture = future = scheduledExecutorService != null ? this.scheduleBlock(scheduledExecutorService, new ResumeUndispatchedRunnable(this, continuation), continuation.getContext(), timeMillis) : null;
        if (future != null) {
            JobKt.cancelFutureOnCancellation(continuation, (Future)future);
            return;
        }
        DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(timeMillis, continuation);
    }

    @Override
    public DisposableHandle invokeOnTimeout(long timeMillis, Runnable block, CoroutineContext context) {
        Executor executor = this.getExecutor();
        ScheduledExecutorService scheduledExecutorService = executor instanceof ScheduledExecutorService ? (ScheduledExecutorService)executor : null;
        ScheduledFuture<?> future = scheduledExecutorService != null ? this.scheduleBlock(scheduledExecutorService, block, context, timeMillis) : null;
        return future != null ? (DisposableHandle)new DisposableFutureHandle((Future)future) : DefaultExecutor.INSTANCE.invokeOnTimeout(timeMillis, block, context);
    }

    private final ScheduledFuture<?> scheduleBlock(ScheduledExecutorService $this$scheduleBlock, Runnable block, CoroutineContext context, long timeMillis) {
        ScheduledFuture<?> scheduledFuture;
        try {
            scheduledFuture = $this$scheduleBlock.schedule(block, timeMillis, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.cancelJobOnRejection(context, e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    private final void cancelJobOnRejection(CoroutineContext context, RejectedExecutionException exception) {
        JobKt.cancel(context, ExceptionsKt.CancellationException("The task was rejected", exception));
    }

    @Override
    public void close() {
        block0: {
            Executor executor = this.getExecutor();
            ExecutorService executorService = executor instanceof ExecutorService ? (ExecutorService)executor : null;
            if (executorService == null) break block0;
            executorService.shutdown();
        }
    }

    @Override
    public String toString() {
        return this.getExecutor().toString();
    }

    public boolean equals(Object other) {
        return other instanceof ExecutorCoroutineDispatcherImpl && ((ExecutorCoroutineDispatcherImpl)other).getExecutor() == this.getExecutor();
    }

    public int hashCode() {
        return System.identityHashCode(this.getExecutor());
    }
}

