/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.AbstractTimeSource;
import kotlinx.coroutines.AbstractTimeSourceKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.DefaultExecutor;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.EventLoopImplPlatform;
import kotlinx.coroutines.EventLoop_commonKt;
import kotlinx.coroutines.NonDisposableHandle;
import kotlinx.coroutines.ThreadLocalEventLoop;
import kotlinx.coroutines.internal.LockFreeTaskQueueCore;
import kotlinx.coroutines.internal.ThreadSafeHeap;
import kotlinx.coroutines.internal.ThreadSafeHeapNode;

public abstract class EventLoopImplBase
extends EventLoopImplPlatform
implements Delay {
    private volatile /* synthetic */ Object _queue$volatile;
    private volatile /* synthetic */ Object _delayed$volatile;
    private volatile /* synthetic */ int _isCompleted$volatile;
    private static final /* synthetic */ AtomicReferenceFieldUpdater _queue$volatile$FU;
    private static final /* synthetic */ AtomicReferenceFieldUpdater _delayed$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater _isCompleted$volatile$FU;

    public EventLoopImplBase() {
        this._isCompleted$volatile = 0;
    }

    private final boolean isCompleted() {
        return EventLoopImplBase._isCompleted$volatile$FU.get(this) != 0;
    }

    private final void setCompleted(boolean value) {
        EventLoopImplBase._isCompleted$volatile$FU.set(this, value ? 1 : 0);
    }

    @Override
    protected boolean isEmpty() {
        if (!this.isUnconfinedQueueEmpty()) {
            return false;
        }
        DelayedTaskQueue delayed = (DelayedTaskQueue)EventLoopImplBase._delayed$volatile$FU.get(this);
        if (delayed != null && !delayed.isEmpty()) {
            return false;
        }
        Object queue = EventLoopImplBase._queue$volatile$FU.get(this);
        return queue == null ? true : (queue instanceof LockFreeTaskQueueCore ? ((LockFreeTaskQueueCore)queue).isEmpty() : queue == EventLoop_commonKt.access$getCLOSED_EMPTY$p());
    }

    @Override
    protected long getNextTime() {
        Object object;
        if (super.getNextTime() == 0L) {
            return 0L;
        }
        Object queue = EventLoopImplBase._queue$volatile$FU.get(this);
        if (queue != null) {
            if (queue instanceof LockFreeTaskQueueCore) {
                if (!((LockFreeTaskQueueCore)queue).isEmpty()) {
                    return 0L;
                }
            } else {
                if (queue == EventLoop_commonKt.access$getCLOSED_EMPTY$p()) {
                    return Long.MAX_VALUE;
                }
                return 0L;
            }
        }
        if ((object = (DelayedTaskQueue)EventLoopImplBase._delayed$volatile$FU.get(this)) == null || (object = (DelayedTask)((ThreadSafeHeap)object).peek()) == null) {
            return Long.MAX_VALUE;
        }
        Object nextDelayedTask = object;
        AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
        return RangesKt.coerceAtLeast(((DelayedTask)nextDelayedTask).nanoTime - (abstractTimeSource != null ? abstractTimeSource.nanoTime() : System.nanoTime()), 0L);
    }

    @Override
    public void shutdown() {
        ThreadLocalEventLoop.INSTANCE.resetEventLoop$kotlinx_coroutines_core();
        this.setCompleted(true);
        this.closeQueue();
        while (this.processNextEvent() <= 0L) {
        }
        this.rescheduleAllDelayed();
    }

    @Override
    public void scheduleResumeAfterDelay(long timeMillis, CancellableContinuation<? super Unit> continuation) {
        long timeNanos = EventLoop_commonKt.delayToNanos(timeMillis);
        if (timeNanos < 0x3FFFFFFFFFFFFFFFL) {
            DelayedResumeTask delayedResumeTask;
            AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
            long now = abstractTimeSource != null ? abstractTimeSource.nanoTime() : System.nanoTime();
            DelayedResumeTask task = delayedResumeTask = new DelayedResumeTask(now + timeNanos, continuation);
            boolean bl = false;
            this.schedule(now, task);
            CancellableContinuationKt.disposeOnCancellation(continuation, task);
        }
    }

    protected final DisposableHandle scheduleInvokeOnTimeout(long timeMillis, Runnable block) {
        DisposableHandle disposableHandle;
        long timeNanos = EventLoop_commonKt.delayToNanos(timeMillis);
        if (timeNanos < 0x3FFFFFFFFFFFFFFFL) {
            DelayedRunnableTask delayedRunnableTask;
            AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
            long now = abstractTimeSource != null ? abstractTimeSource.nanoTime() : System.nanoTime();
            DelayedRunnableTask task = delayedRunnableTask = new DelayedRunnableTask(now + timeNanos, block);
            boolean bl = false;
            this.schedule(now, task);
            disposableHandle = delayedRunnableTask;
        } else {
            disposableHandle = NonDisposableHandle.INSTANCE;
        }
        return disposableHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long processNextEvent() {
        Runnable task;
        if (this.processUnconfinedEvent()) {
            return 0L;
        }
        DelayedTaskQueue delayed = (DelayedTaskQueue)EventLoopImplBase._delayed$volatile$FU.get(this);
        if (delayed != null && !delayed.isEmpty()) {
            AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
            long now = abstractTimeSource != null ? abstractTimeSource.nanoTime() : System.nanoTime();
            while (true) {
                Object v1;
                ThreadSafeHeap this_$iv = delayed;
                boolean $i$f$removeFirstIf = false;
                boolean $i$f$synchronized = false;
                boolean $i$f$synchronizedImpl = false;
                ThreadSafeHeap threadSafeHeap = this_$iv;
                synchronized (threadSafeHeap) {
                    Object t;
                    block8: {
                        boolean bl = false;
                        if (this_$iv.firstImpl() != null) break block8;
                        Object var11_10 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var9_8
                        v1 = var11_10;
                    }
                    Object first$iv = t;
                    DelayedTask it = (DelayedTask)first$iv;
                    boolean bl = false;
                    Object var15_14 = (it.timeToExecute(now) ? this.enqueueImpl(it) : false) ? this_$iv.removeAtImpl(0) : null;
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 4, 7] lbl29 : MonitorExitStatement: MONITOREXIT : var9_8
                    v1 = var15_14;
                }
                if ((DelayedTask)v1 == null) break;
            }
        }
        if ((task = this.dequeue()) != null) {
            boolean $i$f$platformAutoreleasePool = false;
            boolean bl = false;
            task.run();
            return 0L;
        }
        return this.getNextTime();
    }

    @Override
    public final void dispatch(CoroutineContext context, Runnable block) {
        this.enqueue(block);
    }

    public void enqueue(Runnable task) {
        if (this.enqueueImpl(task)) {
            this.unpark();
        } else {
            DefaultExecutor.INSTANCE.enqueue(task);
        }
    }

    private final boolean enqueueImpl(Runnable task) {
        EventLoopImplBase eventLoopImplBase = this;
        AtomicReferenceFieldUpdater handler$atomicfu$iv = EventLoopImplBase._queue$volatile$FU;
        while (true) {
            Object queue = handler$atomicfu$iv.get(this);
            boolean bl = false;
            if (this.isCompleted()) {
                return false;
            }
            Object v = queue;
            if (v == null) {
                if (!EventLoopImplBase._queue$volatile$FU.compareAndSet(this, null, task)) continue;
                return true;
            }
            if (v instanceof LockFreeTaskQueueCore) {
                Intrinsics.checkNotNull(queue, "null cannot be cast to non-null type kotlinx.coroutines.internal.LockFreeTaskQueueCore<java.lang.Runnable{ kotlinx.coroutines.RunnableKt.Runnable }>{ kotlinx.coroutines.EventLoop_commonKt.Queue<java.lang.Runnable{ kotlinx.coroutines.RunnableKt.Runnable }> }");
                switch (((LockFreeTaskQueueCore)queue).addLast(task)) {
                    case 0: {
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                    case 1: {
                        EventLoopImplBase._queue$volatile$FU.compareAndSet(this, queue, ((LockFreeTaskQueueCore)queue).next());
                    }
                }
                continue;
            }
            if (queue == EventLoop_commonKt.access$getCLOSED_EMPTY$p()) {
                return false;
            }
            LockFreeTaskQueueCore<Runnable> newQueue = new LockFreeTaskQueueCore<Runnable>(8, true);
            Intrinsics.checkNotNull(queue, "null cannot be cast to non-null type java.lang.Runnable{ kotlinx.coroutines.RunnableKt.Runnable }");
            newQueue.addLast((Runnable)queue);
            newQueue.addLast(task);
            if (EventLoopImplBase._queue$volatile$FU.compareAndSet(this, queue, newQueue)) break;
        }
        return true;
    }

    private final Runnable dequeue() {
        Object queue;
        EventLoopImplBase eventLoopImplBase = this;
        AtomicReferenceFieldUpdater handler$atomicfu$iv = EventLoopImplBase._queue$volatile$FU;
        while (true) {
            queue = handler$atomicfu$iv.get(this);
            boolean bl = false;
            Object v = queue;
            if (v == null) {
                return null;
            }
            if (v instanceof LockFreeTaskQueueCore) {
                Intrinsics.checkNotNull(queue, "null cannot be cast to non-null type kotlinx.coroutines.internal.LockFreeTaskQueueCore<java.lang.Runnable{ kotlinx.coroutines.RunnableKt.Runnable }>{ kotlinx.coroutines.EventLoop_commonKt.Queue<java.lang.Runnable{ kotlinx.coroutines.RunnableKt.Runnable }> }");
                Object result2 = ((LockFreeTaskQueueCore)queue).removeFirstOrNull();
                if (result2 != LockFreeTaskQueueCore.REMOVE_FROZEN) {
                    return (Runnable)result2;
                }
                EventLoopImplBase._queue$volatile$FU.compareAndSet(this, queue, ((LockFreeTaskQueueCore)queue).next());
                continue;
            }
            if (queue == EventLoop_commonKt.access$getCLOSED_EMPTY$p()) {
                return null;
            }
            if (EventLoopImplBase._queue$volatile$FU.compareAndSet(this, queue, null)) break;
        }
        Intrinsics.checkNotNull(queue, "null cannot be cast to non-null type java.lang.Runnable{ kotlinx.coroutines.RunnableKt.Runnable }");
        return (Runnable)queue;
    }

    private final void closeQueue() {
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl = false;
            if (!this.isCompleted()) {
                throw new AssertionError();
            }
        }
        EventLoopImplBase bl = this;
        AtomicReferenceFieldUpdater handler$atomicfu$iv = EventLoopImplBase._queue$volatile$FU;
        while (true) {
            Object queue = handler$atomicfu$iv.get(this);
            boolean bl2 = false;
            Object v = queue;
            if (v == null) {
                if (!EventLoopImplBase._queue$volatile$FU.compareAndSet(this, null, EventLoop_commonKt.access$getCLOSED_EMPTY$p())) continue;
                return;
            }
            if (v instanceof LockFreeTaskQueueCore) {
                ((LockFreeTaskQueueCore)queue).close();
                return;
            }
            if (queue == EventLoop_commonKt.access$getCLOSED_EMPTY$p()) {
                return;
            }
            LockFreeTaskQueueCore<Runnable> newQueue = new LockFreeTaskQueueCore<Runnable>(8, true);
            Intrinsics.checkNotNull(queue, "null cannot be cast to non-null type java.lang.Runnable{ kotlinx.coroutines.RunnableKt.Runnable }");
            newQueue.addLast((Runnable)queue);
            if (EventLoopImplBase._queue$volatile$FU.compareAndSet(this, queue, newQueue)) break;
        }
    }

    public final void schedule(long now, DelayedTask delayedTask) {
        switch (this.scheduleImpl(now, delayedTask)) {
            case 0: {
                if (this.shouldUnpark(delayedTask)) {
                    this.unpark();
                }
                break;
            }
            case 1: {
                this.reschedule(now, delayedTask);
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("unexpected result".toString());
            }
        }
    }

    private final boolean shouldUnpark(DelayedTask task) {
        DelayedTaskQueue delayedTaskQueue = (DelayedTaskQueue)EventLoopImplBase._delayed$volatile$FU.get(this);
        return (delayedTaskQueue != null ? (DelayedTask)delayedTaskQueue.peek() : null) == task;
    }

    private final int scheduleImpl(long now, DelayedTask delayedTask) {
        if (this.isCompleted()) {
            return 1;
        }
        DelayedTaskQueue delayedTaskQueue = (DelayedTaskQueue)EventLoopImplBase._delayed$volatile$FU.get(this);
        if (delayedTaskQueue == null) {
            EventLoopImplBase $this$scheduleImpl_u24lambda_u248 = this;
            boolean bl = false;
            EventLoopImplBase._delayed$volatile$FU.compareAndSet($this$scheduleImpl_u24lambda_u248, null, new DelayedTaskQueue(now));
            Object v = EventLoopImplBase._delayed$volatile$FU.get($this$scheduleImpl_u24lambda_u248);
            Intrinsics.checkNotNull(v);
            delayedTaskQueue = (DelayedTaskQueue)v;
        }
        DelayedTaskQueue delayedQueue = delayedTaskQueue;
        return delayedTask.scheduleTask(now, delayedQueue, this);
    }

    protected final void resetAll() {
        EventLoopImplBase._queue$volatile$FU.set(this, null);
        EventLoopImplBase._delayed$volatile$FU.set(this, null);
    }

    private final void rescheduleAllDelayed() {
        Object object;
        AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
        long now = abstractTimeSource != null ? abstractTimeSource.nanoTime() : System.nanoTime();
        while ((object = (DelayedTaskQueue)EventLoopImplBase._delayed$volatile$FU.get(this)) != null && (object = (DelayedTask)((ThreadSafeHeap)object).removeFirstOrNull()) != null) {
            Object delayedTask = object;
            this.reschedule(now, (DelayedTask)delayedTask);
        }
    }

    @Override
    public DisposableHandle invokeOnTimeout(long timeMillis, Runnable block, CoroutineContext context) {
        return Delay.DefaultImpls.invokeOnTimeout(this, timeMillis, block, context);
    }

    static {
        _queue$volatile$FU = AtomicReferenceFieldUpdater.newUpdater(EventLoopImplBase.class, Object.class, "_queue$volatile");
        _delayed$volatile$FU = AtomicReferenceFieldUpdater.newUpdater(EventLoopImplBase.class, Object.class, "_delayed$volatile");
        _isCompleted$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(EventLoopImplBase.class, "_isCompleted$volatile");
    }

    private final class DelayedResumeTask
    extends DelayedTask {
        private final CancellableContinuation<Unit> cont;

        public DelayedResumeTask(long nanoTime, CancellableContinuation<? super Unit> cont) {
            super(nanoTime);
            this.cont = cont;
        }

        @Override
        public void run() {
            CancellableContinuation<Unit> cancellableContinuation = this.cont;
            EventLoopImplBase eventLoopImplBase = EventLoopImplBase.this;
            CancellableContinuation<Unit> $this$run_u24lambda_u240 = cancellableContinuation;
            boolean bl = false;
            $this$run_u24lambda_u240.resumeUndispatched(eventLoopImplBase, Unit.INSTANCE);
        }

        @Override
        public String toString() {
            return super.toString() + this.cont;
        }
    }

    private static final class DelayedRunnableTask
    extends DelayedTask {
        private final Runnable block;

        public DelayedRunnableTask(long nanoTime, Runnable block) {
            super(nanoTime);
            this.block = block;
        }

        @Override
        public void run() {
            this.block.run();
        }

        @Override
        public String toString() {
            return super.toString() + this.block;
        }
    }

    public static abstract class DelayedTask
    implements Comparable<DelayedTask>,
    Runnable,
    DisposableHandle,
    ThreadSafeHeapNode {
        public long nanoTime;
        private volatile Object _heap;
        private int index;

        public DelayedTask(long nanoTime) {
            this.nanoTime = nanoTime;
            this.index = -1;
        }

        @Override
        public ThreadSafeHeap<?> getHeap() {
            Object object = this._heap;
            return object instanceof ThreadSafeHeap ? (ThreadSafeHeap)object : null;
        }

        @Override
        public void setHeap(ThreadSafeHeap<?> value) {
            if (!(this._heap != EventLoop_commonKt.access$getDISPOSED_TASK$p())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this._heap = value;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int compareTo(DelayedTask other) {
            long dTime = this.nanoTime - other.nanoTime;
            return dTime > 0L ? 1 : (dTime < 0L ? -1 : 0);
        }

        public final boolean timeToExecute(long now) {
            return now - this.nanoTime >= 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final int scheduleTask(long now, DelayedTaskQueue delayed, EventLoopImplBase eventLoop) {
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            DelayedTask delayedTask = this;
            synchronized (delayedTask) {
                boolean bl = false;
                if (this._heap == EventLoop_commonKt.access$getDISPOSED_TASK$p()) {
                    return 2;
                }
                ThreadSafeHeap this_$iv = delayed;
                boolean $i$f$addLastIf = false;
                boolean $i$f$synchronized2 = false;
                boolean $i$f$synchronizedImpl2 = false;
                ThreadSafeHeap threadSafeHeap = this_$iv;
                synchronized (threadSafeHeap) {
                    boolean bl2 = false;
                    DelayedTask firstTask = (DelayedTask)this_$iv.firstImpl();
                    boolean bl3 = false;
                    if (eventLoop.isCompleted()) {
                        return 1;
                    }
                    if (firstTask == null) {
                        delayed.timeNow = now;
                    } else {
                        long minTime;
                        long firstTime = firstTask.nanoTime;
                        long l = minTime = firstTime - now >= 0L ? now : firstTime;
                        if (minTime - delayed.timeNow > 0L) {
                            delayed.timeNow = minTime;
                        }
                    }
                    if (this.nanoTime - delayed.timeNow < 0L) {
                        this.nanoTime = delayed.timeNow;
                    }
                    this_$iv.addImpl((ThreadSafeHeapNode)this);
                    return 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void dispose() {
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            DelayedTask delayedTask = this;
            synchronized (delayedTask) {
                boolean bl = false;
                Object heap = this._heap;
                if (heap == EventLoop_commonKt.access$getDISPOSED_TASK$p()) {
                    return;
                }
                DelayedTaskQueue delayedTaskQueue = heap instanceof DelayedTaskQueue ? (DelayedTaskQueue)heap : null;
                if (delayedTaskQueue != null) {
                    delayedTaskQueue.remove((ThreadSafeHeapNode)this);
                }
                this._heap = EventLoop_commonKt.access$getDISPOSED_TASK$p();
                Unit unit = Unit.INSTANCE;
            }
        }

        public String toString() {
            return "Delayed[nanos=" + this.nanoTime + ']';
        }
    }

    public static final class DelayedTaskQueue
    extends ThreadSafeHeap<DelayedTask> {
        public long timeNow;

        public DelayedTaskQueue(long timeNow) {
            this.timeNow = timeNow;
        }
    }
}

