/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FilePathComponentsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;

class FilesKt__FileReadWriteKt
extends FilesKt__FilePathComponentsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeText(File $this$writeText, String text, Charset charset) {
        Intrinsics.checkNotNullParameter($this$writeText, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Closeable closeable = new FileOutputStream($this$writeText);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            FilesKt.writeTextImpl(it, text, charset);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ void writeText$default(File file, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.writeText(file, string, charset);
    }

    public static final void writeTextImpl(OutputStream $this$writeTextImpl, String text, Charset charset) {
        Intrinsics.checkNotNullParameter($this$writeTextImpl, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        int chunkSize = 8192;
        if (text.length() < 2 * chunkSize) {
            byte[] byArray = text.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            $this$writeTextImpl.write(byArray);
            return;
        }
        CharsetEncoder encoder = FilesKt.newReplaceEncoder(charset);
        CharBuffer charBuffer = CharBuffer.allocate(chunkSize);
        Intrinsics.checkNotNull(encoder);
        ByteBuffer byteBuffer = FilesKt.byteBufferForEncoding(chunkSize, encoder);
        int startIndex = 0;
        int leftover = 0;
        while (startIndex < text.length()) {
            char[] cArray;
            int copyLength = Math.min(chunkSize - leftover, text.length() - startIndex);
            int endIndex = startIndex + copyLength;
            Object object = text;
            Intrinsics.checkNotNullExpressionValue(charBuffer.array(), "array(...)");
            ((String)object).getChars(startIndex, endIndex, cArray, leftover);
            charBuffer.limit(copyLength + leftover);
            Object it = object = encoder.encode(charBuffer, byteBuffer, endIndex == text.length());
            boolean bl = false;
            boolean bl2 = ((CoderResult)it).isUnderflow();
            if (!bl2) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            $this$writeTextImpl.write(byteBuffer.array(), 0, byteBuffer.position());
            if (charBuffer.position() != charBuffer.limit()) {
                charBuffer.put(0, charBuffer.get());
                leftover = 1;
            } else {
                leftover = 0;
            }
            charBuffer.clear();
            byteBuffer.clear();
            startIndex = endIndex;
        }
    }

    public static final CharsetEncoder newReplaceEncoder(Charset $this$newReplaceEncoder) {
        Intrinsics.checkNotNullParameter($this$newReplaceEncoder, "<this>");
        return $this$newReplaceEncoder.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public static final ByteBuffer byteBufferForEncoding(int chunkSize, CharsetEncoder encoder) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        int maxBytesPerChar = (int)Math.ceil(encoder.maxBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(chunkSize * maxBytesPerChar);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(...)");
        return byteBuffer;
    }
}

