/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.ws;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.network.ws.SubscriptionWsProtocol;
import com.apollographql.apollo.network.ws.WebSocketConnection;
import com.apollographql.apollo.network.ws.WsFrameType;
import com.apollographql.apollo.network.ws.WsProtocol;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;

public final class SubscriptionWsProtocol
extends WsProtocol {
    private final long connectionAcknowledgeTimeoutMs;
    private final Function1<Continuation<? super Map<String, ? extends Object>>, Object> connectionPayload;
    private final WsFrameType frameType;

    public SubscriptionWsProtocol(WebSocketConnection webSocketConnection, WsProtocol.Listener listener2, long connectionAcknowledgeTimeoutMs, Function1<? super Continuation<? super Map<String, ? extends Object>>, ? extends Object> connectionPayload, WsFrameType frameType) {
        Intrinsics.checkNotNullParameter(webSocketConnection, "webSocketConnection");
        Intrinsics.checkNotNullParameter(listener2, "listener");
        Intrinsics.checkNotNullParameter(connectionPayload, "connectionPayload");
        Intrinsics.checkNotNullParameter((Object)frameType, "frameType");
        super(webSocketConnection, listener2);
        this.connectionAcknowledgeTimeoutMs = connectionAcknowledgeTimeoutMs;
        this.connectionPayload = connectionPayload;
        this.frameType = frameType;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object connectionInit(Continuation<? super Unit> $completion) {
        if (!($completion instanceof connectionInit.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SubscriptionWsProtocol this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                public final Object invokeSuspend(Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connectionInit(this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var3_5 = new Pair[]{TuplesKt.to("type", "connection_init")};
                message = MapsKt.mutableMapOf(var3_5);
                $continuation.L$0 = this;
                $continuation.L$1 = message;
                $continuation.label = 1;
                v0 = this.connectionPayload.invoke($continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                message = (Map<String, Map>)$continuation.L$1;
                this = (SubscriptionWsProtocol)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((payload = (Map)v0) != null) {
                    message.put("payload", payload);
                }
                this.sendMessageMap(message, this.frameType);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = TimeoutKt.withTimeout(this.connectionAcknowledgeTimeoutMs, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ SubscriptionWsProtocol this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                this.label = 1;
                                v0 = this.this$0.receiveMessageMap(this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if (Intrinsics.areEqual(type = (map = (Map)v0).get("type"), "connection_ack")) {
                                    return Unit.INSTANCE;
                                }
                                if (Intrinsics.areEqual(type, "connection_error")) {
                                    throw new ApolloNetworkException("Connection error:\n" + map, (Object)null, 2, null);
                                }
                                System.out.println((Object)("unknown message while waiting for connection_ack: '" + type));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl40
            }
            case 2: {
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl40:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void handleServerMessage(Map<String, ? extends Object> messageMap) {
        block3: {
            Object object;
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter(messageMap, "messageMap");
                    object = messageMap.get("type");
                    if (!Intrinsics.areEqual(object, "data")) break block2;
                    WsProtocol.Listener listener2 = this.getListener();
                    Object object2 = messageMap.get("id");
                    Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.String");
                    String string = (String)object2;
                    Object object3 = messageMap.get("payload");
                    Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    listener2.operationResponse(string, (Map)object3);
                    break block3;
                }
                if (!Intrinsics.areEqual(object, "error")) break block4;
                Object id = messageMap.get("id");
                if (id instanceof String) {
                    this.getListener().operationError((String)id, (Map)messageMap.get("payload"));
                } else {
                    this.getListener().generalError((Map)messageMap.get("payload"));
                }
                break block3;
            }
            if (!Intrinsics.areEqual(object, "complete")) break block3;
            WsProtocol.Listener listener3 = this.getListener();
            Object object4 = messageMap.get("id");
            Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.String");
            listener3.operationComplete((String)object4);
        }
    }

    @Override
    public <D extends Operation.Data> void startOperation(ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Pair[] pairArray = new Pair[]{TuplesKt.to("type", "start"), TuplesKt.to("id", request.getRequestUuid().toString()), TuplesKt.to("payload", DefaultHttpRequestComposer.Companion.composePayload(request))};
        this.sendMessageMap(MapsKt.mapOf(pairArray), this.frameType);
    }

    @Override
    public <D extends Operation.Data> void stopOperation(ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Pair[] pairArray = new Pair[]{TuplesKt.to("type", "stop"), TuplesKt.to("id", request.getRequestUuid().toString())};
        this.sendMessageMap(MapsKt.mapOf(pairArray), this.frameType);
    }

    public static final class Factory
    implements WsProtocol.Factory {
        private final long connectionAcknowledgeTimeoutMs;
        private final Function1<Continuation<? super Map<String, ? extends Object>>, Object> connectionPayload;
        private final WsFrameType frameType;

        public Factory(long connectionAcknowledgeTimeoutMs, Function1<? super Continuation<? super Map<String, ? extends Object>>, ? extends Object> connectionPayload, WsFrameType frameType) {
            Intrinsics.checkNotNullParameter(connectionPayload, "connectionPayload");
            Intrinsics.checkNotNullParameter((Object)frameType, "frameType");
            this.connectionAcknowledgeTimeoutMs = connectionAcknowledgeTimeoutMs;
            this.connectionPayload = connectionPayload;
            this.frameType = frameType;
        }

        public /* synthetic */ Factory(long l, Function1 function1, WsFrameType wsFrameType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 10000L;
            }
            if ((n & 2) != 0) {
                function1 = new Function1<Continuation, Object>(null){
                    int label;

                    @Override
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                return null;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Override
                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Override
                    public final Object invoke(Continuation p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                };
            }
            if ((n & 4) != 0) {
                wsFrameType = WsFrameType.Text;
            }
            this(l, function1, wsFrameType);
        }

        @Override
        public String getName() {
            return "graphql-ws";
        }

        @Override
        public WsProtocol create(WebSocketConnection webSocketConnection, WsProtocol.Listener listener2, CoroutineScope scope) {
            Intrinsics.checkNotNullParameter(webSocketConnection, "webSocketConnection");
            Intrinsics.checkNotNullParameter(listener2, "listener");
            Intrinsics.checkNotNullParameter(scope, "scope");
            Function1<Continuation<? super Map<String, ? extends Object>>, Object> function1 = this.connectionPayload;
            long l = this.connectionAcknowledgeTimeoutMs;
            WsFrameType wsFrameType = this.frameType;
            return new SubscriptionWsProtocol(webSocketConnection, listener2, l, function1, wsFrameType);
        }

        public Factory() {
            this(0L, null, null, 7, null);
        }
    }
}

