/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.json;

import com.apollographql.apollo.api.Upload;
import com.apollographql.apollo.api.json.JsonNumber;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.api.json.internal.JsonScope;
import java.io.IOException;
import java.util.Arrays;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;

public final class BufferedSinkJsonWriter
implements JsonWriter {
    public static final Companion Companion;
    private final BufferedSink sink;
    private final String indent;
    private int stackSize;
    private int[] scopes;
    private String[] pathNames;
    private int[] pathIndices;
    private String deferredName;
    private static final String[] REPLACEMENT_CHARS;

    public BufferedSinkJsonWriter(BufferedSink sink2, String indent) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        this.sink = sink2;
        this.indent = indent;
        this.scopes = new int[64];
        this.pathNames = new String[64];
        this.pathIndices = new int[64];
        this.pushScope(6);
    }

    private final String getSeparator() {
        CharSequence charSequence = this.indent;
        return charSequence == null || charSequence.length() == 0 ? ":" : ": ";
    }

    @Override
    public String getPath() {
        return CollectionsKt.joinToString$default(JsonScope.INSTANCE.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices), ".", null, null, 0, null, null, 62, null);
    }

    @Override
    public JsonWriter beginArray() {
        this.writeDeferredName();
        return this.open(1, "[");
    }

    @Override
    public JsonWriter endArray() {
        return this.close(1, 2, "]");
    }

    @Override
    public JsonWriter beginObject() {
        this.writeDeferredName();
        return this.open(3, "{");
    }

    @Override
    public JsonWriter endObject() {
        return this.close(3, 5, "}");
    }

    private final JsonWriter open(int empty, String openBracket) {
        this.beforeValue();
        this.pushScope(empty);
        this.pathIndices[this.stackSize - 1] = 0;
        this.sink.writeUtf8(openBracket);
        return this;
    }

    private final JsonWriter close(int empty, int nonempty, String closeBracket) {
        int context = this.peekScope();
        if (!(context == nonempty || context == empty)) {
            boolean $i$a$-check-BufferedSinkJsonWriter$close$32 = false;
            String $i$a$-check-BufferedSinkJsonWriter$close$32 = "Nesting problem.";
            throw new IllegalStateException($i$a$-check-BufferedSinkJsonWriter$close$32.toString());
        }
        if (!(this.deferredName == null)) {
            boolean bl = false;
            String string = "Dangling name: " + this.deferredName;
            throw new IllegalStateException(string.toString());
        }
        int n = this.stackSize;
        this.stackSize = n + -1;
        this.pathNames[this.stackSize] = null;
        int[] nArray = this.pathIndices;
        int n2 = this.stackSize - 1;
        int n3 = nArray[n2];
        nArray[n2] = n3 + 1;
        if (context == nonempty) {
            this.newline();
        }
        this.sink.writeUtf8(closeBracket);
        return this;
    }

    @Override
    public JsonWriter name(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (!(this.stackSize != 0)) {
            boolean $i$a$-check-BufferedSinkJsonWriter$name$32 = false;
            String $i$a$-check-BufferedSinkJsonWriter$name$32 = "JsonWriter is closed.";
            throw new IllegalStateException($i$a$-check-BufferedSinkJsonWriter$name$32.toString());
        }
        if (!(this.deferredName == null)) {
            boolean bl = false;
            String string = "Nesting problem.";
            throw new IllegalStateException(string.toString());
        }
        this.deferredName = name;
        this.pathNames[this.stackSize - 1] = name;
        return this;
    }

    private final void writeDeferredName() {
        if (this.deferredName != null) {
            this.beforeName();
            String string = this.deferredName;
            Intrinsics.checkNotNull(string);
            Companion.string(this.sink, string);
            this.deferredName = null;
        }
    }

    @Override
    public JsonWriter value(String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.writeDeferredName();
        this.beforeValue();
        Companion.string(this.sink, value);
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return this;
    }

    @Override
    public JsonWriter nullValue() {
        return this.jsonValue("null");
    }

    @Override
    public JsonWriter value(boolean value) {
        return this.jsonValue(value ? "true" : "false");
    }

    @Override
    public JsonWriter value(double value) {
        if (!(!Double.isNaN(value) && !Double.isInfinite(value))) {
            boolean bl = false;
            String string = "Numeric values must be finite, but was " + value;
            throw new IllegalArgumentException(string.toString());
        }
        return this.jsonValue(String.valueOf(value));
    }

    @Override
    public JsonWriter value(int value) {
        return this.jsonValue(String.valueOf(value));
    }

    @Override
    public JsonWriter value(long value) {
        return this.jsonValue(String.valueOf(value));
    }

    @Override
    public JsonWriter value(JsonNumber value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return this.jsonValue(value.getValue());
    }

    @Override
    public BufferedSinkJsonWriter value(Upload value) {
        BufferedSinkJsonWriter bufferedSinkJsonWriter;
        Intrinsics.checkNotNullParameter(value, "value");
        BufferedSinkJsonWriter $this$value_u24lambda_u245 = bufferedSinkJsonWriter = this;
        boolean bl = false;
        $this$value_u24lambda_u245.nullValue();
        return bufferedSinkJsonWriter;
    }

    public final JsonWriter jsonValue(String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.writeDeferredName();
        this.beforeValue();
        this.sink.writeUtf8(value);
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return this;
    }

    @Override
    public void close() {
        this.sink.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.scopes[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private final void newline() {
        if (this.indent == null) {
            return;
        }
        this.sink.writeByte(10);
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.sink.writeUtf8(this.indent);
        }
    }

    private final void beforeName() {
        int context = this.peekScope();
        if (context == 5) {
            this.sink.writeByte(44);
        } else if (!(context == 3)) {
            boolean bl = false;
            String string = "Nesting problem.";
            throw new IllegalStateException(string.toString());
        }
        this.newline();
        this.replaceTop(4);
    }

    private final void beforeValue() {
        switch (this.peekScope()) {
            case 7: {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.sink.writeByte(44);
                this.newline();
                break;
            }
            case 4: {
                this.sink.writeUtf8(this.getSeparator());
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    private final int peekScope() {
        if (!(this.stackSize != 0)) {
            boolean bl = false;
            String string = "JsonWriter is closed.";
            throw new IllegalStateException(string.toString());
        }
        return this.scopes[this.stackSize - 1];
    }

    private final void pushScope(int newTop) {
        if (this.stackSize == this.scopes.length) {
            int[] nArray = Arrays.copyOf(this.scopes, this.scopes.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            this.scopes = nArray;
            String[] stringArray = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
            Intrinsics.checkNotNullExpressionValue(stringArray, "copyOf(...)");
            this.pathNames = stringArray;
            int[] nArray2 = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray2, "copyOf(...)");
            this.pathIndices = nArray2;
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
        this.scopes[n] = newTop;
    }

    private final void replaceTop(int topOfStack) {
        this.scopes[this.stackSize - 1] = topOfStack;
    }

    static {
        String[] stringArray;
        Companion = new Companion(null);
        String[] $this$REPLACEMENT_CHARS_u24lambda_u249 = stringArray = new String[128];
        boolean bl = false;
        for (int i = 0; i < 32; ++i) {
            $this$REPLACEMENT_CHARS_u24lambda_u249[i] = "\\u00" + BufferedSinkJsonWriter.Companion.hexString((byte)i);
        }
        $this$REPLACEMENT_CHARS_u24lambda_u249[34] = "\\\"";
        $this$REPLACEMENT_CHARS_u24lambda_u249[92] = "\\\\";
        $this$REPLACEMENT_CHARS_u24lambda_u249[9] = "\\t";
        $this$REPLACEMENT_CHARS_u24lambda_u249[8] = "\\b";
        $this$REPLACEMENT_CHARS_u24lambda_u249[10] = "\\n";
        $this$REPLACEMENT_CHARS_u24lambda_u249[13] = "\\r";
        REPLACEMENT_CHARS = stringArray;
    }

    public static final class Companion {
        private Companion() {
        }

        private final String hexString(byte $this$hexString) {
            byte value = $this$hexString;
            return "" + "0123456789abcdef".charAt(value >>> 4) + "0123456789abcdef".charAt(value & 0xF);
        }

        public final void string(BufferedSink sink2, String value) {
            Intrinsics.checkNotNullParameter(sink2, "sink");
            Intrinsics.checkNotNullParameter(value, "value");
            String[] replacements = REPLACEMENT_CHARS;
            sink2.writeByte(34);
            int last = 0;
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                String replacement = null;
                if (c < '\u0080') {
                    replacement = replacements[c];
                    if (replacement == null) {
                        continue;
                    }
                } else if (c == '\u2028') {
                    replacement = "\\u2028";
                } else {
                    if (c != '\u2029') continue;
                    replacement = "\\u2029";
                }
                if (last < i) {
                    sink2.writeUtf8(value, last, i);
                }
                sink2.writeUtf8(replacement);
                last = i + 1;
            }
            if (last < length) {
                sink2.writeUtf8(value, last, length);
            }
            sink2.writeByte(34);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

