/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;

public final class SegmentedSequenceBuilder {
    private final ArrayList<BasedSequence> segments;
    private final BasedSequence base;

    public SegmentedSequenceBuilder(BasedSequence base) {
        this.segments = new ArrayList();
        this.base = base;
    }

    public SegmentedSequenceBuilder(BasedSequence base, int initialCapacity) {
        this.segments = new ArrayList(initialCapacity);
        this.base = base;
    }

    public SegmentedSequenceBuilder append(BasedSequence s) {
        this.segments.add(s);
        return this;
    }

    public SegmentedSequenceBuilder append(String str) {
        return this.append(PrefixedSubSequence.of(str, this.base, 0, 0));
    }

    public BasedSequence toBasedSequence() {
        return SegmentedSequence.of(this.segments, this.base);
    }

    public BasedSequence[] toSegments() {
        return this.segments.toArray(new BasedSequence[this.segments.size()]);
    }

    public String toString() {
        int total = 0;
        for (BasedSequence s : this.segments) {
            total += s.length();
        }
        StringBuilder sb = new StringBuilder(total);
        for (BasedSequence s : this.segments) {
            s.appendTo(sb);
        }
        return sb.toString();
    }
}

