/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GtkTargetEntry;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Display;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    long clipboardOwner = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(Display display) {
        ClipboardProxy proxy = (ClipboardProxy)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxy(display);
        display.setData(ID, proxy);
        display.disposeExec(() -> {
            ClipboardProxy clipbordProxy = (ClipboardProxy)display.getData(ID);
            if (clipbordProxy == null) {
                return;
            }
            display.setData(ID, null);
            clipbordProxy.dispose();
        });
        return proxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        this.clearFunc = new Callback(this, "clearFunc", 2);
    }

    void clear(Clipboard owner, int clipboards) {
        if ((clipboards & 1) != 0 && this.activeClipboard == owner) {
            this.gtk_gdk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((clipboards & 2) != 0 && this.activePrimaryClipboard == owner) {
            this.gtk_gdk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    void gtk_gdk_clipboard_clear(long clipboard) {
        if (GTK.GTK4) {
            GDK.gdk_clipboard_set_content(clipboard, 0L);
        } else {
            GTK3.gtk_clipboard_clear(clipboard);
        }
    }

    long clearFunc(long clipboard, long user_data_or_owner) {
        if (clipboard == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (clipboard == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1L;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null && !GTK.GTK4) {
            GTK3.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null && !GTK.GTK4) {
            GTK3.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_window_destroy(this.clipboardOwner);
            } else {
                GTK3.gtk_widget_destroy(this.clipboardOwner);
            }
        }
        this.clipboardOwner = 0L;
    }

    long getFunc(long clipboard, long selection_data, long info, long user_data_or_owner) {
        if (selection_data == 0L) {
            return 0L;
        }
        long target = GTK3.gtk_selection_data_get_target(selection_data);
        TransferData tdata = new TransferData();
        tdata.type = target;
        Transfer[] types = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isSupportedType(tdata)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return 0L;
        }
        Object[] data = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        types[index].javaToNative(data[index], tdata);
        if (tdata.format < 8 || tdata.format % 8 != 0) {
            return 0L;
        }
        GTK3.gtk_selection_data_set(selection_data, tdata.type, tdata.format, tdata.pValue, tdata.length);
        OS.g_free(tdata.pValue);
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean setData(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        block17: {
            block16: {
                if (GTK.GTK4) {
                    return this.setData_gtk4(owner, data, dataTypes, clipboards);
                }
                entries = new GtkTargetEntry[]{};
                pTargetsList = 0L;
                for (i = 0; i < dataTypes.length; ++i) {
                    transfer = dataTypes[i];
                    typeIds = transfer.getTypeIds();
                    typeNames = transfer.getTypeNames();
                    for (j = 0; j < typeIds.length; ++j) {
                        entry = new GtkTargetEntry();
                        entry.info = typeIds[j];
                        buffer = Converter.wcsToMbcs(typeNames[j], true);
                        pName = OS.g_malloc(buffer.length);
                        C.memmove(pName, buffer, (long)buffer.length);
                        entry.target = pName;
                        tmp = new GtkTargetEntry[entries.length + 1];
                        System.arraycopy(entries, 0, tmp, 0, entries.length);
                        tmp[entries.length] = entry;
                        entries = tmp;
                    }
                }
                pTargetsList = OS.g_malloc(GtkTargetEntry.sizeof * entries.length);
                offset = 0;
                for (i = 0; i < entries.length; ++i) {
                    GTK3.memmove(pTargetsList + (long)offset, entries[i], (long)GtkTargetEntry.sizeof);
                    offset += GtkTargetEntry.sizeof;
                }
                if ((clipboards & 1) == 0) ** GOTO lbl47
                this.clipboardData = data;
                this.clipboardDataTypes = dataTypes;
                getFuncProc = this.getFunc.getAddress();
                if (GTK3.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) break block16;
                var13_19 = false;
                for (i = 0; i < entries.length; ++i) {
                    entry = entries[i];
                    if (entry.target == 0L) continue;
                    OS.g_free(entry.target);
                }
                if (pTargetsList != 0L) {
                    OS.g_free(pTargetsList);
                }
                return var13_19;
            }
            GTK3.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0L, 0);
            this.activeClipboard = owner;
lbl47:
            // 2 sources

            if ((clipboards & 2) == 0) ** GOTO lbl65
            this.primaryClipboardData = data;
            this.primaryClipboardDataTypes = dataTypes;
            getFuncProc = this.getFunc.getAddress();
            if (GTK3.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) break block17;
            var13_20 = false;
            for (i = 0; i < entries.length; ++i) {
                entry = entries[i];
                if (entry.target == 0L) continue;
                OS.g_free(entry.target);
            }
            if (pTargetsList != 0L) {
                OS.g_free(pTargetsList);
            }
            return var13_20;
        }
        try {
            GTK3.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0L, 0);
            this.activePrimaryClipboard = owner;
lbl65:
            // 2 sources

            var9_11 = true;
        }
        catch (Throwable var18_28) {
            for (i = 0; i < entries.length; ++i) {
                entry = entries[i];
                if (entry.target == 0L) continue;
                OS.g_free(entry.target);
            }
            if (pTargetsList != 0L) {
                OS.g_free(pTargetsList);
            }
            throw var18_28;
        }
        for (i = 0; i < entries.length; ++i) {
            entry = entries[i];
            if (entry.target == 0L) continue;
            OS.g_free(entry.target);
        }
        if (pTargetsList != 0L) {
            OS.g_free(pTargetsList);
        }
        return var9_11;
    }

    private boolean setData_gtk4(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        boolean result = false;
        long[] providers = new long[]{};
        for (int i = 0; i < dataTypes.length; ++i) {
            Transfer transfer = dataTypes[i];
            String[] typeNames = transfer.getTypeNames();
            long provider = this.setProviderFromType(typeNames[0], data[i]);
            if (provider == 0L) continue;
            long[] tmp = new long[providers.length + 1];
            System.arraycopy(providers, 0, tmp, 0, providers.length);
            tmp[providers.length] = provider;
            providers = tmp;
        }
        if (providers.length == 0) {
            return false;
        }
        long union = GTK4.gdk_content_provider_new_union(providers, providers.length);
        if ((clipboards & 1) != 0) {
            this.clipboardData = data;
            this.clipboardDataTypes = dataTypes;
            result = GTK4.gdk_clipboard_set_content(Clipboard.GTKCLIPBOARD, union);
            this.activeClipboard = owner;
        }
        return result;
    }

    private long setProviderFromType(String string, Object data) {
        long provider = 0L;
        if (data == null) {
            SWT.error(4);
        } else {
            long value;
            if (string.equals("text/plain") || string.equals("text/rtf")) {
                value = OS.g_malloc(OS.GValue_sizeof());
                C.memset(value, 0, OS.GValue_sizeof());
                OS.g_value_init(value, OS.G_TYPE_STRING());
                OS.g_value_set_string(value, Converter.javaStringToCString((String)data));
                provider = GTK4.gdk_content_provider_new_for_value(value);
            }
            if (string.equals("PIXBUF")) {
                if (!(data instanceof ImageData)) {
                    DND.error(2003);
                }
                ImageData imgData = (ImageData)data;
                Image image = new Image((Device)Display.getCurrent(), imgData);
                long pixbuf = ImageList.createPixbuf(image);
                if (pixbuf != 0L) {
                    provider = GTK4.gdk_content_provider_new_typed(GDK.GDK_TYPE_PIXBUF(), pixbuf);
                }
                image.dispose();
            }
            if (string.equals("text/html")) {
                value = OS.g_malloc(OS.GValue_sizeof());
                C.memset(value, 0, OS.GValue_sizeof());
                OS.g_value_init(value, OS.G_TYPE_STRING());
                OS.g_value_set_string(value, Converter.javaStringToCString((String)data));
                provider = GTK4.gdk_content_provider_new_for_value(value);
            }
        }
        return provider;
    }
}

