/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;

public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    public static final Companion Companion = new Companion(null);
    private final ByteString[] byteStrings;
    private final int[] trie;

    private Options(ByteString[] byteStrings, int[] trie) {
        this.byteStrings = byteStrings;
        this.trie = trie;
    }

    public final ByteString[] getByteStrings$okio() {
        return this.byteStrings;
    }

    public final int[] getTrie$okio() {
        return this.trie;
    }

    @Override
    public int getSize() {
        return this.byteStrings.length;
    }

    @Override
    public ByteString get(int index) {
        return this.byteStrings[index];
    }

    public /* synthetic */ Options(ByteString[] byteStrings, int[] trie, DefaultConstructorMarker $constructor_marker) {
        this(byteStrings, trie);
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final Options of(ByteString ... byteStrings) {
            int n;
            Intrinsics.checkNotNullParameter(byteStrings, "byteStrings");
            if (byteStrings.length == 0) {
                int[] nArray = new int[]{0, -1};
                return new Options(new ByteString[0], nArray, null);
            }
            List<ByteString> list = ArraysKt.toMutableList(byteStrings);
            CollectionsKt.sort(list);
            int n2 = list.size();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                n = n4 = n3++;
                ArrayList<Integer> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(-1);
            }
            List indexes = arrayList;
            ByteString[] $this$forEachIndexed$iv = byteStrings;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ByteString item$iv : $this$forEachIndexed$iv) {
                void byteString;
                int n5 = index$iv++;
                ByteString byteString2 = item$iv;
                int callerIndex = n5;
                boolean bl = false;
                int sortedIndex = CollectionsKt.binarySearch$default(list, (Comparable)byteString, 0, 0, 6, null);
                indexes.set(sortedIndex, callerIndex);
            }
            if (!(list.get(0).size() > 0)) {
                boolean $i$a$-require-Options$Companion$of$42 = false;
                String $i$a$-require-Options$Companion$of$42 = "the empty byte string is not a supported option";
                throw new IllegalArgumentException($i$a$-require-Options$Companion$of$42.toString());
            }
            for (int a = 0; a < list.size(); ++a) {
                ByteString byteString;
                ByteString prefix = list.get(a);
                int b = a + 1;
                while (b < list.size() && (byteString = list.get(b)).startsWith(prefix)) {
                    if (!(byteString.size() != prefix.size())) {
                        boolean bl = false;
                        String string = "duplicate option: " + byteString;
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (((Number)indexes.get(b)).intValue() > ((Number)indexes.get(a)).intValue()) {
                        list.remove(b);
                        indexes.remove(b);
                        continue;
                    }
                    ++b;
                }
            }
            Buffer trieBytes = new Buffer();
            okio.Options$Companion.buildTrieRecursive$default(this, 0L, trieBytes, 0, list, 0, 0, indexes, 53, null);
            int n6 = 0;
            n = (int)this.getIntCount(trieBytes);
            int[] nArray = new int[n];
            while (n6 < n) {
                int n7 = n6++;
                nArray[n7] = trieBytes.readInt();
            }
            int[] trie = nArray;
            ByteString[] byteStringArray = Arrays.copyOf(byteStrings, byteStrings.length);
            Intrinsics.checkNotNullExpressionValue(byteStringArray, "copyOf(...)");
            return new Options(byteStringArray, trie, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void buildTrieRecursive(long nodeOffset, Buffer node, int byteStringOffset, List<? extends ByteString> byteStrings, int fromIndex, int toIndex, List<Integer> indexes) {
            if (!(fromIndex < toIndex)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            for (int i = fromIndex; i < toIndex; ++i) {
                if (byteStrings.get(i).size() >= byteStringOffset) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int fromIndex2 = fromIndex;
            ByteString from = byteStrings.get(fromIndex2);
            ByteString to = byteStrings.get(toIndex - 1);
            int prefixIndex = -1;
            if (byteStringOffset == from.size()) {
                prefixIndex = ((Number)indexes.get(fromIndex2)).intValue();
                from = byteStrings.get(++fromIndex2);
            }
            if (from.getByte(byteStringOffset) != to.getByte(byteStringOffset)) {
                int selectChoiceCount = 1;
                for (int i = fromIndex2 + 1; i < toIndex; ++i) {
                    if (byteStrings.get(i - 1).getByte(byteStringOffset) == byteStrings.get(i).getByte(byteStringOffset)) continue;
                    ++selectChoiceCount;
                }
                long childNodesOffset = nodeOffset + this.getIntCount(node) + (long)2 + (long)(selectChoiceCount * 2);
                node.writeInt(selectChoiceCount);
                node.writeInt(prefixIndex);
                for (int i = fromIndex2; i < toIndex; ++i) {
                    void $this$and$iv;
                    byte rangeByte = byteStrings.get(i).getByte(byteStringOffset);
                    if (i != fromIndex2 && rangeByte == byteStrings.get(i - 1).getByte(byteStringOffset)) continue;
                    byte by = rangeByte;
                    int other$iv = 255;
                    boolean $i$f$and = false;
                    node.writeInt($this$and$iv & other$iv);
                }
                Buffer childNodes = new Buffer();
                int rangeStart = fromIndex2;
                while (rangeStart < toIndex) {
                    byte rangeByte = byteStrings.get(rangeStart).getByte(byteStringOffset);
                    int rangeEnd = toIndex;
                    for (int i = rangeStart + 1; i < toIndex; ++i) {
                        if (rangeByte == byteStrings.get(i).getByte(byteStringOffset)) continue;
                        rangeEnd = i;
                        break;
                    }
                    if (rangeStart + 1 == rangeEnd && byteStringOffset + 1 == byteStrings.get(rangeStart).size()) {
                        node.writeInt(((Number)indexes.get(rangeStart)).intValue());
                    } else {
                        node.writeInt(-1 * (int)(childNodesOffset + this.getIntCount(childNodes)));
                        this.buildTrieRecursive(childNodesOffset, childNodes, byteStringOffset + 1, byteStrings, rangeStart, rangeEnd, indexes);
                    }
                    rangeStart = rangeEnd;
                }
                node.writeAll(childNodes);
            } else {
                int scanByteCount = 0;
                int n = Math.min(from.size(), to.size());
                for (int i = byteStringOffset; i < n && from.getByte(i) == to.getByte(i); ++i) {
                    ++scanByteCount;
                }
                long childNodesOffset = nodeOffset + this.getIntCount(node) + (long)2 + (long)scanByteCount + 1L;
                node.writeInt(-scanByteCount);
                node.writeInt(prefixIndex);
                int n2 = byteStringOffset + scanByteCount;
                for (int i = byteStringOffset; i < n2; ++i) {
                    void $this$and$iv;
                    byte rangeByte = from.getByte(i);
                    int other$iv = 255;
                    boolean $i$f$and = false;
                    node.writeInt($this$and$iv & other$iv);
                }
                if (fromIndex2 + 1 == toIndex) {
                    if (!(byteStringOffset + scanByteCount == byteStrings.get(fromIndex2).size())) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    node.writeInt(((Number)indexes.get(fromIndex2)).intValue());
                } else {
                    Buffer childNodes = new Buffer();
                    node.writeInt(-1 * (int)(childNodesOffset + this.getIntCount(childNodes)));
                    this.buildTrieRecursive(childNodesOffset, childNodes, byteStringOffset + scanByteCount, byteStrings, fromIndex2, toIndex, indexes);
                    node.writeAll(childNodes);
                }
            }
        }

        static /* synthetic */ void buildTrieRecursive$default(Companion companion, long l, Buffer buffer, int n, List list, int n2, int n3, List list2, int n4, Object object) {
            if ((n4 & 1) != 0) {
                l = 0L;
            }
            if ((n4 & 4) != 0) {
                n = 0;
            }
            if ((n4 & 0x10) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x20) != 0) {
                n3 = list.size();
            }
            companion.buildTrieRecursive(l, buffer, n, list, n2, n3, list2);
        }

        private final long getIntCount(Buffer $this$intCount) {
            return $this$intCount.size() / (long)4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

