/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;

public final class JsonPath {
    private Object[] currentObjectPath = new Object[8];
    private int[] indicies;
    private int currentDepth;

    public JsonPath() {
        int n = 0;
        int[] nArray = new int[8];
        JsonPath jsonPath = this;
        while (n < 8) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        jsonPath.indicies = nArray;
        this.currentDepth = -1;
    }

    public final void pushDescriptor(SerialDescriptor sd) {
        Intrinsics.checkNotNullParameter(sd, "sd");
        ++this.currentDepth;
        int depth = this.currentDepth;
        if (depth == this.currentObjectPath.length) {
            this.resize();
        }
        this.currentObjectPath[depth] = sd;
    }

    public final void updateDescriptorIndex(int index) {
        this.indicies[this.currentDepth] = index;
    }

    public final void updateCurrentMapKey(Object key) {
        if (this.indicies[this.currentDepth] != -2) {
            ++this.currentDepth;
            if (this.currentDepth == this.currentObjectPath.length) {
                this.resize();
            }
        }
        this.currentObjectPath[this.currentDepth] = key;
        this.indicies[this.currentDepth] = -2;
    }

    public final void resetCurrentMapKey() {
        if (this.indicies[this.currentDepth] == -2) {
            this.currentObjectPath[this.currentDepth] = Tombstone.INSTANCE;
        }
    }

    public final void popDescriptor() {
        int n;
        int depth = this.currentDepth;
        if (this.indicies[depth] == -2) {
            this.indicies[depth] = -1;
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
        if (this.currentDepth != -1) {
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
    }

    public final String getPath() {
        StringBuilder stringBuilder;
        StringBuilder $this$getPath_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getPath_u24lambda_u241.append("$");
        int n = this.currentDepth + 1;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl2 = false;
            Object element = this.currentObjectPath[it];
            if (element instanceof SerialDescriptor) {
                if (Intrinsics.areEqual(((SerialDescriptor)element).getKind(), StructureKind.LIST.INSTANCE)) {
                    if (this.indicies[it] == -1) continue;
                    $this$getPath_u24lambda_u241.append("[");
                    $this$getPath_u24lambda_u241.append(this.indicies[it]);
                    $this$getPath_u24lambda_u241.append("]");
                    continue;
                }
                int idx = this.indicies[it];
                if (idx < 0) continue;
                $this$getPath_u24lambda_u241.append(".");
                $this$getPath_u24lambda_u241.append(((SerialDescriptor)element).getElementName(idx));
                continue;
            }
            if (element == Tombstone.INSTANCE) continue;
            $this$getPath_u24lambda_u241.append("[");
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append(element);
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append("]");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final void resize() {
        int newSize = this.currentDepth * 2;
        Object[] objectArray = Arrays.copyOf(this.currentObjectPath, newSize);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        this.currentObjectPath = objectArray;
        int[] nArray = Arrays.copyOf(this.indicies, newSize);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        this.indicies = nArray;
    }

    public String toString() {
        return this.getPath();
    }

    private static final class Tombstone {
        public static final Tombstone INSTANCE = new Tombstone();

        private Tombstone() {
        }
    }
}

