/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.encoding;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;

public abstract class AbstractDecoder
implements CompositeDecoder,
Decoder {
    public Object decodeValue() {
        throw new SerializationException(Reflection.getOrCreateKotlinClass(this.getClass()) + " can't retrieve untyped values");
    }

    @Override
    public boolean decodeNotNullMark() {
        return true;
    }

    @Override
    public Void decodeNull() {
        return null;
    }

    @Override
    public boolean decodeBoolean() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    @Override
    public byte decodeByte() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Byte");
        return (Byte)object;
    }

    @Override
    public short decodeShort() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Short");
        return (Short)object;
    }

    @Override
    public int decodeInt() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    @Override
    public long decodeLong() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    @Override
    public float decodeFloat() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Float");
        return ((Float)object).floatValue();
    }

    @Override
    public double decodeDouble() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Double");
        return (Double)object;
    }

    @Override
    public char decodeChar() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Char");
        return ((Character)object).charValue();
    }

    @Override
    public String decodeString() {
        Object object = this.decodeValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    @Override
    public Decoder decodeInline(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this;
    }

    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return this.decodeSerializableValue(deserializer);
    }

    @Override
    public CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this;
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
    }

    @Override
    public final boolean decodeBooleanElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeBoolean();
    }

    @Override
    public final byte decodeByteElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeByte();
    }

    @Override
    public final short decodeShortElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeShort();
    }

    @Override
    public final int decodeIntElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeInt();
    }

    @Override
    public final long decodeLongElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeLong();
    }

    @Override
    public final float decodeFloatElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeFloat();
    }

    @Override
    public final double decodeDoubleElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeDouble();
    }

    @Override
    public final char decodeCharElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeChar();
    }

    @Override
    public final String decodeStringElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeString();
    }

    @Override
    public Decoder decodeInlineElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeInline(descriptor.getElementDescriptor(index));
    }

    @Override
    public <T> T decodeSerializableElement(SerialDescriptor descriptor, int index, DeserializationStrategy<? extends T> deserializer, T previousValue) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return this.decodeSerializableValue(deserializer, previousValue);
    }

    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer) {
        return Decoder.DefaultImpls.decodeSerializableValue(this, deserializer);
    }

    @Override
    public boolean decodeSequentially() {
        return CompositeDecoder.DefaultImpls.decodeSequentially(this);
    }

    @Override
    public int decodeCollectionSize(SerialDescriptor descriptor) {
        return CompositeDecoder.DefaultImpls.decodeCollectionSize(this, descriptor);
    }
}

