/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import _COROUTINE.ArtificialStackFrames;
import _COROUTINE.CoroutineDebuggingKt;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.internal.ExceptionsConstructorKt;

public final class StackTraceRecoveryKt {
    private static final StackTraceElement ARTIFICIAL_FRAME;
    private static final String baseContinuationImplClassName;
    private static final String stackTraceRecoveryClassName;

    public static final <E extends Throwable> E recoverStackTrace(E exception) {
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            return exception;
        }
        E e = ExceptionsConstructorKt.tryCopyException(exception);
        if (e == null) {
            return exception;
        }
        E copy = e;
        return StackTraceRecoveryKt.sanitizeStackTrace(copy);
    }

    private static final <E extends Throwable> E sanitizeStackTrace(E $this$sanitizeStackTrace) {
        int n;
        int size;
        StackTraceElement[] stackTrace;
        block3: {
            stackTrace = $this$sanitizeStackTrace.getStackTrace();
            size = stackTrace.length;
            StackTraceElement[] $this$indexOfLast$iv = stackTrace;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    StackTraceElement it = $this$indexOfLast$iv[index$iv];
                    boolean bl = false;
                    if (!Intrinsics.areEqual(stackTraceRecoveryClassName, it.getClassName())) continue;
                    n = index$iv;
                    break block3;
                } while (0 <= n2);
            }
            n = -1;
        }
        int lastIntrinsic = n;
        int startIndex = lastIntrinsic + 1;
        int endIndex = StackTraceRecoveryKt.firstFrameIndex(stackTrace, baseContinuationImplClassName);
        int adjustment = endIndex == -1 ? 0 : size - endIndex;
        int n3 = size - lastIntrinsic - adjustment;
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = i;
            stackTraceElementArray[n4] = n4 == 0 ? ARTIFICIAL_FRAME : stackTrace[startIndex + n4 - 1];
        }
        StackTraceElement[] trace = stackTraceElementArray;
        $this$sanitizeStackTrace.setStackTrace(trace);
        return $this$sanitizeStackTrace;
    }

    private static final <E extends Throwable> E recoverFromStackFrame(E exception, CoroutineStackFrame continuation) {
        Pair<E, StackTraceElement[]> pair = StackTraceRecoveryKt.causeAndStacktrace(exception);
        E cause = pair.component1();
        StackTraceElement[] recoveredStacktrace = pair.component2();
        E e = ExceptionsConstructorKt.tryCopyException(cause);
        if (e == null) {
            return exception;
        }
        E newException = e;
        ArrayDeque<StackTraceElement> stacktrace = StackTraceRecoveryKt.createStackTrace(continuation);
        if (stacktrace.isEmpty()) {
            return exception;
        }
        if (cause != exception) {
            StackTraceRecoveryKt.mergeRecoveredTraces(recoveredStacktrace, stacktrace);
        }
        return StackTraceRecoveryKt.createFinalException(cause, newException, stacktrace);
    }

    private static final <E extends Throwable> E createFinalException(E cause, E result2, ArrayDeque<StackTraceElement> resultStackTrace) {
        resultStackTrace.addFirst(ARTIFICIAL_FRAME);
        StackTraceElement[] causeTrace = cause.getStackTrace();
        int size = StackTraceRecoveryKt.firstFrameIndex(causeTrace, baseContinuationImplClassName);
        if (size == -1) {
            Collection $this$toTypedArray$iv = resultStackTrace;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            result2.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
            return result2;
        }
        StackTraceElement[] mergedStackTrace = new StackTraceElement[resultStackTrace.size() + size];
        for (int i = 0; i < size; ++i) {
            mergedStackTrace[i] = causeTrace[i];
        }
        Iterator<StackTraceElement> iterator2 = resultStackTrace.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            StackTraceElement element;
            int index = n++;
            mergedStackTrace[size + index] = element = iterator2.next();
        }
        result2.setStackTrace(mergedStackTrace);
        return result2;
    }

    private static final <E extends Throwable> Pair<E, StackTraceElement[]> causeAndStacktrace(E $this$causeAndStacktrace) {
        Pair<Object, StackTraceElement[]> pair;
        Throwable cause = $this$causeAndStacktrace.getCause();
        if (cause != null && Intrinsics.areEqual(cause.getClass(), $this$causeAndStacktrace.getClass())) {
            boolean bl;
            StackTraceElement[] currentTrace;
            block5: {
                StackTraceElement[] $this$any$iv = currentTrace = $this$causeAndStacktrace.getStackTrace();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element$iv;
                    StackTraceElement it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                pair = TuplesKt.to(cause, currentTrace);
            } else {
                boolean $i$f$emptyArray = false;
                pair = TuplesKt.to($this$causeAndStacktrace, new StackTraceElement[0]);
            }
        } else {
            boolean $i$f$emptyArray = false;
            pair = TuplesKt.to($this$causeAndStacktrace, new StackTraceElement[0]);
        }
        return pair;
    }

    private static final void mergeRecoveredTraces(StackTraceElement[] recoveredStacktrace, ArrayDeque<StackTraceElement> result2) {
        int lastFrameIndex;
        int n;
        block4: {
            StackTraceElement[] $this$indexOfFirst$iv = recoveredStacktrace;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                n = index$iv;
                break block4;
            }
            n = -1;
        }
        int startIndex = n + 1;
        int i = lastFrameIndex = recoveredStacktrace.length - 1;
        if (startIndex <= i) {
            while (true) {
                StackTraceElement element;
                if (StackTraceRecoveryKt.elementWiseEquals(element = recoveredStacktrace[i], result2.getLast())) {
                    result2.removeLast();
                }
                result2.addFirst(recoveredStacktrace[i]);
                if (i == startIndex) break;
                --i;
            }
        }
    }

    public static final <E extends Throwable> E unwrapImpl(E exception) {
        boolean bl;
        Throwable cause;
        block3: {
            cause = exception.getCause();
            if (cause == null || !Intrinsics.areEqual(cause.getClass(), exception.getClass())) {
                return exception;
            }
            StackTraceElement[] $this$any$iv = exception.getStackTrace();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return (E)cause;
        }
        return exception;
    }

    private static final ArrayDeque<StackTraceElement> createStackTrace(CoroutineStackFrame continuation) {
        CoroutineStackFrame coroutineStackFrame;
        CoroutineStackFrame coroutineStackFrame2;
        ArrayDeque<StackTraceElement> stack = new ArrayDeque<StackTraceElement>();
        StackTraceElement stackTraceElement = continuation.getStackTraceElement();
        if (stackTraceElement != null) {
            StackTraceElement it = stackTraceElement;
            boolean bl = false;
            stack.add(it);
        }
        CoroutineStackFrame last = continuation;
        while ((coroutineStackFrame2 = (coroutineStackFrame = last) instanceof CoroutineStackFrame ? coroutineStackFrame : null) != null && (coroutineStackFrame2 = coroutineStackFrame2.getCallerFrame()) != null) {
            StackTraceElement it;
            last = coroutineStackFrame2;
            if (last.getStackTraceElement() == null) continue;
            boolean bl = false;
            stack.add(it);
        }
        return stack;
    }

    public static final boolean isArtificial(StackTraceElement $this$isArtificial) {
        return StringsKt.startsWith$default($this$isArtificial.getClassName(), CoroutineDebuggingKt.getARTIFICIAL_FRAME_PACKAGE_NAME(), false, 2, null);
    }

    private static final int firstFrameIndex(StackTraceElement[] $this$firstFrameIndex, String methodName) {
        int n;
        block1: {
            StackTraceElement[] $this$indexOfFirst$iv = $this$firstFrameIndex;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!Intrinsics.areEqual(methodName, it.getClassName())) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    private static final boolean elementWiseEquals(StackTraceElement $this$elementWiseEquals, StackTraceElement e) {
        return $this$elementWiseEquals.getLineNumber() == e.getLineNumber() && Intrinsics.areEqual($this$elementWiseEquals.getMethodName(), e.getMethodName()) && Intrinsics.areEqual($this$elementWiseEquals.getFileName(), e.getFileName()) && Intrinsics.areEqual($this$elementWiseEquals.getClassName(), e.getClassName());
    }

    public static final /* synthetic */ Throwable access$recoverFromStackFrame(Throwable exception, CoroutineStackFrame continuation) {
        return StackTraceRecoveryKt.recoverFromStackFrame(exception, continuation);
    }

    static {
        Object object;
        Object object2;
        Object object3;
        Object $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22;
        ARTIFICIAL_FRAME = new ArtificialStackFrames().coroutineBoundary();
        try {
            boolean $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22 = false;
            $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22 = Result.constructor-impl(Class.forName("kotlin.coroutines.jvm.internal.BaseContinuationImpl").getCanonicalName());
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22 = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl($i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22);
        if (throwable == null) {
            object3 = $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object3 = "kotlin.coroutines.jvm.internal.BaseContinuationImpl";
        }
        baseContinuationImplClassName = (String)object3;
        try {
            boolean bl = false;
            object2 = Result.constructor-impl(Class.forName("kotlinx.coroutines.internal.StackTraceRecoveryKt").getCanonicalName());
        }
        catch (Throwable it) {
            object2 = Result.constructor-impl(ResultKt.createFailure(it));
        }
        Throwable throwable2 = Result.exceptionOrNull-impl(object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            it = throwable2;
            boolean bl = false;
            object = "kotlinx.coroutines.internal.StackTraceRecoveryKt";
        }
        stackTraceRecoveryClassName = (String)object;
    }
}

