/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationJvmKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Duration
implements Comparable<Duration> {
    public static final Companion Companion = new Companion(null);
    private final long rawValue;
    private static final long ZERO = Duration.constructor-impl(0L);
    private static final long INFINITE = DurationKt.access$durationOfMillis(0x3FFFFFFFFFFFFFFFL);
    private static final long NEG_INFINITE = DurationKt.access$durationOfMillis(-4611686018427387903L);

    private static final long getValue-impl(long arg0) {
        return arg0 >> 1;
    }

    private static final boolean isInNanos-impl(long arg0) {
        boolean bl = false;
        return ((int)arg0 & 1) == 0;
    }

    private static final boolean isInMillis-impl(long arg0) {
        boolean bl = false;
        return ((int)arg0 & 1) == 1;
    }

    private static final DurationUnit getStorageUnit-impl(long arg0) {
        return Duration.isInNanos-impl(arg0) ? DurationUnit.NANOSECONDS : DurationUnit.MILLISECONDS;
    }

    public static final long unaryMinus-UwyO8pc(long arg0) {
        boolean bl = false;
        return DurationKt.access$durationOf(-Duration.getValue-impl(arg0), (int)arg0 & 1);
    }

    public static final long plus-LRDsOJo(long arg0, long other) {
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            if (Duration.isFinite-impl(other) || (arg0 ^ other) >= 0L) {
                return arg0;
            }
            throw new IllegalArgumentException("Summing infinite durations of different signs yields an undefined result.");
        }
        if (Duration.isInfinite-impl(other)) {
            return other;
        }
        boolean bl = false;
        bl = false;
        if (((int)arg0 & 1) == ((int)other & 1)) {
            long result2 = Duration.getValue-impl(arg0) + Duration.getValue-impl(other);
            l = Duration.isInNanos-impl(arg0) ? DurationKt.access$durationOfNanosNormalized(result2) : DurationKt.access$durationOfMillisNormalized(result2);
        } else {
            l = Duration.isInMillis-impl(arg0) ? Duration.addValuesMixedRanges-UwyO8pc(arg0, Duration.getValue-impl(arg0), Duration.getValue-impl(other)) : Duration.addValuesMixedRanges-UwyO8pc(arg0, Duration.getValue-impl(other), Duration.getValue-impl(arg0));
        }
        return l;
    }

    private static final long addValuesMixedRanges-UwyO8pc(long arg0, long thisMillis, long otherNanos) {
        long l;
        long otherMillis = DurationKt.access$nanosToMillis(otherNanos);
        long resultMillis = thisMillis + otherMillis;
        boolean bl = -4611686018426L <= resultMillis ? resultMillis < 4611686018427L : false;
        if (bl) {
            long otherNanoRemainder = otherNanos - DurationKt.access$millisToNanos(otherMillis);
            l = DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(resultMillis) + otherNanoRemainder);
        } else {
            l = DurationKt.access$durationOfMillis(RangesKt.coerceIn(resultMillis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
        }
        return l;
    }

    public static final boolean isNegative-impl(long arg0) {
        return arg0 < 0L;
    }

    public static final boolean isPositive-impl(long arg0) {
        return arg0 > 0L;
    }

    public static final boolean isInfinite-impl(long arg0) {
        return arg0 == INFINITE || arg0 == NEG_INFINITE;
    }

    public static final boolean isFinite-impl(long arg0) {
        return !Duration.isInfinite-impl(arg0);
    }

    public static final long getAbsoluteValue-UwyO8pc(long arg0) {
        return Duration.isNegative-impl(arg0) ? Duration.unaryMinus-UwyO8pc(arg0) : arg0;
    }

    public static int compareTo-LRDsOJo(long arg0, long other) {
        long compareBits = arg0 ^ other;
        if (compareBits < 0L || ((int)compareBits & 1) == 0) {
            return Intrinsics.compare(arg0, other);
        }
        boolean bl = false;
        bl = false;
        int r = ((int)arg0 & 1) - ((int)other & 1);
        return Duration.isNegative-impl(arg0) ? -r : r;
    }

    public int compareTo-LRDsOJo(long other) {
        return Duration.compareTo-LRDsOJo(this.rawValue, other);
    }

    public static final int getHoursComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (int)(Duration.getInWholeHours-impl(arg0) % (long)24);
    }

    public static final int getMinutesComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (int)(Duration.getInWholeMinutes-impl(arg0) % (long)60);
    }

    public static final int getSecondsComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (int)(Duration.getInWholeSeconds-impl(arg0) % (long)60);
    }

    public static final int getNanosecondsComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (Duration.isInMillis-impl(arg0) ? (int)DurationKt.access$millisToNanos(Duration.getValue-impl(arg0) % (long)1000) : (int)(Duration.getValue-impl(arg0) % (long)1000000000));
    }

    public static final long toLong-impl(long arg0, DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        long l = arg0;
        return l == INFINITE ? Long.MAX_VALUE : (l == NEG_INFINITE ? Long.MIN_VALUE : DurationUnitKt.convertDurationUnit(Duration.getValue-impl(arg0), Duration.getStorageUnit-impl(arg0), unit));
    }

    public static final long getInWholeDays-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.DAYS);
    }

    public static final long getInWholeHours-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.HOURS);
    }

    public static final long getInWholeMinutes-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.MINUTES);
    }

    public static final long getInWholeSeconds-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.SECONDS);
    }

    public static final long getInWholeMilliseconds-impl(long arg0) {
        return Duration.isInMillis-impl(arg0) && Duration.isFinite-impl(arg0) ? Duration.getValue-impl(arg0) : Duration.toLong-impl(arg0, DurationUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString-impl(long arg0) {
        String string;
        long l = arg0;
        if (l == 0L) {
            string = "0s";
        } else if (l == INFINITE) {
            string = "Infinity";
        } else if (l == NEG_INFINITE) {
            string = "-Infinity";
        } else {
            void nanoseconds;
            void seconds;
            void minutes;
            void hours;
            StringBuilder stringBuilder;
            boolean isNegative = Duration.isNegative-impl(arg0);
            StringBuilder $this$toString_impl_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (isNegative) {
                $this$toString_impl_u24lambda_u245.append('-');
            }
            long arg0$iv = Duration.getAbsoluteValue-UwyO8pc(arg0);
            boolean bl2 = false;
            int n = Duration.getNanosecondsComponent-impl(arg0$iv);
            int n2 = Duration.getSecondsComponent-impl(arg0$iv);
            int n3 = Duration.getMinutesComponent-impl(arg0$iv);
            int n4 = Duration.getHoursComponent-impl(arg0$iv);
            long days = Duration.getInWholeDays-impl(arg0$iv);
            boolean bl3 = false;
            boolean hasDays = days != 0L;
            boolean hasHours = hours != false;
            boolean hasMinutes = minutes != false;
            boolean hasSeconds = seconds != false || nanoseconds != false;
            int components = 0;
            if (hasDays) {
                $this$toString_impl_u24lambda_u245.append(days).append('d');
                ++components;
            }
            if (hasHours || hasDays && (hasMinutes || hasSeconds)) {
                if (components++ > 0) {
                    $this$toString_impl_u24lambda_u245.append(' ');
                }
                $this$toString_impl_u24lambda_u245.append((int)hours).append('h');
            }
            if (hasMinutes || hasSeconds && (hasHours || hasDays)) {
                if (components++ > 0) {
                    $this$toString_impl_u24lambda_u245.append(' ');
                }
                $this$toString_impl_u24lambda_u245.append((int)minutes).append('m');
            }
            if (hasSeconds) {
                if (components++ > 0) {
                    $this$toString_impl_u24lambda_u245.append(' ');
                }
                if (seconds != false || hasDays || hasHours || hasMinutes) {
                    Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u245, (int)seconds, (int)nanoseconds, 9, "s", false);
                } else if (nanoseconds >= 1000000) {
                    Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u245, (int)(nanoseconds / 1000000), (int)(nanoseconds % 1000000), 6, "ms", false);
                } else if (nanoseconds >= 1000) {
                    Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u245, (int)(nanoseconds / 1000), (int)(nanoseconds % 1000), 3, "us", false);
                } else {
                    $this$toString_impl_u24lambda_u245.append((int)nanoseconds).append("ns");
                }
            }
            if (isNegative && components > 1) {
                $this$toString_impl_u24lambda_u245.insert(1, '(').append(')');
            }
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        }
        return string;
    }

    public String toString() {
        return Duration.toString-impl(this.rawValue);
    }

    private static final void appendFractional-impl(long arg0, StringBuilder $this$appendFractional, int whole, int fractional, int fractionalSize, String unit, boolean isoZeroes) {
        $this$appendFractional.append(whole);
        if (fractional != 0) {
            int n;
            String fracString;
            block5: {
                $this$appendFractional.append('.');
                fracString = StringsKt.padStart(String.valueOf(fractional), fractionalSize, '0');
                CharSequence $this$indexOfLast$iv = fracString;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it != '0')) continue;
                        n = index$iv;
                        break block5;
                    } while (0 <= n2);
                }
                n = -1;
            }
            int nonZeroDigits = n + 1;
            if (!isoZeroes && nonZeroDigits < 3) {
                Intrinsics.checkNotNullExpressionValue($this$appendFractional.append(fracString, 0, nonZeroDigits), "append(...)");
            } else {
                Intrinsics.checkNotNullExpressionValue($this$appendFractional.append(fracString, 0, (nonZeroDigits + 2) / 3 * 3), "append(...)");
            }
        }
        $this$appendFractional.append(unit);
    }

    /*
     * WARNING - void declaration
     */
    public static final String toIsoString-impl(long arg0) {
        void minutes;
        boolean hasMinutes;
        void nanoseconds;
        void seconds;
        StringBuilder stringBuilder;
        StringBuilder $this$toIsoString_impl_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (Duration.isNegative-impl(arg0)) {
            $this$toIsoString_impl_u24lambda_u249.append('-');
        }
        $this$toIsoString_impl_u24lambda_u249.append("PT");
        long arg0$iv = Duration.getAbsoluteValue-UwyO8pc(arg0);
        boolean bl2 = false;
        int n = Duration.getNanosecondsComponent-impl(arg0$iv);
        int n2 = Duration.getSecondsComponent-impl(arg0$iv);
        int n3 = Duration.getMinutesComponent-impl(arg0$iv);
        long hours = Duration.getInWholeHours-impl(arg0$iv);
        boolean bl3 = false;
        long hours2 = hours;
        if (Duration.isInfinite-impl(arg0)) {
            hours2 = 9999999999999L;
        }
        boolean hasHours = hours2 != 0L;
        boolean hasSeconds = seconds != false || nanoseconds != false;
        boolean bl4 = hasMinutes = minutes != false || hasSeconds && hasHours;
        if (hasHours) {
            $this$toIsoString_impl_u24lambda_u249.append(hours2).append('H');
        }
        if (hasMinutes) {
            $this$toIsoString_impl_u24lambda_u249.append((int)minutes).append('M');
        }
        if (hasSeconds || !hasHours && !hasMinutes) {
            Duration.appendFractional-impl(arg0, $this$toIsoString_impl_u24lambda_u249, (int)seconds, (int)nanoseconds, 9, "S", true);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static int hashCode-impl(long arg0) {
        return Long.hashCode(arg0);
    }

    public int hashCode() {
        return Duration.hashCode-impl(this.rawValue);
    }

    public static boolean equals-impl(long arg0, Object other) {
        if (!(other instanceof Duration)) {
            return false;
        }
        long l = ((Duration)other).unbox-impl();
        return arg0 == l;
    }

    public boolean equals(Object other) {
        return Duration.equals-impl(this.rawValue, other);
    }

    private /* synthetic */ Duration(long rawValue) {
        this.rawValue = rawValue;
    }

    public static long constructor-impl(long rawValue) {
        long l = rawValue;
        if (DurationJvmKt.getDurationAssertionsEnabled()) {
            if (Duration.isInNanos-impl(l)) {
                long l2 = Duration.getValue-impl(l);
                if (!(-4611686018426999999L <= l2 ? l2 < 4611686018427000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l) + " ns is out of nanoseconds range"));
                }
            } else {
                long l3 = Duration.getValue-impl(l);
                if (!(-4611686018427387903L <= l3 ? l3 < 0x4000000000000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l) + " ms is out of milliseconds range"));
                }
                l3 = Duration.getValue-impl(l);
                boolean bl = -4611686018426L <= l3 ? l3 < 4611686018427L : false;
                if (bl) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l) + " ms is denormalized"));
                }
            }
        }
        return l;
    }

    public static final /* synthetic */ Duration box-impl(long v) {
        return new Duration(v);
    }

    public final /* synthetic */ long unbox-impl() {
        return this.rawValue;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Companion {
        private Companion() {
        }

        public final long getZERO-UwyO8pc() {
            return ZERO;
        }

        public final long getINFINITE-UwyO8pc() {
            return INFINITE;
        }

        public final long parseIsoString-UwyO8pc(String value) {
            long l;
            Intrinsics.checkNotNullParameter(value, "value");
            try {
                l = DurationKt.access$parseDuration(value, true);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid ISO duration string format: '" + value + "'.", e);
            }
            return l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

