/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.DeferredFragmentIdentifier;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.ResponseParser;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.JsonDataException;
import java.io.Closeable;
import java.util.Set;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.jvm.internal.Intrinsics;

public final class Operations {
    private static final ApolloException wrapIfNeeded(Throwable $this$wrapIfNeeded) {
        return $this$wrapIfNeeded instanceof ApolloException ? (ApolloException)$this$wrapIfNeeded : (ApolloException)new ApolloNetworkException("Error while reading JSON response", (Object)$this$wrapIfNeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <D extends Operation.Data> ApolloResponse<D> toApolloResponse(JsonReader $this$toApolloResponse, Operation<D> operation, UUID requestUuid, CustomScalarAdapters customScalarAdapters, Set<DeferredFragmentIdentifier> deferredFragmentIdentifiers) {
        ApolloResponse<D> apolloResponse;
        Throwable thrown$iv;
        block16: {
            Intrinsics.checkNotNullParameter($this$toApolloResponse, "<this>");
            Intrinsics.checkNotNullParameter(operation, "operation");
            Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
            Closeable $this$use$iv = $this$toApolloResponse;
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                ApolloResponse<D> apolloResponse2;
                JsonReader it = (JsonReader)$this$use$iv;
                boolean bl = false;
                try {
                    ApolloResponse<D> it2 = apolloResponse2 = ResponseParser.INSTANCE.parse($this$toApolloResponse, operation, requestUuid, customScalarAdapters, deferredFragmentIdentifiers);
                    boolean bl2 = false;
                    if ($this$toApolloResponse.peek() != JsonReader.Token.END_DOCUMENT) {
                        throw new JsonDataException("Expected END_DOCUMENT but was " + (Object)((Object)$this$toApolloResponse.peek()));
                    }
                }
                catch (Throwable throwable) {
                    UUID uUID = requestUuid;
                    if (uUID == null) {
                        boolean $i$f$uuid4 = false;
                        UUID uUID2 = UUID.randomUUID();
                        uUID = uUID2;
                        Intrinsics.checkNotNullExpressionValue(uUID2, "randomUUID(...)");
                    }
                    UUID uUID3 = uUID;
                    apolloResponse2 = new ApolloResponse.Builder<D>(operation, uUID3).exception(Operations.wrapIfNeeded(throwable)).isLast(true).build();
                }
                apolloResponse = apolloResponse2;
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    apolloResponse = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed(thrown$iv, t$iv2);
                        }
                    }
                }
            }
            try {
                $this$use$iv.close();
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        ApolloResponse<D> result$iv = apolloResponse;
        Throwable throwable = thrown$iv;
        if (throwable == null) return result$iv;
        throw throwable;
    }

    public static /* synthetic */ ApolloResponse toApolloResponse$default(JsonReader jsonReader, Operation operation, UUID uUID, CustomScalarAdapters customScalarAdapters, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            uUID = null;
        }
        if ((n & 4) != 0) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return Operations.toApolloResponse(jsonReader, operation, uUID, customScalarAdapters, set);
    }

    public static final <D extends Operation.Data> ApolloResponse<D> parseResponse(JsonReader $this$parseResponse, Operation<D> operation, UUID requestUuid, CustomScalarAdapters customScalarAdapters, Set<DeferredFragmentIdentifier> deferredFragmentIdentifiers) {
        ApolloResponse<D> apolloResponse;
        Intrinsics.checkNotNullParameter($this$parseResponse, "<this>");
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        try {
            apolloResponse = ResponseParser.INSTANCE.parse($this$parseResponse, operation, requestUuid, customScalarAdapters, deferredFragmentIdentifiers);
        }
        catch (Throwable throwable) {
            UUID uUID = requestUuid;
            if (uUID == null) {
                boolean $i$f$uuid4 = false;
                UUID uUID2 = UUID.randomUUID();
                uUID = uUID2;
                Intrinsics.checkNotNullExpressionValue(uUID2, "randomUUID(...)");
            }
            UUID uUID3 = uUID;
            apolloResponse = new ApolloResponse.Builder<D>(operation, uUID3).exception(Operations.wrapIfNeeded(throwable)).isLast(true).build();
        }
        return apolloResponse;
    }

    public static /* synthetic */ ApolloResponse parseResponse$default(JsonReader jsonReader, Operation operation, UUID uUID, CustomScalarAdapters customScalarAdapters, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            uUID = null;
        }
        if ((n & 4) != 0) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return Operations.parseResponse(jsonReader, operation, uUID, customScalarAdapters, set);
    }
}

