/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Adapter;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.json.-JsonWriters;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.api.json.MapJsonReader;
import com.apollographql.apollo.api.json.MapJsonWriter;
import kotlin.jvm.internal.Intrinsics;

public final class ObjectAdapter<T>
implements Adapter<T> {
    private final Adapter<T> wrappedAdapter;
    private final boolean buffered;

    public ObjectAdapter(Adapter<T> wrappedAdapter, boolean buffered) {
        Intrinsics.checkNotNullParameter(wrappedAdapter, "wrappedAdapter");
        this.wrappedAdapter = wrappedAdapter;
        this.buffered = buffered;
    }

    @Override
    public T fromJson(JsonReader reader, CustomScalarAdapters customScalarAdapters) {
        T t;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        JsonReader actualReader = this.buffered ? (JsonReader)MapJsonReader.Companion.buffer(reader) : reader;
        actualReader.beginObject();
        T it = t = this.wrappedAdapter.fromJson(actualReader, customScalarAdapters);
        boolean bl = false;
        actualReader.endObject();
        return t;
    }

    @Override
    public void toJson(JsonWriter writer, CustomScalarAdapters customScalarAdapters, T value) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        if (this.buffered && !(writer instanceof MapJsonWriter)) {
            MapJsonWriter mapWriter = new MapJsonWriter();
            mapWriter.beginObject();
            this.wrappedAdapter.toJson(mapWriter, customScalarAdapters, value);
            mapWriter.endObject();
            Object object = mapWriter.root();
            Intrinsics.checkNotNull(object);
            -JsonWriters.writeAny(writer, object);
        } else {
            writer.beginObject();
            this.wrappedAdapter.toJson(writer, customScalarAdapters, value);
            writer.endObject();
        }
    }
}

