/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class TopoNonIntermixSortGenerator
extends Generator {
    private static final int TOPO_QUEUED = 64;
    private final FIFORevQueue pending;
    private final int outputType;

    TopoNonIntermixSortGenerator(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s.firstParent);
        RevCommit c;
        this.pending = new FIFORevQueue(this.firstParent);
        this.outputType = s.outputType() | 8;
        s.shareFreeList(this.pending);
        while ((c = s.next()) != null) {
            if ((c.flags & 0x40) == 0) {
                for (RevCommit p : c.parents) {
                    ++p.inDegree;
                    if (this.firstParent) break;
                }
            }
            c.flags |= 0x40;
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        q.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        do {
            if ((c = this.pending.next()) != null) continue;
            return null;
        } while (c.inDegree > 0 || (c.flags & 0x40) == 0);
        for (RevCommit p : c.parents) {
            if (--p.inDegree == 0 && (p.flags & 0x40) != 0) {
                this.pending.unpop(p);
            }
            if (this.firstParent) break;
        }
        c.flags &= 0xFFFFFFBF;
        return c;
    }
}

