/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontRegistry;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.OS;

final class ScalingSWTFontRegistry
implements SWTFontRegistry {
    private ScaledFontContainer systemFontContainer;
    private Map<FontData, ScaledFontContainer> fontsKeyMap = new HashMap<FontData, ScaledFontContainer>();
    private Map<Long, ScaledFontContainer> fontHandlesKeyMap = new HashMap<Long, ScaledFontContainer>();
    private Device device;

    ScalingSWTFontRegistry(Device device) {
        this.device = device;
        this.systemFontContainer = new ScaledSystemFontContainer();
    }

    @Override
    public Font getSystemFont(int zoom) {
        return this.systemFontContainer.getScaledFont(zoom);
    }

    @Override
    public Font getFont(FontData fontData, int zoom) {
        ScaledFontContainer container;
        if (this.fontsKeyMap.containsKey(fontData)) {
            container = this.fontsKeyMap.get(fontData);
        } else {
            FontData clonedFontData = new FontData(fontData);
            container = new ScaledCustomFontContainer(clonedFontData);
        }
        return container.getScaledFont(zoom);
    }

    @Override
    public Font getFont(long fontHandle, int zoom) {
        if (this.fontHandlesKeyMap.containsKey(fontHandle)) {
            return this.fontHandlesKeyMap.get(fontHandle).getScaledFont(zoom);
        }
        return Font.win32_new(this.device, fontHandle, zoom);
    }

    @Override
    public void dispose() {
        this.fontsKeyMap.values().forEach(ScaledFontContainer::dispose);
        this.fontsKeyMap.clear();
    }

    private class ScaledSystemFontContainer
    extends ScaledFontContainer {
        private ScaledSystemFontContainer() {
        }

        @Override
        protected Font createFont(int zoom) {
            long newHandle = this.createSystemFontHandle(zoom);
            return Font.win32_new(ScalingSWTFontRegistry.this.device, newHandle, zoom);
        }

        private long createSystemFontHandle(int zoom) {
            long hFont = 0L;
            NONCLIENTMETRICS info = new NONCLIENTMETRICS();
            info.cbSize = NONCLIENTMETRICS.sizeof;
            if (ScaledSystemFontContainer.fetchSystemParametersInfo(info, zoom)) {
                LOGFONT logFont = info.lfMessageFont;
                hFont = OS.CreateFontIndirect(logFont);
            }
            if (hFont == 0L) {
                hFont = OS.GetStockObject(17);
            }
            if (hFont == 0L) {
                hFont = OS.GetStockObject(13);
            }
            return hFont;
        }

        private static boolean fetchSystemParametersInfo(NONCLIENTMETRICS info, int targetZoom) {
            return OS.SystemParametersInfoForDpi(41, NONCLIENTMETRICS.sizeof, info, 0, DPIUtil.mapZoomToDPI(targetZoom));
        }

        @Override
        protected void dispose() {
        }
    }

    private abstract class ScaledFontContainer {
        protected Map<Integer, Font> scaledFonts = new HashMap<Integer, Font>();

        private ScaledFontContainer() {
        }

        private Font getScaledFont(int zoom) {
            if (this.scaledFonts.containsKey(zoom)) {
                Font font = this.scaledFonts.get(zoom);
                if (font.isDisposed()) {
                    this.scaledFonts.remove(zoom);
                    return this.createAndCacheFont(zoom);
                }
                return font;
            }
            return this.createAndCacheFont(zoom);
        }

        private Font createAndCacheFont(int zoom) {
            Font newFont = this.createFont(zoom);
            FontData clonedFontData = new FontData(newFont.getFontData()[0]);
            ScalingSWTFontRegistry.this.fontsKeyMap.put(clonedFontData, this);
            ScalingSWTFontRegistry.this.fontHandlesKeyMap.put(Font.win32_getHandle(newFont), this);
            this.scaledFonts.put(zoom, newFont);
            return newFont;
        }

        protected abstract Font createFont(int var1);

        protected abstract void dispose();
    }

    private class ScaledCustomFontContainer
    extends ScaledFontContainer {
        private final FontData fontData;

        ScaledCustomFontContainer(FontData fontData) {
            this.fontData = fontData;
        }

        @Override
        protected Font createFont(int zoom) {
            return Font.win32_new(ScalingSWTFontRegistry.this.device, this.fontData, zoom);
        }

        @Override
        protected void dispose() {
            for (Font font : this.scaledFonts.values()) {
                font.dispose();
            }
        }
    }
}

