/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.Serializable;
import org.eclipse.swt.graphics.RoundingMode;
import org.eclipse.swt.widgets.Monitor;

public sealed class Point
implements Serializable,
Cloneable {
    public int x;
    public int y;
    static final long serialVersionUID = 3257002163938146354L;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Point)) {
            return false;
        }
        Point other = (Point)object;
        return other.x == this.x && other.y == this.y;
    }

    public int hashCode() {
        return this.x ^ this.y;
    }

    public String toString() {
        return "Point {" + this.x + ", " + this.y + "}";
    }

    public Point clone() {
        return new Point(this.x, this.y);
    }

    public static final class WithMonitor
    extends OfFloat {
        private static final long serialVersionUID = 6077427420686999194L;
        private final Monitor monitor;

        public WithMonitor(int x, int y, Monitor monitor) {
            super(x, y);
            this.monitor = monitor;
        }

        private WithMonitor(float x, float y, Monitor monitor) {
            super(x, y);
            this.monitor = monitor;
        }

        public Monitor getMonitor() {
            return this.monitor;
        }

        @Override
        public WithMonitor clone() {
            return new WithMonitor(this.getX(), this.getY(), this.monitor);
        }
    }

    public static sealed class OfFloat
    extends Point
    permits WithMonitor {
        private static final long serialVersionUID = -1862062276431597053L;
        public float residualX;
        public float residualY;
        private final RoundingMode roundingMode;

        public OfFloat(int x, int y) {
            super(x, y);
            this.roundingMode = RoundingMode.ROUND;
        }

        public OfFloat(float x, float y) {
            this(x, y, RoundingMode.ROUND);
        }

        public OfFloat(float x, float y, RoundingMode roundingMode) {
            super(roundingMode.round(x), roundingMode.round(y));
            this.roundingMode = roundingMode;
            this.residualX = x - (float)this.x;
            this.residualY = y - (float)this.y;
        }

        public float getX() {
            return (float)this.x + this.residualX;
        }

        public float getY() {
            return (float)this.y + this.residualY;
        }

        public void setX(float x) {
            this.x = this.roundingMode.round(x);
            this.residualX = x - (float)this.x;
        }

        public void setY(float y) {
            this.y = this.roundingMode.round(y);
            this.residualY = y - (float)this.y;
        }

        @Override
        public OfFloat clone() {
            return new OfFloat(this.getX(), this.getY(), this.roundingMode);
        }

        public static OfFloat from(Point point) {
            if (point instanceof OfFloat) {
                OfFloat pointOfFloat = (OfFloat)point;
                return pointOfFloat.clone();
            }
            return new OfFloat(point.x, point.y);
        }
    }
}

