/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;

public class Heading
extends Block
implements AnchorRefTarget {
    protected int level;
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected String anchorRefId = "";

    public void getAstExtra(StringBuilder out) {
        Heading.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (BasedSequence)this.text, (BasedSequence)this.closingMarker, (String)"text");
    }

    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    @Override
    public String getAnchorRefText() {
        return new TextCollectingVisitor().collectAndGetText((Node)this).trim();
    }

    @Override
    public BasedSequence[] getAnchorRefSegments() {
        return new TextCollectingVisitor().collectAndGetSegments((Node)this);
    }

    @Override
    public String getAnchorRefId() {
        return this.anchorRefId;
    }

    @Override
    public void setAnchorRefId(String anchorRefId) {
        this.anchorRefId = anchorRefId;
    }

    public Heading() {
    }

    public Heading(BasedSequence chars) {
        super(chars);
    }

    public Heading(BasedSequence chars, List<BasedSequence> segments) {
        super(chars, segments);
    }

    public Heading(BlockContent blockContent) {
        super(blockContent);
    }

    public boolean isAtxHeading() {
        return this.openingMarker != BasedSequence.NULL;
    }

    public boolean isSetextHeading() {
        return this.openingMarker == BasedSequence.NULL && this.closingMarker != BasedSequence.NULL;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker == null ? BasedSequence.NULL : openingMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text == null ? BasedSequence.NULL : text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker == null ? BasedSequence.NULL : closingMarker;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

