/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableReflogReader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.transport.ReceiveCommand;

public abstract class ReftableDatabase {
    private final ReentrantLock lock = new ReentrantLock(true);
    private Reftable mergedTables;

    protected abstract MergedReftable openMergedReftable() throws IOException;

    public long nextUpdateIndex() throws IOException {
        this.lock.lock();
        try {
            long l = this.reader().maxUpdateIndex() + 1L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReflogReader getReflogReader(String refname) throws IOException {
        this.lock.lock();
        try {
            ReftableReflogReader reftableReflogReader = new ReftableReflogReader(this.lock, this.reader(), refname);
            return reftableReflogReader;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static ReceiveCommand toCommand(Ref oldRef, Ref newRef) {
        String name;
        ObjectId oldId = ReftableDatabase.toId(oldRef);
        ObjectId newId = ReftableDatabase.toId(newRef);
        String string = name = oldRef != null ? oldRef.getName() : newRef.getName();
        if (oldRef != null && oldRef.isSymbolic()) {
            if (newRef != null) {
                if (newRef.isSymbolic()) {
                    return ReceiveCommand.link(oldRef.getTarget().getName(), newRef.getTarget().getName(), name);
                }
                return ReceiveCommand.unlink(oldRef.getTarget().getName(), newId, name);
            }
            return ReceiveCommand.unlink(oldRef.getTarget().getName(), ObjectId.zeroId(), name);
        }
        if (newRef != null && newRef.isSymbolic()) {
            if (oldRef != null) {
                if (oldRef.isSymbolic()) {
                    return ReceiveCommand.link(oldRef.getTarget().getName(), newRef.getTarget().getName(), name);
                }
                return ReceiveCommand.link(oldId, newRef.getTarget().getName(), name);
            }
            return ReceiveCommand.link(ObjectId.zeroId(), newRef.getTarget().getName(), name);
        }
        return new ReceiveCommand(oldId, newId, name);
    }

    private static ObjectId toId(Ref ref) {
        ObjectId id;
        if (ref != null && (id = ref.getObjectId()) != null) {
            return id;
        }
        return ObjectId.zeroId();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    private Reftable reader() throws IOException {
        if (!this.lock.isLocked()) {
            throw new IllegalStateException("must hold lock to access merged table");
        }
        if (this.mergedTables == null) {
            this.mergedTables = this.openMergedReftable();
        }
        return this.mergedTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameConflicting(String refName, TreeSet<String> added, Set<String> deleted) throws IOException {
        this.lock.lock();
        try {
            Object prefix;
            Reftable table = this.reader();
            int lastSlash = refName.lastIndexOf(47);
            while (0 < lastSlash) {
                prefix = refName.substring(0, lastSlash);
                if (!deleted.contains(prefix) && (table.hasRef((String)prefix) || added.contains(prefix))) {
                    boolean bl = true;
                    return bl;
                }
                lastSlash = refName.lastIndexOf(47, lastSlash - 1);
            }
            prefix = refName + "/";
            RefCursor c = table.seekRefsWithPrefix((String)prefix);
            while (c.next()) {
                if (deleted.contains(c.getRef().getName())) continue;
                boolean bl = true;
                return bl;
            }
            String it = added.ceiling(refName + "/");
            if (it != null && it.startsWith((String)prefix)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Ref exactRef(String name) throws IOException {
        this.lock.lock();
        try {
            Reftable table = this.reader();
            Ref ref = table.exactRef(name);
            if (ref != null && ref.isSymbolic()) {
                Ref ref2 = table.resolve(ref);
                return ref2;
            }
            Ref ref3 = ref;
            return ref3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ref> getRefsByPrefix(String prefix) throws IOException {
        ArrayList<Ref> all = new ArrayList<Ref>();
        this.lock.lock();
        try {
            Reftable table = this.reader();
            try (RefCursor rc = "".equals(prefix) ? table.allRefs() : table.seekRefsWithPrefix(prefix);){
                while (rc.next()) {
                    Ref ref = table.resolve(rc.getRef());
                    if (ref == null || ref.getObjectId() == null) continue;
                    all.add(ref);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return Collections.unmodifiableList(all);
    }

    public boolean hasFastTipsWithSha1() throws IOException {
        this.lock.lock();
        try {
            boolean bl = this.reader().hasObjectMap();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Ref> getTipsWithSha1(ObjectId id) throws IOException {
        this.lock.lock();
        try {
            RefCursor cursor = this.reader().byObjectId(id);
            HashSet<Ref> refs = new HashSet<Ref>();
            while (cursor.next()) {
                refs.add(cursor.getRef());
            }
            HashSet<Ref> hashSet = refs;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearCache() {
        this.lock.lock();
        try {
            this.mergedTables = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

