/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGBA;

public interface ImageColorTransformer {
    public static final String IMAGE_DISABLEMENT_ALGORITHM_GRAYED = "grayed";
    public static final String IMAGE_DISABLEMENT_ALGORITHM_GTK = "gtk";
    public static final String IMAGE_DISABLEMENT_ALGORITHM_DESATURATED = "desaturated";
    public static final String IMAGE_DISABLEMENT_ALGORITHM;
    public static final ImageColorTransformer DEFAULT_DISABLED_IMAGE_TRANSFORMER;

    public RGBA adaptPixelValue(int var1, int var2, int var3, int var4);

    public static ImageColorTransformer forSaturationBrightness(float saturationFactor, float brightnessFactor, float alphaFactor) {
        return (red, green, blue, alpha) -> {
            float[] hsba = new RGBA(red, green, blue, alpha).getHSBA();
            float hue = hsba[0];
            float saturation = Math.min(saturationFactor * hsba[1], 1.0f);
            float brightness = Math.min(brightnessFactor * hsba[2], 1.0f);
            float alphaResult = Math.min(alphaFactor * hsba[3], 255.0f);
            return new RGBA(hue, saturation, brightness, alphaResult);
        };
    }

    public static ImageColorTransformer forRGB(float redFactor, float greenFactor, float blueFactor, float alphaFactor) {
        return (red, green, blue, alpha) -> {
            int redResult = (int)Math.min(redFactor * (float)red, 255.0f);
            int greenResult = (int)Math.min(greenFactor * (float)green, 255.0f);
            int blueResult = (int)Math.min(blueFactor * (float)blue, 255.0f);
            int alphaResult = (int)Math.min(alphaFactor * (float)alpha, 255.0f);
            return new RGBA(redResult, greenResult, blueResult, alphaResult);
        };
    }

    public static ImageColorTransformer forIntensityThreshold(Device device) {
        RGBA lowIntensity = device.getSystemColor(18).getRGBA();
        RGBA highIntensity = device.getSystemColor(22).getRGBA();
        return (red, green, blue, alpha) -> {
            int intensity = red * red + green * green + blue * blue;
            RGBA usedGraytone = intensity < 98304 ? lowIntensity : highIntensity;
            return new RGBA(usedGraytone.rgb.red, usedGraytone.rgb.green, usedGraytone.rgb.blue, alpha);
        };
    }

    public static ImageColorTransformer forGrayscaledContrastBrightness(float contrast, float brightness) {
        return (red, green, blue, alpha) -> {
            int grayValue = Math.min((77 * red + 151 * green + 28 * blue) / 255, 255);
            int resultValue = (int)Math.min(Math.max(contrast * ((float)grayValue * brightness - 128.0f) + 128.0f, 0.0f), 255.0f);
            return new RGBA(resultValue, resultValue, resultValue, alpha);
        };
    }

    static {
        DEFAULT_DISABLED_IMAGE_TRANSFORMER = switch (IMAGE_DISABLEMENT_ALGORITHM = System.getProperty("org.eclipse.swt.image.disablement", IMAGE_DISABLEMENT_ALGORITHM_GRAYED).strip()) {
            case IMAGE_DISABLEMENT_ALGORITHM_GTK -> ImageColorTransformer.forRGB(0.5f, 0.5f, 0.5f, 0.5f);
            case IMAGE_DISABLEMENT_ALGORITHM_DESATURATED -> ImageColorTransformer.forSaturationBrightness(0.2f, 0.9f, 0.5f);
            default -> ImageColorTransformer.forGrayscaledContrastBrightness(0.2f, 2.9f);
        };
    }
}

