/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Source;
import okio.Timeout;
import okio.internal.-Buffer;

public final class RealBufferedSource
implements BufferedSource {
    public final Source source;
    public final Buffer bufferField;
    public boolean closed;

    public RealBufferedSource(Source source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        this.source = source2;
        this.bufferField = new Buffer();
    }

    @Override
    public Buffer getBuffer() {
        boolean $i$f$getBuffer = false;
        return this.bufferField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long read(Buffer sink2, long byteCount) {
        boolean $i$f$getBuffer;
        RealBufferedSource this_$iv$iv;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        RealBufferedSource $this$commonRead$iv = this;
        boolean $i$f$commonRead = false;
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require--RealBufferedSource$commonRead$1$iv22 = false;
            String $i$a$-require--RealBufferedSource$commonRead$1$iv22 = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException($i$a$-require--RealBufferedSource$commonRead$1$iv22.toString());
        }
        if (!(!$this$commonRead$iv.closed)) {
            boolean $i$a$-check--RealBufferedSource$commonRead$2$iv22 = false;
            String $i$a$-check--RealBufferedSource$commonRead$2$iv22 = "closed";
            throw new IllegalStateException($i$a$-check--RealBufferedSource$commonRead$2$iv22.toString());
        }
        RealBufferedSource this_$iv$iv2 = $this$commonRead$iv;
        boolean $i$f$getBuffer2 = false;
        if (this_$iv$iv2.bufferField.size() == 0L) {
            this_$iv$iv = $this$commonRead$iv;
            $i$f$getBuffer = false;
            long read$iv = $this$commonRead$iv.source.read(this_$iv$iv.bufferField, 8192L);
            if (read$iv == -1L) {
                return -1L;
            }
        }
        this_$iv$iv = $this$commonRead$iv;
        $i$f$getBuffer = false;
        long l = this_$iv$iv.bufferField.size();
        long toRead$iv = Math.min(byteCount, l);
        this_$iv$iv = $this$commonRead$iv;
        $i$f$getBuffer = false;
        long l2 = this_$iv$iv.bufferField.read(sink2, toRead$iv);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean exhausted() {
        RealBufferedSource $this$commonExhausted$iv = this;
        boolean $i$f$commonExhausted = false;
        if (!(!$this$commonExhausted$iv.closed)) {
            boolean $i$a$-check--RealBufferedSource$commonExhausted$1$iv22 = false;
            String $i$a$-check--RealBufferedSource$commonExhausted$1$iv22 = "closed";
            throw new IllegalStateException($i$a$-check--RealBufferedSource$commonExhausted$1$iv22.toString());
        }
        RealBufferedSource this_$iv$iv = $this$commonExhausted$iv;
        boolean $i$f$getBuffer = false;
        if (!this_$iv$iv.bufferField.exhausted()) return false;
        this_$iv$iv = $this$commonExhausted$iv;
        $i$f$getBuffer = false;
        if ($this$commonExhausted$iv.source.read(this_$iv$iv.bufferField, 8192L) != -1L) return false;
        return true;
    }

    @Override
    public void require(long byteCount) {
        RealBufferedSource $this$commonRequire$iv = this;
        boolean $i$f$commonRequire = false;
        if (!$this$commonRequire$iv.request(byteCount)) {
            throw new EOFException();
        }
    }

    @Override
    public boolean request(long byteCount) {
        boolean bl;
        block4: {
            block3: {
                RealBufferedSource this_$iv$iv;
                RealBufferedSource $this$commonRequest$iv = this;
                boolean $i$f$commonRequest = false;
                if (!(byteCount >= 0L)) {
                    boolean $i$a$-require--RealBufferedSource$commonRequest$1$iv22 = false;
                    String $i$a$-require--RealBufferedSource$commonRequest$1$iv22 = "byteCount < 0: " + byteCount;
                    throw new IllegalArgumentException($i$a$-require--RealBufferedSource$commonRequest$1$iv22.toString());
                }
                if (!(!$this$commonRequest$iv.closed)) {
                    boolean $i$a$-check--RealBufferedSource$commonRequest$2$iv22 = false;
                    String $i$a$-check--RealBufferedSource$commonRequest$2$iv22 = "closed";
                    throw new IllegalStateException($i$a$-check--RealBufferedSource$commonRequest$2$iv22.toString());
                }
                do {
                    this_$iv$iv = $this$commonRequest$iv;
                    boolean $i$f$getBuffer = false;
                    if (this_$iv$iv.bufferField.size() >= byteCount) break block3;
                    this_$iv$iv = $this$commonRequest$iv;
                    $i$f$getBuffer = false;
                } while ($this$commonRequest$iv.source.read(this_$iv$iv.bufferField, 8192L) != -1L);
                bl = false;
                break block4;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public byte readByte() {
        RealBufferedSource $this$commonReadByte$iv = this;
        boolean $i$f$commonReadByte = false;
        $this$commonReadByte$iv.require(1L);
        RealBufferedSource this_$iv$iv = $this$commonReadByte$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readByte();
    }

    @Override
    public ByteString readByteString(long byteCount) {
        RealBufferedSource $this$commonReadByteString$iv = this;
        boolean $i$f$commonReadByteString = false;
        $this$commonReadByteString$iv.require(byteCount);
        RealBufferedSource this_$iv$iv = $this$commonReadByteString$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readByteString(byteCount);
    }

    @Override
    public int select(Options options) {
        int n;
        Intrinsics.checkNotNullParameter(options, "options");
        RealBufferedSource $this$commonSelect$iv = this;
        boolean $i$f$commonSelect = false;
        if (!(!$this$commonSelect$iv.closed)) {
            boolean $i$a$-check--RealBufferedSource$commonSelect$1$iv22 = false;
            String $i$a$-check--RealBufferedSource$commonSelect$1$iv22 = "closed";
            throw new IllegalStateException($i$a$-check--RealBufferedSource$commonSelect$1$iv22.toString());
        }
        block4: while (true) {
            RealBufferedSource this_$iv$iv = $this$commonSelect$iv;
            boolean $i$f$getBuffer = false;
            int index$iv = -Buffer.selectPrefix(this_$iv$iv.bufferField, options, true);
            switch (index$iv) {
                case -1: {
                    n = -1;
                    break block4;
                }
                case -2: {
                    RealBufferedSource this_$iv$iv2 = $this$commonSelect$iv;
                    boolean $i$f$getBuffer2 = false;
                    if ($this$commonSelect$iv.source.read(this_$iv$iv2.bufferField, 8192L) != -1L) continue block4;
                    n = -1;
                    break block4;
                }
                default: {
                    int selectedSize$iv = options.getByteStrings$okio()[index$iv].size();
                    RealBufferedSource this_$iv$iv3 = $this$commonSelect$iv;
                    boolean $i$f$getBuffer3 = false;
                    this_$iv$iv3.bufferField.skip(selectedSize$iv);
                    n = index$iv;
                    break block4;
                }
            }
            break;
        }
        return n;
    }

    @Override
    public byte[] readByteArray(long byteCount) {
        RealBufferedSource $this$commonReadByteArray$iv = this;
        boolean $i$f$commonReadByteArray = false;
        $this$commonReadByteArray$iv.require(byteCount);
        RealBufferedSource this_$iv$iv = $this$commonReadByteArray$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readByteArray(byteCount);
    }

    @Override
    public void readFully(byte[] sink2) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        RealBufferedSource $this$commonReadFully$iv = this;
        boolean $i$f$commonReadFully = false;
        try {
            $this$commonReadFully$iv.require(sink2.length);
        }
        catch (EOFException e$iv) {
            int offset$iv = 0;
            while (true) {
                RealBufferedSource this_$iv$iv = $this$commonReadFully$iv;
                boolean $i$f$getBuffer = false;
                if (this_$iv$iv.bufferField.size() <= 0L) break;
                RealBufferedSource this_$iv$iv2 = $this$commonReadFully$iv;
                boolean $i$f$getBuffer2 = false;
                this_$iv$iv2 = $this$commonReadFully$iv;
                $i$f$getBuffer2 = false;
                int read$iv = this_$iv$iv2.bufferField.read(sink2, offset$iv, (int)this_$iv$iv2.bufferField.size());
                if (read$iv == -1) {
                    throw new AssertionError();
                }
                offset$iv += read$iv;
            }
            throw e$iv;
        }
        RealBufferedSource this_$iv$iv = $this$commonReadFully$iv;
        boolean $i$f$getBuffer = false;
        this_$iv$iv.bufferField.readFully(sink2);
    }

    @Override
    public int read(ByteBuffer sink2) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        RealBufferedSource this_$iv = this;
        boolean $i$f$getBuffer = false;
        if (this_$iv.bufferField.size() == 0L) {
            RealBufferedSource this_$iv2 = this;
            boolean $i$f$getBuffer2 = false;
            long read = this.source.read(this_$iv2.bufferField, 8192L);
            if (read == -1L) {
                return -1;
            }
        }
        this_$iv = this;
        $i$f$getBuffer = false;
        return this_$iv.bufferField.read(sink2);
    }

    @Override
    public void readFully(Buffer sink2, long byteCount) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        RealBufferedSource $this$commonReadFully$iv = this;
        boolean $i$f$commonReadFully = false;
        try {
            $this$commonReadFully$iv.require(byteCount);
        }
        catch (EOFException e$iv) {
            RealBufferedSource this_$iv$iv = $this$commonReadFully$iv;
            boolean $i$f$getBuffer = false;
            sink2.writeAll(this_$iv$iv.bufferField);
            throw e$iv;
        }
        RealBufferedSource this_$iv$iv = $this$commonReadFully$iv;
        boolean $i$f$getBuffer = false;
        this_$iv$iv.bufferField.readFully(sink2, byteCount);
    }

    @Override
    public String readString(Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        RealBufferedSource this_$iv = this;
        boolean $i$f$getBuffer = false;
        this_$iv.bufferField.writeAll(this.source);
        this_$iv = this;
        $i$f$getBuffer = false;
        return this_$iv.bufferField.readString(charset);
    }

    @Override
    public String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public String readUtf8LineStrict(long limit) {
        void a$iv$iv;
        String string;
        RealBufferedSource $this$commonReadUtf8LineStrict$iv = this;
        boolean $i$f$commonReadUtf8LineStrict = false;
        if (!(limit >= 0L)) {
            boolean bl = false;
            String string2 = "limit < 0: " + limit;
            throw new IllegalArgumentException(string2.toString());
        }
        long scanLength$iv = limit == Long.MAX_VALUE ? Long.MAX_VALUE : limit + 1L;
        long newline$iv = $this$commonReadUtf8LineStrict$iv.indexOf((byte)10, 0L, scanLength$iv);
        if (newline$iv != -1L) {
            RealBufferedSource this_$iv$iv = $this$commonReadUtf8LineStrict$iv;
            boolean $i$f$getBuffer = false;
            string = -Buffer.readUtf8Line(this_$iv$iv.bufferField, newline$iv);
            return string;
        }
        if (scanLength$iv < Long.MAX_VALUE && $this$commonReadUtf8LineStrict$iv.request(scanLength$iv)) {
            RealBufferedSource this_$iv$iv = $this$commonReadUtf8LineStrict$iv;
            boolean $i$f$getBuffer = false;
            if (this_$iv$iv.bufferField.getByte(scanLength$iv - 1L) == 13 && $this$commonReadUtf8LineStrict$iv.request(scanLength$iv + 1L)) {
                this_$iv$iv = $this$commonReadUtf8LineStrict$iv;
                $i$f$getBuffer = false;
                if (this_$iv$iv.bufferField.getByte(scanLength$iv) == 10) {
                    this_$iv$iv = $this$commonReadUtf8LineStrict$iv;
                    $i$f$getBuffer = false;
                    string = -Buffer.readUtf8Line(this_$iv$iv.bufferField, scanLength$iv);
                    return string;
                }
            }
        }
        Buffer data$iv = new Buffer();
        RealBufferedSource this_$iv$iv22 = $this$commonReadUtf8LineStrict$iv;
        boolean $i$f$getBuffer = false;
        int this_$iv$iv22 = 32;
        RealBufferedSource this_$iv$iv = $this$commonReadUtf8LineStrict$iv;
        boolean $i$f$getBuffer2 = false;
        long b$iv$iv = this_$iv$iv.bufferField.size();
        boolean $i$f$minOf = false;
        this_$iv$iv22.bufferField.copyTo(data$iv, 0L, Math.min((long)a$iv$iv, b$iv$iv));
        RealBufferedSource this_$iv$iv3 = $this$commonReadUtf8LineStrict$iv;
        $i$f$getBuffer = false;
        throw new EOFException("\\n not found: limit=" + Math.min(this_$iv$iv3.bufferField.size(), limit) + " content=" + data$iv.readByteString().hex() + '\u2026');
    }

    @Override
    public short readShort() {
        RealBufferedSource $this$commonReadShort$iv = this;
        boolean $i$f$commonReadShort = false;
        $this$commonReadShort$iv.require(2L);
        RealBufferedSource this_$iv$iv = $this$commonReadShort$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readShort();
    }

    public short readShortLe() {
        RealBufferedSource $this$commonReadShortLe$iv = this;
        boolean $i$f$commonReadShortLe = false;
        $this$commonReadShortLe$iv.require(2L);
        RealBufferedSource this_$iv$iv = $this$commonReadShortLe$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readShortLe();
    }

    @Override
    public int readInt() {
        RealBufferedSource $this$commonReadInt$iv = this;
        boolean $i$f$commonReadInt = false;
        $this$commonReadInt$iv.require(4L);
        RealBufferedSource this_$iv$iv = $this$commonReadInt$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readInt();
    }

    public int readIntLe() {
        RealBufferedSource $this$commonReadIntLe$iv = this;
        boolean $i$f$commonReadIntLe = false;
        $this$commonReadIntLe$iv.require(4L);
        RealBufferedSource this_$iv$iv = $this$commonReadIntLe$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readIntLe();
    }

    @Override
    public long readLong() {
        RealBufferedSource $this$commonReadLong$iv = this;
        boolean $i$f$commonReadLong = false;
        $this$commonReadLong$iv.require(8L);
        RealBufferedSource this_$iv$iv = $this$commonReadLong$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readLong();
    }

    @Override
    public long readDecimalLong() {
        RealBufferedSource $this$commonReadDecimalLong$iv = this;
        boolean $i$f$commonReadDecimalLong = false;
        $this$commonReadDecimalLong$iv.require(1L);
        long pos$iv = 0L;
        while ($this$commonReadDecimalLong$iv.request(pos$iv + 1L)) {
            RealBufferedSource this_$iv$iv = $this$commonReadDecimalLong$iv;
            boolean $i$f$getBuffer = false;
            byte b$iv = this_$iv$iv.bufferField.getByte(pos$iv);
            if (!(b$iv >= 48 && b$iv <= 57 || pos$iv == 0L && b$iv == 45)) {
                if (pos$iv != 0L) break;
                StringBuilder stringBuilder = new StringBuilder().append("Expected a digit or '-' but was 0x");
                String string = Integer.toString(b$iv, CharsKt.checkRadix(16));
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                throw new NumberFormatException(stringBuilder.append(string).toString());
            }
            ++pos$iv;
        }
        RealBufferedSource this_$iv$iv = $this$commonReadDecimalLong$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readDecimalLong();
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        RealBufferedSource $this$commonReadHexadecimalUnsignedLong$iv = this;
        boolean $i$f$commonReadHexadecimalUnsignedLong = false;
        $this$commonReadHexadecimalUnsignedLong$iv.require(1L);
        int pos$iv = 0;
        while ($this$commonReadHexadecimalUnsignedLong$iv.request(pos$iv + 1)) {
            RealBufferedSource this_$iv$iv = $this$commonReadHexadecimalUnsignedLong$iv;
            boolean $i$f$getBuffer = false;
            byte b$iv = this_$iv$iv.bufferField.getByte(pos$iv);
            if (!(b$iv >= 48 && b$iv <= 57 || b$iv >= 97 && b$iv <= 102 || b$iv >= 65 && b$iv <= 70)) {
                if (pos$iv != 0) break;
                StringBuilder stringBuilder = new StringBuilder().append("Expected leading [0-9a-fA-F] character but was 0x");
                String string = Integer.toString(b$iv, CharsKt.checkRadix(16));
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                throw new NumberFormatException(stringBuilder.append(string).toString());
            }
            ++pos$iv;
        }
        RealBufferedSource this_$iv$iv = $this$commonReadHexadecimalUnsignedLong$iv;
        boolean $i$f$getBuffer = false;
        return this_$iv$iv.bufferField.readHexadecimalUnsignedLong();
    }

    @Override
    public void skip(long byteCount) {
        long toSkip$iv;
        RealBufferedSource $this$commonSkip$iv = this;
        boolean $i$f$commonSkip = false;
        if (!(!$this$commonSkip$iv.closed)) {
            boolean $i$a$-check--RealBufferedSource$commonSkip$1$iv22 = false;
            String $i$a$-check--RealBufferedSource$commonSkip$1$iv22 = "closed";
            throw new IllegalStateException($i$a$-check--RealBufferedSource$commonSkip$1$iv22.toString());
        }
        for (long byteCount$iv = byteCount; byteCount$iv > 0L; byteCount$iv -= toSkip$iv) {
            RealBufferedSource this_$iv$iv = $this$commonSkip$iv;
            boolean $i$f$getBuffer = false;
            if (this_$iv$iv.bufferField.size() == 0L) {
                this_$iv$iv = $this$commonSkip$iv;
                $i$f$getBuffer = false;
                if ($this$commonSkip$iv.source.read(this_$iv$iv.bufferField, 8192L) == -1L) {
                    throw new EOFException();
                }
            }
            RealBufferedSource this_$iv$iv2 = $this$commonSkip$iv;
            boolean $i$f$getBuffer2 = false;
            long l = this_$iv$iv2.bufferField.size();
            toSkip$iv = Math.min(byteCount$iv, l);
            this_$iv$iv2 = $this$commonSkip$iv;
            $i$f$getBuffer2 = false;
            this_$iv$iv2.bufferField.skip(toSkip$iv);
        }
    }

    public long indexOf(byte b) {
        return this.indexOf(b, 0L, Long.MAX_VALUE);
    }

    public long indexOf(byte b, long fromIndex, long toIndex) {
        long l;
        block6: {
            RealBufferedSource $this$commonIndexOf$iv = this;
            boolean $i$f$commonIndexOf = false;
            long fromIndex$iv = 0L;
            fromIndex$iv = fromIndex;
            if (!(!$this$commonIndexOf$iv.closed)) {
                boolean $i$a$-check--RealBufferedSource$commonIndexOf$1$iv22 = false;
                String $i$a$-check--RealBufferedSource$commonIndexOf$1$iv22 = "closed";
                throw new IllegalStateException($i$a$-check--RealBufferedSource$commonIndexOf$1$iv22.toString());
            }
            if (!(0L <= fromIndex$iv ? fromIndex$iv <= toIndex : false)) {
                boolean bl = false;
                String string = "fromIndex=" + fromIndex$iv + " toIndex=" + toIndex;
                throw new IllegalArgumentException(string.toString());
            }
            while (fromIndex$iv < toIndex) {
                long lastBufferSize$iv;
                block8: {
                    block7: {
                        RealBufferedSource this_$iv$iv = $this$commonIndexOf$iv;
                        boolean $i$f$getBuffer = false;
                        long result$iv = this_$iv$iv.bufferField.indexOf(b, fromIndex$iv, toIndex);
                        if (result$iv != -1L) {
                            l = result$iv;
                            break block6;
                        }
                        RealBufferedSource this_$iv$iv2 = $this$commonIndexOf$iv;
                        boolean $i$f$getBuffer2 = false;
                        lastBufferSize$iv = this_$iv$iv2.bufferField.size();
                        if (lastBufferSize$iv >= toIndex) break block7;
                        this_$iv$iv2 = $this$commonIndexOf$iv;
                        $i$f$getBuffer2 = false;
                        if ($this$commonIndexOf$iv.source.read(this_$iv$iv2.bufferField, 8192L) != -1L) break block8;
                    }
                    l = -1L;
                    break block6;
                }
                fromIndex$iv = Math.max(fromIndex$iv, lastBufferSize$iv);
            }
            l = -1L;
        }
        return l;
    }

    @Override
    public long indexOfElement(ByteString targetBytes) {
        Intrinsics.checkNotNullParameter(targetBytes, "targetBytes");
        return this.indexOfElement(targetBytes, 0L);
    }

    public long indexOfElement(ByteString targetBytes, long fromIndex) {
        long l;
        Intrinsics.checkNotNullParameter(targetBytes, "targetBytes");
        RealBufferedSource $this$commonIndexOfElement$iv = this;
        boolean $i$f$commonIndexOfElement = false;
        long fromIndex$iv = fromIndex;
        if (!(!$this$commonIndexOfElement$iv.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        while (true) {
            RealBufferedSource this_$iv$iv = $this$commonIndexOfElement$iv;
            boolean $i$f$getBuffer = false;
            long result$iv = this_$iv$iv.bufferField.indexOfElement(targetBytes, fromIndex$iv);
            if (result$iv != -1L) {
                l = result$iv;
                break;
            }
            RealBufferedSource this_$iv$iv2 = $this$commonIndexOfElement$iv;
            boolean $i$f$getBuffer2 = false;
            long lastBufferSize$iv = this_$iv$iv2.bufferField.size();
            this_$iv$iv2 = $this$commonIndexOfElement$iv;
            $i$f$getBuffer2 = false;
            if ($this$commonIndexOfElement$iv.source.read(this_$iv$iv2.bufferField, 8192L) == -1L) {
                l = -1L;
                break;
            }
            fromIndex$iv = Math.max(fromIndex$iv, lastBufferSize$iv);
        }
        return l;
    }

    @Override
    public boolean rangeEquals(long offset, ByteString bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        return this.rangeEquals(offset, bytes, 0, bytes.size());
    }

    public boolean rangeEquals(long offset, ByteString bytes, int bytesOffset, int byteCount) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            RealBufferedSource $this$commonRangeEquals$iv = this;
            boolean $i$f$commonRangeEquals = false;
            if (!(!$this$commonRangeEquals$iv.closed)) {
                boolean bl2 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (offset < 0L || bytesOffset < 0 || byteCount < 0 || bytes.size() - bytesOffset < byteCount) {
                bl = false;
            } else {
                for (int i$iv = 0; i$iv < byteCount; ++i$iv) {
                    long bufferOffset$iv = offset + (long)i$iv;
                    if (!$this$commonRangeEquals$iv.request(bufferOffset$iv + 1L)) {
                        bl = false;
                    } else {
                        RealBufferedSource this_$iv$iv = $this$commonRangeEquals$iv;
                        boolean $i$f$getBuffer = false;
                        if (this_$iv$iv.bufferField.getByte(bufferOffset$iv) == bytes.getByte(bytesOffset + i$iv)) continue;
                        bl = false;
                    }
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        RealBufferedSource $this$commonClose$iv = this;
        boolean $i$f$commonClose = false;
        if (!$this$commonClose$iv.closed) {
            $this$commonClose$iv.closed = true;
            $this$commonClose$iv.source.close();
            RealBufferedSource this_$iv$iv = $this$commonClose$iv;
            boolean $i$f$getBuffer = false;
            this_$iv$iv.bufferField.clear();
        }
    }

    @Override
    public Timeout timeout() {
        RealBufferedSource $this$commonTimeout$iv = this;
        boolean $i$f$commonTimeout = false;
        return $this$commonTimeout$iv.source.timeout();
    }

    public String toString() {
        RealBufferedSource $this$commonToString$iv = this;
        boolean $i$f$commonToString = false;
        return "buffer(" + $this$commonToString$iv.source + ')';
    }
}

