/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.InetSocketAddress;
import java.net.Proxy;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;

public final class Route {
    private final Address address;
    private final Proxy proxy;
    private final InetSocketAddress socketAddress;

    public Route(Address address, Proxy proxy, InetSocketAddress socketAddress) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(proxy, "proxy");
        Intrinsics.checkNotNullParameter(socketAddress, "socketAddress");
        this.address = address;
        this.proxy = proxy;
        this.socketAddress = socketAddress;
    }

    public final Address address() {
        return this.address;
    }

    public final Proxy proxy() {
        return this.proxy;
    }

    public final InetSocketAddress socketAddress() {
        return this.socketAddress;
    }

    public final boolean requiresTunnel() {
        return this.address.sslSocketFactory() != null && this.proxy.type() == Proxy.Type.HTTP;
    }

    public boolean equals(Object other) {
        return other instanceof Route && Intrinsics.areEqual(((Route)other).address, this.address) && Intrinsics.areEqual(((Route)other).proxy, this.proxy) && Intrinsics.areEqual(((Route)other).socketAddress, this.socketAddress);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.address.hashCode();
        result2 = 31 * result2 + this.proxy.hashCode();
        result2 = 31 * result2 + this.socketAddress.hashCode();
        return result2;
    }

    public String toString() {
        return "Route{" + this.socketAddress + '}';
    }
}

