/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandlerKt;
import kotlinx.coroutines.DefaultExecutorKt;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.internal.LimitedDispatcherKt;
import kotlinx.coroutines.internal.LockFreeTaskQueue;

public final class LimitedDispatcher
extends CoroutineDispatcher
implements Delay {
    private final CoroutineDispatcher dispatcher;
    private final int parallelism;
    private final /* synthetic */ Delay $$delegate_0;
    private volatile /* synthetic */ int runningWorkers$volatile;
    private final LockFreeTaskQueue<Runnable> queue;
    private final Object workerAllocationLock;
    private static final /* synthetic */ AtomicIntegerFieldUpdater runningWorkers$volatile$FU;

    public LimitedDispatcher(CoroutineDispatcher dispatcher, int parallelism) {
        this.dispatcher = dispatcher;
        this.parallelism = parallelism;
        Delay delay = dispatcher instanceof Delay ? (Delay)((Object)dispatcher) : null;
        if (delay == null) {
            delay = DefaultExecutorKt.getDefaultDelay();
        }
        this.$$delegate_0 = delay;
        this.queue = new LockFreeTaskQueue(false);
        this.workerAllocationLock = new Object();
    }

    @Override
    public DisposableHandle invokeOnTimeout(long timeMillis, Runnable block, CoroutineContext context) {
        return this.$$delegate_0.invokeOnTimeout(timeMillis, block, context);
    }

    @Override
    public void scheduleResumeAfterDelay(long timeMillis, CancellableContinuation<? super Unit> continuation) {
        this.$$delegate_0.scheduleResumeAfterDelay(timeMillis, continuation);
    }

    @Override
    public CoroutineDispatcher limitedParallelism(int parallelism) {
        LimitedDispatcherKt.checkParallelism(parallelism);
        if (parallelism >= this.parallelism) {
            return this;
        }
        return super.limitedParallelism(parallelism);
    }

    @Override
    public void dispatch(CoroutineContext context, Runnable block) {
        LimitedDispatcher this_$iv = this;
        boolean $i$f$dispatchInternal = false;
        this_$iv.queue.addLast(block);
        if (LimitedDispatcher.runningWorkers$volatile$FU.get(this_$iv) < this_$iv.parallelism && this_$iv.tryAllocateWorker()) {
            Runnable runnable2 = this_$iv.obtainTaskOrDeallocateWorker();
            if (runnable2 != null) {
                Runnable task$iv = runnable2;
                Worker worker = this_$iv.new Worker(task$iv);
                boolean bl = false;
                this.dispatcher.dispatch(this, worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean tryAllocateWorker() {
        Object lock$iv = this.workerAllocationLock;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (LimitedDispatcher.runningWorkers$volatile$FU.get(this) < this.parallelism) break block4;
                boolean bl2 = false;
                return bl2;
            }
            LimitedDispatcher.runningWorkers$volatile$FU.incrementAndGet(this);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Runnable obtainTaskOrDeallocateWorker() {
        Runnable nextTask;
        while ((nextTask = this.queue.removeFirstOrNull()) == null) {
            Object lock$iv = this.workerAllocationLock;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            Object object = lock$iv;
            synchronized (object) {
                block5: {
                    boolean bl = false;
                    LimitedDispatcher.runningWorkers$volatile$FU.decrementAndGet(this);
                    if (this.queue.getSize() != 0) break block5;
                    Runnable runnable2 = null;
                    return runnable2;
                }
                int n = LimitedDispatcher.runningWorkers$volatile$FU.incrementAndGet(this);
            }
        }
        return nextTask;
    }

    static {
        runningWorkers$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(LimitedDispatcher.class, "runningWorkers$volatile");
    }

    private final class Worker
    implements Runnable {
        private Runnable currentTask;

        public Worker(Runnable currentTask) {
            this.currentTask = currentTask;
        }

        @Override
        public void run() {
            int fairnessCounter = 0;
            do {
                try {
                    this.currentTask.run();
                }
                catch (Throwable e) {
                    CoroutineExceptionHandlerKt.handleCoroutineException(EmptyCoroutineContext.INSTANCE, e);
                }
                if (LimitedDispatcher.this.obtainTaskOrDeallocateWorker() == null) {
                    return;
                }
                this.currentTask = this.currentTask;
            } while (++fairnessCounter < 16 || !LimitedDispatcher.this.dispatcher.isDispatchNeeded(LimitedDispatcher.this));
            LimitedDispatcher.this.dispatcher.dispatch(LimitedDispatcher.this, this);
        }
    }
}

