/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.tokenParser;

import io.pebbletemplates.pebble.error.ParserException;
import io.pebbletemplates.pebble.lexer.Token;
import io.pebbletemplates.pebble.lexer.TokenStream;
import io.pebbletemplates.pebble.node.BlockNode;
import io.pebbletemplates.pebble.node.BodyNode;
import io.pebbletemplates.pebble.node.RenderableNode;
import io.pebbletemplates.pebble.parser.Parser;
import io.pebbletemplates.pebble.tokenParser.TokenParser;

public class BlockTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        Token blockName = stream.next();
        if (!blockName.test(Token.Type.NAME) && !blockName.test(Token.Type.STRING)) {
            stream.expect(Token.Type.NAME);
        }
        String name = blockName.getValue();
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        parser.pushBlockStack(name);
        BodyNode blockBody = parser.subparse(tkn -> tkn.test(Token.Type.NAME, "endblock"));
        parser.popBlockStack();
        Token endblock = stream.current();
        if (!endblock.test(Token.Type.NAME, "endblock")) {
            throw new ParserException(null, "endblock tag should be present with block tag starting line number ", token.getLineNumber(), stream.getFilename());
        }
        stream.next();
        Token current = stream.current();
        if (current.test(Token.Type.NAME, name) || current.test(Token.Type.STRING, name)) {
            stream.next();
        }
        stream.expect(Token.Type.EXECUTE_END);
        return new BlockNode(lineNumber, name, blockBody);
    }

    @Override
    public String getTag() {
        return "block";
    }
}

