/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.node.expression;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.node.expression.UnaryExpression;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.PebbleTemplateImpl;
import io.pebbletemplates.pebble.utils.TypeUtils;

public class UnaryNotExpression
extends UnaryExpression {
    @Override
    public Boolean evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        Object result = this.getChildExpression().evaluate(self, context);
        if (result != null) {
            if (result instanceof Boolean || result instanceof Number || result instanceof String) {
                return TypeUtils.compatibleCast(result, Boolean.class) == false;
            }
            throw new PebbleException(null, String.format("Unsupported value type %s. Expected Boolean, String, Number in \"if\" statement", result.getClass().getSimpleName()), this.getLineNumber(), self.getName());
        }
        if (context.isStrictVariables()) {
            throw new PebbleException(null, "null value given to not() and strict variables is set to true", this.getLineNumber(), self.getName());
        }
        return true;
    }
}

