/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;

public final class StandardAndroidSocketAdapter
extends AndroidSocketAdapter {
    public static final Companion Companion = new Companion(null);
    private final Class<? super SSLSocketFactory> sslSocketFactoryClass;
    private final Class<?> paramClass;

    public StandardAndroidSocketAdapter(Class<? super SSLSocket> sslSocketClass, Class<? super SSLSocketFactory> sslSocketFactoryClass, Class<?> paramClass) {
        Intrinsics.checkNotNullParameter(sslSocketClass, "sslSocketClass");
        Intrinsics.checkNotNullParameter(sslSocketFactoryClass, "sslSocketFactoryClass");
        Intrinsics.checkNotNullParameter(paramClass, "paramClass");
        super(sslSocketClass);
        this.sslSocketFactoryClass = sslSocketFactoryClass;
        this.paramClass = paramClass;
    }

    public static final class Companion {
        private Companion() {
        }

        public final SocketAdapter buildIfSupported(String packageName) {
            SocketAdapter socketAdapter;
            Intrinsics.checkNotNullParameter(packageName, "packageName");
            try {
                Class<?> clazz = Class.forName(Intrinsics.stringPlus(packageName, ".OpenSSLSocketImpl"));
                if (clazz == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<in javax.net.ssl.SSLSocket>");
                }
                Class<?> sslSocketClass = clazz;
                Class<?> clazz2 = Class.forName(Intrinsics.stringPlus(packageName, ".OpenSSLSocketFactoryImpl"));
                if (clazz2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<in javax.net.ssl.SSLSocketFactory>");
                }
                Class<?> sslSocketFactoryClass = clazz2;
                Class<?> paramsClass = Class.forName(Intrinsics.stringPlus(packageName, ".SSLParametersImpl"));
                Intrinsics.checkNotNullExpressionValue(paramsClass, "paramsClass");
                socketAdapter = new StandardAndroidSocketAdapter(sslSocketClass, sslSocketFactoryClass, paramsClass);
            }
            catch (Exception e) {
                Platform.Companion.get().log("unable to load android socket classes", 5, e);
                socketAdapter = null;
            }
            return socketAdapter;
        }

        public static /* synthetic */ SocketAdapter buildIfSupported$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "com.android.org.conscrypt";
            }
            return companion.buildIfSupported(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

