/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.JsonTreeDecoder;

final class JsonTreeMapDecoder
extends JsonTreeDecoder {
    private final JsonObject value;
    private final List<String> keys;
    private final int size;
    private int position;

    public JsonTreeMapDecoder(Json json, JsonObject value) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(value, "value");
        super(json, value, null, null, 12, null);
        this.value = value;
        this.keys = CollectionsKt.toList((Iterable)this.getValue().keySet());
        this.size = this.keys.size() * 2;
        this.position = -1;
    }

    @Override
    public JsonObject getValue() {
        return this.value;
    }

    @Override
    protected String elementName(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        int i = index / 2;
        return this.keys.get(i);
    }

    @Override
    public int decodeElementIndex(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.position < this.size - 1) {
            int n = this.position;
            this.position = n + 1;
            return this.position;
        }
        return -1;
    }

    @Override
    protected JsonElement currentElement(String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        return this.position % 2 == 0 ? (JsonElement)JsonElementKt.JsonPrimitive(tag) : (JsonElement)MapsKt.getValue(this.getValue(), tag);
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
    }
}

