/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.AbstractTimeSource;
import kotlinx.coroutines.AbstractTimeSourceKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.DebugStringsKt;
import kotlinx.coroutines.internal.ResizableAtomicArray;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TaskContext;
import kotlinx.coroutines.scheduling.TaskImpl;
import kotlinx.coroutines.scheduling.TasksKt;
import kotlinx.coroutines.scheduling.WorkQueue;

public final class CoroutineScheduler
implements Closeable,
Executor {
    public static final Companion Companion = new Companion(null);
    public final int corePoolSize;
    public final int maxPoolSize;
    public final long idleWorkerKeepAliveNs;
    public final String schedulerName;
    public final GlobalQueue globalCpuQueue;
    public final GlobalQueue globalBlockingQueue;
    private volatile /* synthetic */ long parkedWorkersStack$volatile;
    public final ResizableAtomicArray<Worker> workers;
    private volatile /* synthetic */ long controlState$volatile;
    private volatile /* synthetic */ int _isTerminated$volatile;
    private static final /* synthetic */ AtomicLongFieldUpdater parkedWorkersStack$volatile$FU;
    private static final /* synthetic */ AtomicLongFieldUpdater controlState$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater _isTerminated$volatile$FU;
    public static final Symbol NOT_IN_STACK;

    public CoroutineScheduler(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs, String schedulerName) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleWorkerKeepAliveNs = idleWorkerKeepAliveNs;
        this.schedulerName = schedulerName;
        if (!(this.corePoolSize >= 1)) {
            boolean $i$a$-require-CoroutineScheduler$52 = false;
            String $i$a$-require-CoroutineScheduler$52 = "Core pool size " + this.corePoolSize + " should be at least 1";
            throw new IllegalArgumentException($i$a$-require-CoroutineScheduler$52.toString());
        }
        if (!(this.maxPoolSize >= this.corePoolSize)) {
            boolean $i$a$-require-CoroutineScheduler$62 = false;
            String $i$a$-require-CoroutineScheduler$62 = "Max pool size " + this.maxPoolSize + " should be greater than or equals to core pool size " + this.corePoolSize;
            throw new IllegalArgumentException($i$a$-require-CoroutineScheduler$62.toString());
        }
        if (!(this.maxPoolSize <= 0x1FFFFE)) {
            boolean $i$a$-require-CoroutineScheduler$72 = false;
            String $i$a$-require-CoroutineScheduler$72 = "Max pool size " + this.maxPoolSize + " should not exceed maximal supported number of threads 2097150";
            throw new IllegalArgumentException($i$a$-require-CoroutineScheduler$72.toString());
        }
        if (!(this.idleWorkerKeepAliveNs > 0L)) {
            boolean bl = false;
            String string = "Idle worker keep alive time " + this.idleWorkerKeepAliveNs + " must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        this.globalCpuQueue = new GlobalQueue();
        this.globalBlockingQueue = new GlobalQueue();
        this.workers = new ResizableAtomicArray((this.corePoolSize + 1) * 2);
        this.controlState$volatile = (long)this.corePoolSize << 42;
        this._isTerminated$volatile = 0;
    }

    private final boolean addToGlobalQueue(Task task) {
        Task $this$isBlocking$iv = task;
        boolean $i$f$isBlocking = false;
        return $this$isBlocking$iv.taskContext.getTaskMode() == 1 ? this.globalBlockingQueue.addLast(task) : this.globalCpuQueue.addLast(task);
    }

    public final void parkedWorkersStackTopUpdate(Worker worker, int oldIndex, int newIndex) {
        long updVersion;
        long top;
        int n;
        int updIndex;
        CoroutineScheduler coroutineScheduler = this;
        AtomicLongFieldUpdater handler$atomicfu$iv = CoroutineScheduler.parkedWorkersStack$volatile$FU;
        do {
            top = handler$atomicfu$iv.get(this);
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            if (index == oldIndex) {
                if (newIndex == 0) {
                    n = this.parkedWorkersStackNextIndex(worker);
                    continue;
                }
                n = newIndex;
                continue;
            }
            n = index;
        } while ((updIndex = n) < 0 || !CoroutineScheduler.parkedWorkersStack$volatile$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    public final boolean parkedWorkersStackPush(Worker worker) {
        int updIndex;
        long updVersion;
        long top;
        if (worker.getNextParkedWorker() != NOT_IN_STACK) {
            return false;
        }
        CoroutineScheduler coroutineScheduler = this;
        AtomicLongFieldUpdater handler$atomicfu$iv = CoroutineScheduler.parkedWorkersStack$volatile$FU;
        do {
            top = handler$atomicfu$iv.get(this);
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            updIndex = worker.getIndexInArray();
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl2 = false;
                if (!(updIndex != 0)) {
                    throw new AssertionError();
                }
            }
            worker.setNextParkedWorker(this.workers.get(index));
        } while (!CoroutineScheduler.parkedWorkersStack$volatile$FU.compareAndSet(this, top, updVersion | (long)updIndex));
        return true;
    }

    private final Worker parkedWorkersStackPop() {
        long updVersion;
        long top;
        Worker worker;
        int updIndex;
        CoroutineScheduler coroutineScheduler = this;
        AtomicLongFieldUpdater handler$atomicfu$iv = CoroutineScheduler.parkedWorkersStack$volatile$FU;
        do {
            top = handler$atomicfu$iv.get(this);
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            if (this.workers.get(index) == null) {
                return null;
            }
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
        } while ((updIndex = this.parkedWorkersStackNextIndex(worker)) < 0 || !CoroutineScheduler.parkedWorkersStack$volatile$FU.compareAndSet(this, top, updVersion | (long)updIndex));
        worker.setNextParkedWorker(NOT_IN_STACK);
        return worker;
    }

    private final int parkedWorkersStackNextIndex(Worker worker) {
        Object next = worker.getNextParkedWorker();
        while (next != NOT_IN_STACK) {
            if (next == null) {
                return 0;
            }
            Worker nextWorker = (Worker)next;
            int updIndex = nextWorker.getIndexInArray();
            if (updIndex != 0) {
                return updIndex;
            }
            next = nextWorker.getNextParkedWorker();
        }
        return -1;
    }

    public final boolean isTerminated() {
        return CoroutineScheduler._isTerminated$volatile$FU.get(this) != 0;
    }

    @Override
    public void execute(Runnable command) {
        CoroutineScheduler.dispatch$default(this, command, null, false, 6, null);
    }

    @Override
    public void close() {
        this.shutdown(10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(long timeout2) {
        Runnable runnable2;
        int n;
        if (!CoroutineScheduler._isTerminated$volatile$FU.compareAndSet(this, 0, 1)) {
            return;
        }
        Worker currentWorker = this.currentWorker();
        ResizableAtomicArray<Worker> lock$iv = this.workers;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            n = 0;
            CoroutineScheduler this_$iv = this;
            boolean $i$f$getCreatedWorkers = false;
            n = (int)(CoroutineScheduler.getControlState$volatile$FU().get(this_$iv) & 0x1FFFFFL);
        }
        int created = n;
        int i = 1;
        if (i <= created) {
            while (true) {
                Worker worker;
                Intrinsics.checkNotNull(this.workers.get(i));
                if (worker != currentWorker) {
                    while (worker.getState() != Thread.State.TERMINATED) {
                        LockSupport.unpark(worker);
                        worker.join(timeout2);
                    }
                    if (DebugKt.getASSERTIONS_ENABLED()) {
                        boolean bl = false;
                        if (!(worker.state == WorkerState.TERMINATED)) {
                            throw new AssertionError();
                        }
                    }
                    worker.localQueue.offloadAllWorkTo(this.globalBlockingQueue);
                }
                if (i == created) break;
                ++i;
            }
        }
        this.globalBlockingQueue.close();
        this.globalCpuQueue.close();
        while ((runnable2 = currentWorker) != null && (runnable2 = runnable2.findTask(true)) != null || (runnable2 = (Task)this.globalCpuQueue.removeFirstOrNull()) != null || (runnable2 = (Task)this.globalBlockingQueue.removeFirstOrNull()) != null) {
            Runnable task = runnable2;
            this.runSafely((Task)task);
        }
        Worker worker = currentWorker;
        if (worker != null) {
            worker.tryReleaseCpu(WorkerState.TERMINATED);
        }
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl = false;
            CoroutineScheduler this_$iv = this;
            boolean $i$f$getAvailableCpuPermits = false;
            object = this_$iv;
            long state$iv$iv = CoroutineScheduler.controlState$volatile$FU.get(this_$iv);
            boolean $i$f$availableCpuPermits = false;
            if (!((int)((state$iv$iv & 0x7FFFFC0000000000L) >> 42) == this.corePoolSize)) {
                throw new AssertionError();
            }
        }
        CoroutineScheduler.parkedWorkersStack$volatile$FU.set(this, 0L);
        CoroutineScheduler.controlState$volatile$FU.set(this, 0L);
    }

    public final void dispatch(Runnable block, TaskContext taskContext, boolean tailDispatch) {
        boolean skipUnpark;
        long l;
        boolean isBlockingTask;
        Task task;
        AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
        if (abstractTimeSource != null) {
            abstractTimeSource.trackTask();
        }
        Task $this$isBlocking$iv = task = this.createTask(block, taskContext);
        boolean $i$f$isBlocking = false;
        boolean bl = isBlockingTask = $this$isBlocking$iv.taskContext.getTaskMode() == 1;
        if (isBlockingTask) {
            CoroutineScheduler this_$iv = this;
            boolean $i$f$incrementBlockingTasks = false;
            l = CoroutineScheduler.controlState$volatile$FU.addAndGet(this_$iv, 0x200000L);
        } else {
            l = 0L;
        }
        long stateSnapshot = l;
        Worker currentWorker = this.currentWorker();
        Task notAdded = this.submitToLocalQueue(currentWorker, task, tailDispatch);
        if (notAdded != null && !this.addToGlobalQueue(notAdded)) {
            throw new RejectedExecutionException(this.schedulerName + " was terminated");
        }
        boolean bl2 = skipUnpark = tailDispatch && currentWorker != null;
        if (isBlockingTask) {
            this.signalBlockingWork(stateSnapshot, skipUnpark);
        } else {
            if (skipUnpark) {
                return;
            }
            this.signalCpuWork();
        }
    }

    public static /* synthetic */ void dispatch$default(CoroutineScheduler coroutineScheduler, Runnable runnable2, TaskContext taskContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            taskContext = TasksKt.NonBlockingContext;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        coroutineScheduler.dispatch(runnable2, taskContext, bl);
    }

    public final Task createTask(Runnable block, TaskContext taskContext) {
        long nanoTime = TasksKt.schedulerTimeSource.nanoTime();
        if (block instanceof Task) {
            ((Task)block).submissionTime = nanoTime;
            ((Task)block).taskContext = taskContext;
            return (Task)block;
        }
        return new TaskImpl(block, nanoTime, taskContext);
    }

    private final void signalBlockingWork(long stateSnapshot, boolean skipUnpark) {
        if (skipUnpark) {
            return;
        }
        if (this.tryUnpark()) {
            return;
        }
        if (this.tryCreateWorker(stateSnapshot)) {
            return;
        }
        this.tryUnpark();
    }

    public final void signalCpuWork() {
        if (this.tryUnpark()) {
            return;
        }
        if (CoroutineScheduler.tryCreateWorker$default(this, 0L, 1, null)) {
            return;
        }
        this.tryUnpark();
    }

    private final boolean tryCreateWorker(long state) {
        CoroutineScheduler this_$iv = this;
        boolean $i$f$createdWorkers = false;
        int created = (int)(state & 0x1FFFFFL);
        CoroutineScheduler this_$iv2 = this;
        boolean $i$f$blockingTasks = false;
        int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
        int cpuWorkers = RangesKt.coerceAtLeast(created - blocking, 0);
        if (cpuWorkers < this.corePoolSize) {
            int newCpuWorkers = this.createNewWorker();
            if (newCpuWorkers == 1 && this.corePoolSize > 1) {
                this.createNewWorker();
            }
            if (newCpuWorkers > 0) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ boolean tryCreateWorker$default(CoroutineScheduler coroutineScheduler, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = CoroutineScheduler.controlState$volatile$FU.get(coroutineScheduler);
        }
        return coroutineScheduler.tryCreateWorker(l);
    }

    private final boolean tryUnpark() {
        Worker worker;
        do {
            if (this.parkedWorkersStackPop() != null) continue;
            return false;
        } while (!Worker.workerCtl$volatile$FU.compareAndSet(worker, -1, 0));
        LockSupport.unpark(worker);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int createNewWorker() {
        int n;
        int n2;
        Worker worker = null;
        ResizableAtomicArray<Worker> lock$iv = this.workers;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        ResizableAtomicArray<Worker> resizableAtomicArray = lock$iv;
        synchronized (resizableAtomicArray) {
            int cpuWorkers;
            block10: {
                int created;
                block9: {
                    block8: {
                        boolean bl = false;
                        if (!this.isTerminated()) break block8;
                        int n3 = -1;
                        return n3;
                    }
                    long state = CoroutineScheduler.controlState$volatile$FU.get(this);
                    CoroutineScheduler this_$iv = this;
                    boolean $i$f$createdWorkers = false;
                    created = (int)(state & 0x1FFFFFL);
                    CoroutineScheduler this_$iv2 = this;
                    boolean $i$f$blockingTasks = false;
                    int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
                    cpuWorkers = RangesKt.coerceAtLeast(created - blocking, 0);
                    if (cpuWorkers < this.corePoolSize) break block9;
                    int n4 = 0;
                    return n4;
                }
                if (created < this.maxPoolSize) break block10;
                int n5 = 0;
                return n5;
            }
            CoroutineScheduler this_$iv = this;
            boolean $i$f$getCreatedWorkers2 = false;
            int newIndex = (int)(CoroutineScheduler.getControlState$volatile$FU().get(this_$iv) & 0x1FFFFFL) + 1;
            if (!(newIndex > 0 && this.workers.get(newIndex) == null)) {
                String $i$f$getCreatedWorkers2 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$getCreatedWorkers2.toString());
            }
            worker = new Worker(newIndex);
            this.workers.setSynchronized(newIndex, worker);
            this_$iv = this;
            boolean $i$f$incrementCreatedWorkers = false;
            CoroutineScheduler coroutineScheduler = this_$iv;
            long state$iv$iv = CoroutineScheduler.controlState$volatile$FU.incrementAndGet(this_$iv);
            boolean $i$f$createdWorkers = false;
            if (!(newIndex == (int)(state$iv$iv & 0x1FFFFFL))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            n2 = cpuWorkers + 1;
        }
        int it = n = n2;
        boolean bl = false;
        worker.start();
        return n;
    }

    private final Task submitToLocalQueue(Worker $this$submitToLocalQueue, Task task, boolean tailDispatch) {
        if ($this$submitToLocalQueue == null) {
            return task;
        }
        if ($this$submitToLocalQueue.state == WorkerState.TERMINATED) {
            return task;
        }
        Task this_$iv = task;
        boolean $i$f$getMode$kotlinx_coroutines_core = false;
        if (this_$iv.taskContext.getTaskMode() == 0 && $this$submitToLocalQueue.state == WorkerState.BLOCKING) {
            return task;
        }
        $this$submitToLocalQueue.mayHaveLocalTasks = true;
        return $this$submitToLocalQueue.localQueue.add(task, tailDispatch);
    }

    private final Worker currentWorker() {
        Thread thread;
        Thread thread2 = Thread.currentThread();
        Worker worker = thread2 instanceof Worker ? (Worker)thread2 : null;
        if (worker != null) {
            Thread it = thread2 = worker;
            boolean bl = false;
            Thread this_$iv = it;
            boolean $i$f$getScheduler = false;
            thread = Intrinsics.areEqual(((Worker)this_$iv).CoroutineScheduler.this, this) ? thread2 : null;
        } else {
            thread = null;
        }
        return thread;
    }

    public String toString() {
        int parkedWorkers = 0;
        int blockingWorkers = 0;
        int cpuWorkers = 0;
        int dormant = 0;
        int terminated = 0;
        ArrayList queueSizes = new ArrayList();
        int n = this.workers.currentLength();
        block7: for (int index = 1; index < n; ++index) {
            Worker worker;
            if (this.workers.get(index) == null) continue;
            int queueSize = worker.localQueue.getSize$kotlinx_coroutines_core();
            switch (WhenMappings.$EnumSwitchMapping$0[worker.state.ordinal()]) {
                case 1: {
                    ++parkedWorkers;
                    continue block7;
                }
                case 2: {
                    ++blockingWorkers;
                    ((Collection)queueSizes).add("" + queueSize + 'b');
                    continue block7;
                }
                case 3: {
                    ++cpuWorkers;
                    ((Collection)queueSizes).add("" + queueSize + 'c');
                    continue block7;
                }
                case 4: {
                    ++dormant;
                    if (queueSize <= 0) continue block7;
                    ((Collection)queueSizes).add("" + queueSize + 'd');
                    continue block7;
                }
                case 5: {
                    ++terminated;
                }
            }
        }
        long state = CoroutineScheduler.controlState$volatile$FU.get(this);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schedulerName).append('@').append(DebugStringsKt.getHexAddress(this)).append("[Pool Size {core = ").append(this.corePoolSize).append(", max = ").append(this.maxPoolSize).append("}, Worker States {CPU = ").append(cpuWorkers).append(", blocking = ").append(blockingWorkers).append(", parked = ").append(parkedWorkers).append(", dormant = ").append(dormant).append(", terminated = ").append(terminated).append("}, running workers queues = ").append(queueSizes).append(", global CPU queue size = ").append(this.globalCpuQueue.getSize()).append(", global blocking queue size = ").append(this.globalBlockingQueue.getSize());
        CoroutineScheduler this_$iv = this;
        boolean $i$f$createdWorkers = false;
        this_$iv = this;
        boolean $i$f$blockingTasks = false;
        this_$iv = this;
        boolean $i$f$availableCpuPermits = false;
        stringBuilder.append(", Control State {created workers= ").append((int)(state & 0x1FFFFFL)).append(", blocking tasks = ").append((int)((state & 0x3FFFFE00000L) >> 21)).append(", CPUs acquired = ").append(this.corePoolSize - (int)((state & 0x7FFFFC0000000000L) >> 42)).append("}]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runSafely(Task task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
        }
        finally {
            AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.access$getTimeSource$p();
            if (abstractTimeSource != null) {
                abstractTimeSource.unTrackTask();
            }
        }
    }

    static {
        parkedWorkersStack$volatile$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "parkedWorkersStack$volatile");
        controlState$volatile$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "controlState$volatile");
        _isTerminated$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(CoroutineScheduler.class, "_isTerminated$volatile");
        NOT_IN_STACK = new Symbol("NOT_IN_STACK");
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkerState.values().length];
            try {
                nArray[WorkerState.PARKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkerState.BLOCKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkerState.CPU_ACQUIRED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkerState.DORMANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkerState.TERMINATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    public final class Worker
    extends Thread {
        private volatile int indexInArray;
        public final WorkQueue localQueue;
        private final Ref.ObjectRef<Task> stolenTask;
        public WorkerState state;
        private volatile /* synthetic */ int workerCtl$volatile;
        private long terminationDeadline;
        private volatile Object nextParkedWorker;
        private long minDelayUntilStealableTaskNs;
        private int rngState;
        public boolean mayHaveLocalTasks;
        private static final /* synthetic */ AtomicIntegerFieldUpdater workerCtl$volatile$FU;

        private Worker() {
            this.setDaemon(true);
            this.setContextClassLoader(CoroutineScheduler.this.getClass().getClassLoader());
            this.localQueue = new WorkQueue();
            this.stolenTask = new Ref.ObjectRef();
            this.state = WorkerState.DORMANT;
            this.nextParkedWorker = NOT_IN_STACK;
            this.rngState = Random.Default.nextInt();
        }

        public final int getIndexInArray() {
            return this.indexInArray;
        }

        public final void setIndexInArray(int index) {
            this.setName(CoroutineScheduler.this.schedulerName + "-worker-" + (index == 0 ? "TERMINATED" : String.valueOf(index)));
            this.indexInArray = index;
        }

        public Worker(int index) {
            this();
            this.setIndexInArray(index);
        }

        public final Object getNextParkedWorker() {
            return this.nextParkedWorker;
        }

        public final void setNextParkedWorker(Object object) {
            this.nextParkedWorker = object;
        }

        private final boolean tryAcquireCpuPermit() {
            boolean bl;
            if (this.state == WorkerState.CPU_ACQUIRED) {
                bl = true;
            } else {
                boolean bl2;
                block6: {
                    long update$iv;
                    long state$iv;
                    CoroutineScheduler this_$iv = CoroutineScheduler.this;
                    boolean $i$f$tryAcquireCpuPermit = false;
                    CoroutineScheduler coroutineScheduler = this_$iv;
                    AtomicLongFieldUpdater handler$atomicfu$iv$iv = CoroutineScheduler.controlState$volatile$FU;
                    do {
                        state$iv = handler$atomicfu$iv$iv.get(this_$iv);
                        boolean bl3 = false;
                        CoroutineScheduler this_$iv$iv = this_$iv;
                        boolean $i$f$availableCpuPermits = false;
                        int available$iv = (int)((state$iv & 0x7FFFFC0000000000L) >> 42);
                        if (available$iv == 0) {
                            bl2 = false;
                            break block6;
                        }
                        update$iv = state$iv - 0x40000000000L;
                    } while (!CoroutineScheduler.controlState$volatile$FU.compareAndSet(this_$iv, state$iv, update$iv));
                    bl2 = true;
                }
                if (bl2) {
                    this.state = WorkerState.CPU_ACQUIRED;
                    bl = true;
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean tryReleaseCpu(WorkerState newState) {
            boolean hadCpu;
            WorkerState previousState = this.state;
            boolean bl = hadCpu = previousState == WorkerState.CPU_ACQUIRED;
            if (hadCpu) {
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                boolean $i$f$releaseCpuPermit = false;
                CoroutineScheduler.controlState$volatile$FU.addAndGet(this_$iv, 0x40000000000L);
            }
            if (previousState != newState) {
                this.state = newState;
            }
            return hadCpu;
        }

        @Override
        public void run() {
            this.runWorker();
        }

        private final void runWorker() {
            boolean rescanned = false;
            while (!CoroutineScheduler.this.isTerminated() && this.state != WorkerState.TERMINATED) {
                Task task = this.findTask(this.mayHaveLocalTasks);
                if (task != null) {
                    rescanned = false;
                    this.minDelayUntilStealableTaskNs = 0L;
                    this.executeTask(task);
                    continue;
                }
                this.mayHaveLocalTasks = false;
                if (this.minDelayUntilStealableTaskNs != 0L) {
                    if (!rescanned) {
                        rescanned = true;
                        continue;
                    }
                    rescanned = false;
                    this.tryReleaseCpu(WorkerState.PARKING);
                    Thread.interrupted();
                    LockSupport.parkNanos(this.minDelayUntilStealableTaskNs);
                    this.minDelayUntilStealableTaskNs = 0L;
                    continue;
                }
                this.tryPark();
            }
            this.tryReleaseCpu(WorkerState.TERMINATED);
        }

        private final void tryPark() {
            if (!this.inStack()) {
                CoroutineScheduler.this.parkedWorkersStackPush(this);
                return;
            }
            Worker.workerCtl$volatile$FU.set(this, -1);
            while (this.inStack() && Worker.workerCtl$volatile$FU.get(this) == -1 && !CoroutineScheduler.this.isTerminated() && this.state != WorkerState.TERMINATED) {
                this.tryReleaseCpu(WorkerState.PARKING);
                Thread.interrupted();
                this.park();
            }
        }

        private final boolean inStack() {
            return this.nextParkedWorker != NOT_IN_STACK;
        }

        private final void executeTask(Task task) {
            Task this_$iv = task;
            boolean $i$f$getMode$kotlinx_coroutines_core = false;
            int taskMode = this_$iv.taskContext.getTaskMode();
            this.idleReset(taskMode);
            this.beforeTask(taskMode);
            CoroutineScheduler.this.runSafely(task);
            this.afterTask(taskMode);
        }

        private final void beforeTask(int taskMode) {
            if (taskMode == 0) {
                return;
            }
            if (this.tryReleaseCpu(WorkerState.BLOCKING)) {
                CoroutineScheduler.this.signalCpuWork();
            }
        }

        private final void afterTask(int taskMode) {
            if (taskMode == 0) {
                return;
            }
            CoroutineScheduler this_$iv = CoroutineScheduler.this;
            boolean $i$f$decrementBlockingTasks = false;
            CoroutineScheduler.controlState$volatile$FU.addAndGet(this_$iv, -2097152L);
            WorkerState currentState = this.state;
            if (currentState != WorkerState.TERMINATED) {
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl = false;
                    if (!(currentState == WorkerState.BLOCKING)) {
                        throw new AssertionError();
                    }
                }
                this.state = WorkerState.DORMANT;
            }
        }

        public final int nextInt(int upperBound) {
            int r = this.rngState;
            r ^= r << 13;
            r ^= r >> 17;
            r ^= r << 5;
            this.rngState = r;
            int mask = upperBound - 1;
            if ((mask & upperBound) == 0) {
                return r & mask;
            }
            return (r & Integer.MAX_VALUE) % upperBound;
        }

        private final void park() {
            if (this.terminationDeadline == 0L) {
                this.terminationDeadline = System.nanoTime() + CoroutineScheduler.this.idleWorkerKeepAliveNs;
            }
            LockSupport.parkNanos(CoroutineScheduler.this.idleWorkerKeepAliveNs);
            if (System.nanoTime() - this.terminationDeadline >= 0L) {
                this.terminationDeadline = 0L;
                this.tryTerminateWorker();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void tryTerminateWorker() {
            void lock$iv;
            ResizableAtomicArray<Worker> resizableAtomicArray = CoroutineScheduler.this.workers;
            CoroutineScheduler coroutineScheduler = CoroutineScheduler.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            void var5_5 = lock$iv;
            synchronized (var5_5) {
                boolean bl = false;
                if (coroutineScheduler.isTerminated()) {
                    return;
                }
                CoroutineScheduler this_$iv = coroutineScheduler;
                boolean $i$f$getCreatedWorkers = false;
                if ((int)(CoroutineScheduler.controlState$volatile$FU.get(this_$iv) & 0x1FFFFFL) <= coroutineScheduler.corePoolSize) {
                    return;
                }
                if (!Worker.workerCtl$volatile$FU.compareAndSet(this, -1, 1)) {
                    return;
                }
                int oldIndex = this.indexInArray;
                this.setIndexInArray(0);
                coroutineScheduler.parkedWorkersStackTopUpdate(this, oldIndex, 0);
                CoroutineScheduler this_$iv2 = coroutineScheduler;
                boolean $i$f$decrementCreatedWorkers = false;
                CoroutineScheduler coroutineScheduler2 = this_$iv2;
                long state$iv$iv = CoroutineScheduler.controlState$volatile$FU.getAndDecrement(this_$iv2);
                boolean $i$f$createdWorkers = false;
                int lastIndex = (int)(state$iv$iv & 0x1FFFFFL);
                if (lastIndex != oldIndex) {
                    Worker worker = coroutineScheduler.workers.get(lastIndex);
                    Intrinsics.checkNotNull(worker);
                    Worker lastWorker = worker;
                    coroutineScheduler.workers.setSynchronized(oldIndex, lastWorker);
                    lastWorker.setIndexInArray(oldIndex);
                    coroutineScheduler.parkedWorkersStackTopUpdate(lastWorker, lastIndex, oldIndex);
                }
                coroutineScheduler.workers.setSynchronized(lastIndex, null);
                Unit unit = Unit.INSTANCE;
            }
            this.state = WorkerState.TERMINATED;
        }

        private final void idleReset(int mode) {
            this.terminationDeadline = 0L;
            if (this.state == WorkerState.PARKING) {
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl = false;
                    if (!(mode == 1)) {
                        throw new AssertionError();
                    }
                }
                this.state = WorkerState.BLOCKING;
            }
        }

        public final Task findTask(boolean mayHaveLocalTasks) {
            if (this.tryAcquireCpuPermit()) {
                return this.findAnyTask(mayHaveLocalTasks);
            }
            return this.findBlockingTask();
        }

        private final Task findBlockingTask() {
            Task task = this.localQueue.pollBlocking();
            if (task == null && (task = (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull()) == null) {
                task = this.trySteal(1);
            }
            return task;
        }

        private final Task findAnyTask(boolean scanLocalQueue) {
            if (scanLocalQueue) {
                Task task;
                boolean globalFirst;
                boolean bl = globalFirst = this.nextInt(2 * CoroutineScheduler.this.corePoolSize) == 0;
                if (globalFirst && (task = this.pollGlobalQueues()) != null) {
                    Task it = task;
                    boolean bl2 = false;
                    return it;
                }
                task = this.localQueue.poll();
                if (task != null) {
                    Task it = task;
                    boolean bl3 = false;
                    return it;
                }
                if (!globalFirst && (task = this.pollGlobalQueues()) != null) {
                    Task it = task;
                    boolean bl4 = false;
                    return it;
                }
            } else {
                Task task = this.pollGlobalQueues();
                if (task != null) {
                    Task it = task;
                    boolean bl = false;
                    return it;
                }
            }
            return this.trySteal(3);
        }

        private final Task pollGlobalQueues() {
            if (this.nextInt(2) == 0) {
                Task task = (Task)CoroutineScheduler.this.globalCpuQueue.removeFirstOrNull();
                if (task != null) {
                    Task it = task;
                    boolean bl = false;
                    return it;
                }
                return (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
            }
            Task task = (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
            if (task != null) {
                Task it = task;
                boolean bl = false;
                return it;
            }
            return (Task)CoroutineScheduler.this.globalCpuQueue.removeFirstOrNull();
        }

        private final Task trySteal(int stealingMode) {
            CoroutineScheduler this_$iv = CoroutineScheduler.this;
            boolean $i$f$getCreatedWorkers = false;
            int created = (int)(CoroutineScheduler.controlState$volatile$FU.get(this_$iv) & 0x1FFFFFL);
            if (created < 2) {
                return null;
            }
            int currentIndex = 0;
            currentIndex = this.nextInt(created);
            long minDelay = 0L;
            minDelay = Long.MAX_VALUE;
            CoroutineScheduler coroutineScheduler = CoroutineScheduler.this;
            for (int i = 0; i < created; ++i) {
                Worker worker;
                int it = i;
                boolean bl = false;
                if (++currentIndex > created) {
                    currentIndex = 1;
                }
                if ((worker = coroutineScheduler.workers.get(currentIndex)) == null || worker == this) continue;
                long stealResult = worker.localQueue.trySteal(stealingMode, this.stolenTask);
                if (stealResult == -1L) {
                    Task result2 = (Task)this.stolenTask.element;
                    this.stolenTask.element = null;
                    return result2;
                }
                if (stealResult <= 0L) continue;
                minDelay = Math.min(minDelay, stealResult);
            }
            this.minDelayUntilStealableTaskNs = minDelay != Long.MAX_VALUE ? minDelay : 0L;
            return null;
        }

        static {
            workerCtl$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "workerCtl$volatile");
        }
    }

    public static final class WorkerState
    extends Enum<WorkerState> {
        public static final /* enum */ WorkerState CPU_ACQUIRED = new WorkerState();
        public static final /* enum */ WorkerState BLOCKING = new WorkerState();
        public static final /* enum */ WorkerState PARKING = new WorkerState();
        public static final /* enum */ WorkerState DORMANT = new WorkerState();
        public static final /* enum */ WorkerState TERMINATED = new WorkerState();
        private static final /* synthetic */ WorkerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WorkerState[] values() {
            return (WorkerState[])$VALUES.clone();
        }

        static {
            $VALUES = workerStateArray = new WorkerState[]{WorkerState.CPU_ACQUIRED, WorkerState.BLOCKING, WorkerState.PARKING, WorkerState.DORMANT, WorkerState.TERMINATED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

