/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.smartgit.graphql;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Executable;
import com.apollographql.apollo.api.Executables;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Mutation$Data;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Query$Data;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.network.OkHttpExtensionsKt;
import com.syntevo.smartgit.graphql.SgCompletedWithErrorsException;
import com.syntevo.smartgit.graphql.SgGraphQLClientBase;
import com.syntevo.smartgit.graphql.SgLoggingInterceptor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExecutorsKt;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public abstract class SgGraphQLClientBase {
    private SgLoggingInterceptor logger;
    private final ApolloClient apolloClient;
    private final Thread ownerThread;
    private final Function1<String, Unit> logCallback;

    public SgGraphQLClientBase(String serverUrl2, String token, Function1<? super String, Unit> log, String proxy, Integer proxyPort, String proxyUser, String proxyPass, String jsonLoggingPath, SSLContext sslContext, X509TrustManager trustManager, HostnameVerifier hostnameVerifier, Executor executor) {
        Intrinsics.checkNotNullParameter(serverUrl2, "serverUrl");
        Intrinsics.checkNotNullParameter(token, "token");
        Intrinsics.checkNotNullParameter(log, "log");
        Intrinsics.checkNotNullParameter(executor, "executor");
        this.logCallback = arg_0 -> SgGraphQLClientBase.logCallback$lambda$0(log, arg_0);
        OkHttpClient.Builder okBuilder = new OkHttpClient.Builder();
        this.logger = new SgLoggingInterceptor(jsonLoggingPath);
        okBuilder.addInterceptor(this.logger);
        if (proxy != null) {
            Integer n = proxyPort;
            Intrinsics.checkNotNull(n);
            okBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, (int)n)));
            if (proxyUser != null) {
                Authenticator proxyAuthenticator = (arg_0, arg_1) -> SgGraphQLClientBase._init_$lambda$1(proxyUser, proxyPass, arg_0, arg_1);
                okBuilder.proxyAuthenticator(proxyAuthenticator);
            }
        }
        if (sslContext != null && trustManager != null) {
            SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "getSocketFactory(...)");
            okBuilder.sslSocketFactory(sSLSocketFactory, trustManager);
        }
        OkHttpClient.Builder builder = hostnameVerifier != null ? okBuilder.hostnameVerifier(hostnameVerifier) : okBuilder.hostnameVerifier(SgGraphQLClientBase::_init_$lambda$2);
        OkHttpClient okHttpClient = okBuilder.build();
        this.apolloClient = OkHttpExtensionsKt.okHttpClient(new ApolloClient.Builder().retryOnError(SgGraphQLClientBase::_init_$lambda$3).serverUrl(serverUrl2), okHttpClient).dispatcher(ExecutorsKt.from(executor)).addHttpHeader("Authorization", "bearer " + token).build();
        this.ownerThread = Thread.currentThread();
    }

    private final <D extends Operation.Data, R> R handleErrors(ApolloResponse<D> response, Consumer<String> warningConsumer, Function1<? super D, ? extends R> get2) {
        R result2;
        if (response.exception != null) {
            ApolloException apolloException = response.exception;
            Intrinsics.checkNotNull(apolloException);
            throw apolloException;
        }
        Object d = response.data;
        if (d != null) {
            Object it = d;
            boolean bl = false;
            v2 = get2.invoke((D)it);
        } else {
            v2 = result2 = null;
        }
        if (response.hasErrors()) {
            if (result2 != null && warningConsumer != null) {
                List<Error> list = response.errors;
                Intrinsics.checkNotNull(list);
                for (Error error : list) {
                    warningConsumer.accept(error.getMessage());
                }
            } else {
                List<Error> list = response.errors;
                Intrinsics.checkNotNull(list);
                throw new SgCompletedWithErrorsException(list);
            }
        }
        if (result2 == null) {
            throw new RuntimeException("Query '" + response.operation.name() + "' returned null-result");
        }
        return result2;
    }

    /*
     * Unable to fully structure code
     */
    protected final <D extends Query$Data, R> Object query(Query<D> var1_1, Consumer<String> var2_2, Function1<? super D, ? extends R> var3_3, Continuation<? super R> $completion) {
        if (!($completion instanceof query.1)) ** GOTO lbl-1000
        var7_5 = $completion;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ SgGraphQLClientBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                public final Object invokeSuspend(Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.query(null, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.assertThread();
                this.logCallback.invoke("Sending GraphQL Query: '" + query.name() + "': " + Executables.variables((Executable)query, CustomScalarAdapters.Empty, true).getValueMap());
                this.logger.setRequestOperation(query.name());
                $continuation.L$0 = this;
                $continuation.L$1 = warningConsumer;
                $continuation.L$2 = get;
                $continuation.label = 1;
                v0 = this.apolloClient.query(query).execute($continuation);
                if (v0 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl30
            }
            case 1: {
                get = (Function1)$continuation.L$2;
                warningConsumer = (Consumer)$continuation.L$1;
                this = (SgGraphQLClientBase)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl30:
                // 2 sources

                result = (ApolloResponse)v0;
                return this.handleErrors(result, warningConsumer, get);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    protected final <D extends Mutation$Data, R> Object mutation(Mutation<D> var1_1, Consumer<String> var2_2, Function1<? super D, ? extends R> var3_3, Continuation<? super R> $completion) {
        if (!($completion instanceof mutation.1)) ** GOTO lbl-1000
        var7_5 = $completion;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ SgGraphQLClientBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                public final Object invokeSuspend(Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.mutation(null, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.assertThread();
                this.logCallback.invoke("Sending GraphQL Mutation: '" + mutation.name() + "': " + Executables.variables((Executable)mutation, CustomScalarAdapters.Empty, true).getValueMap());
                this.logger.setRequestOperation(mutation.name());
                $continuation.L$0 = this;
                $continuation.L$1 = warningConsumer;
                $continuation.L$2 = get;
                $continuation.label = 1;
                v0 = this.apolloClient.mutation(mutation).execute($continuation);
                if (v0 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl30
            }
            case 1: {
                get = (Function1)$continuation.L$2;
                warningConsumer = (Consumer)$continuation.L$1;
                this = (SgGraphQLClientBase)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl30:
                // 2 sources

                result = (ApolloResponse)v0;
                return this.handleErrors(result, warningConsumer, get);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void assertThread() {
        if (!Intrinsics.areEqual(Thread.currentThread(), this.ownerThread)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final Unit logCallback$lambda$0(Function1 $log, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $log.invoke(it);
        return Unit.INSTANCE;
    }

    private static final Request _init_$lambda$1(String $proxyUser, String $proxyPass, Route route, Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = $proxyPass;
        Intrinsics.checkNotNull(string);
        String credential = Credentials.basic$default($proxyUser, string, null, 4, null);
        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
    }

    private static final boolean _init_$lambda$2(String string, SSLSession sSLSession) {
        return true;
    }

    private static final boolean _init_$lambda$3(ApolloRequest apolloRequest) {
        Intrinsics.checkNotNullParameter(apolloRequest, "<unused var>");
        return false;
    }
}

